/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.execute.ConfigurableActionProvider;
import org.netbeans.modules.gradle.execute.ProjectConfigurationSupport;
import org.netbeans.modules.gradle.spi.actions.GradleActionsProvider;
import org.netbeans.modules.gradle.spi.actions.ProjectActionMappingProvider;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.util.Lookup;

public final class ActionToTaskUtils {
    private ActionToTaskUtils() {
    }

    @NonNull
    public static List<? extends GradleActionsProvider> actionProviders(@NonNull Project project) {
        ArrayList providers = new ArrayList();
        providers.addAll(project.getLookup().lookupAll(GradleActionsProvider.class));
        providers.addAll(Lookup.getDefault().lookupAll(GradleActionsProvider.class));
        return providers;
    }

    public static Set<String> getAllSupportedActions(@NonNull Project project) {
        HashSet<String> actions = new HashSet<String>();
        for (GradleActionsProvider gradleActionsProvider : ActionToTaskUtils.actionProviders(project)) {
            actions.addAll(gradleActionsProvider.getSupportedActions());
        }
        ProjectActionMappingProvider projectProvider = (ProjectActionMappingProvider)project.getLookup().lookup(ProjectActionMappingProvider.class);
        ConfigurableActionProvider configurableActionProvider = (ConfigurableActionProvider)project.getLookup().lookup(ConfigurableActionProvider.class);
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
        if (configurableActionProvider == null || projectProvider == null) {
            return actions;
        }
        if (pcp == null || configurableActionProvider == null) {
            actions.addAll(projectProvider.customizedActions());
        } else {
            for (GradleExecConfiguration gec : pcp.getConfigurations()) {
                projectProvider = configurableActionProvider.findActionProvider(gec.getId());
                if (projectProvider == null) continue;
                actions.addAll(projectProvider.customizedActions());
            }
        }
        return actions;
    }

    public static boolean isCustomMapping(ActionMapping am) {
        return am.getName().startsWith("custom-");
    }

    public static boolean isActionEnabled(String action, ActionMapping mapping, Project project, Lookup lookup) {
        if (mapping == null) {
            mapping = ActionToTaskUtils.getActiveMapping(action, project, lookup);
        }
        if (!ActionMapping.isDisabled(mapping)) {
            if (ActionToTaskUtils.isCustomMapping(mapping)) {
                return true;
            }
            List<? extends GradleActionsProvider> providers = ActionToTaskUtils.actionProviders(project);
            for (GradleActionsProvider gradleActionsProvider : providers) {
                if (!gradleActionsProvider.isActionEnabled(action, project, lookup)) continue;
                return true;
            }
        }
        return false;
    }

    public static GradleExecConfiguration findProjectConfiguration(Project p) {
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
        return pcp == null ? null : (GradleExecConfiguration)pcp.getActiveConfiguration();
    }

    public static ActionMapping getActiveMapping(String action, Project project, Lookup context) {
        Object m;
        ProjectActionMappingProvider mp;
        ProjectConfigurationProvider cprov;
        GradleExecConfiguration c = ProjectConfigurationSupport.getEffectiveConfiguration(project, context);
        ConfigurableActionProvider contextProvider = (ConfigurableActionProvider)project.getLookup().lookup(ConfigurableActionProvider.class);
        if (c == null && (cprov = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class)) != null) {
            c = (GradleExecConfiguration)cprov.getActiveConfiguration();
        }
        if (c != null && (mp = contextProvider.findActionProvider(c == null ? null : c.getId())) != null && (m = mp.findMapping(action)) != null) {
            return m;
        }
        ProjectActionMappingProvider mappingProvider = null;
        for (ProjectActionMappingProvider prov : project.getLookup().lookupAll(ProjectActionMappingProvider.class)) {
            if (prov instanceof ConfigurableActionProvider) continue;
            mappingProvider = prov;
            break;
        }
        if (mappingProvider == null) {
            return null;
        }
        ProjectActionMappingProvider mp2 = mappingProvider;
        ActionMapping am = ProjectConfigurationSupport.executeWithConfiguration(project, c, () -> mp2.findMapping(action));
        if (ActionMapping.isDisabled(am)) {
            return null;
        }
        return am;
    }
}

