/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar.effpom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Extension;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Notifier;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.ReportSet;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Resource;
import org.apache.maven.model.Scm;
import org.apache.maven.model.Site;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class LocationAwareMavenXpp3Writer {
    private static final String NAMESPACE = null;
    private List<Location> locations;

    public List<Location> write(StringWriter writer, Model model) throws IOException {
        this.locations = new ArrayList<Location>();
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput((Writer)writer);
        serializer.startDocument(model.getModelEncoding(), null);
        this.writeModel(model, "project", (XmlSerializer)serializer);
        serializer.endDocument();
        return this.locations;
    }

    private StringBuffer b(XmlSerializer serializer) {
        return this.sw(serializer).getBuffer();
    }

    private StringWriter sw(XmlSerializer serializer) {
        MXSerializer ser = (MXSerializer)serializer;
        return (StringWriter)ser.getWriter();
    }

    private void logLocation(InputLocationTracker tracker, Object value, int startOffset, int endOffset) {
        InputLocation loc;
        if (tracker != null && (loc = tracker.getLocation(value)) != null) {
            this.locations.add(new Location(loc, startOffset, endOffset));
        }
    }

    private void flush(XmlSerializer serializer) {
        this.sw(serializer).flush();
    }

    private void writeValue(XmlSerializer serializer, String tag, String value, InputLocationTracker parent) throws IOException {
        this.writeValue(serializer, tag, value, parent, tag);
    }

    private void writeValue(XmlSerializer serializer, String tag, String value, InputLocationTracker parent, Object trackerId) throws IOException {
        StringBuffer b = this.b(serializer);
        serializer.startTag(NAMESPACE, tag);
        this.flush(serializer);
        int start = b.length() - tag.length() - 2;
        serializer.text(value).endTag(NAMESPACE, tag);
        this.flush(serializer);
        this.logLocation(parent, trackerId, start, b.length());
    }

    private void writeXpp3DOM(XmlSerializer serializer, Xpp3Dom root, InputLocationTracker rootTracker) throws IOException {
        StringBuffer b = this.b(serializer);
        serializer.startTag(NAMESPACE, root.getName());
        this.flush(serializer);
        int start = b.length() - root.getName().length() - 2;
        String[] attributeNames = root.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            serializer.attribute(NAMESPACE, attributeName, root.getAttribute(attributeName));
        }
        boolean config = rootTracker != null ? rootTracker.getLocation((Object)root.getName()) != null : true;
        Xpp3Dom[] children = root.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.writeXpp3DOM(serializer, children[i], (InputLocationTracker)(rootTracker != null ? rootTracker.getLocation((Object)(config ? root.getName() : root)) : null));
        }
        String value = root.getValue();
        if (value != null) {
            serializer.text(value);
        }
        serializer.endTag(NAMESPACE, root.getName()).flush();
        this.logLocation(rootTracker, config ? root.getName() : root, start, b.length());
    }

    private void writeActivation(Activation activation, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (activation.isActiveByDefault()) {
            this.writeValue(serializer, "activeByDefault", String.valueOf(activation.isActiveByDefault()), (InputLocationTracker)activation);
        }
        if (activation.getJdk() != null) {
            this.writeValue(serializer, "jdk", activation.getJdk(), (InputLocationTracker)activation);
        }
        if (activation.getOs() != null) {
            this.writeActivationOS(activation.getOs(), "os", serializer);
        }
        if (activation.getProperty() != null) {
            this.writeActivationProperty(activation.getProperty(), "property", serializer);
        }
        if (activation.getFile() != null) {
            this.writeActivationFile(activation.getFile(), "file", serializer);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)activation, "", start, b.length());
    }

    private void writeActivationFile(ActivationFile activationFile, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (activationFile.getMissing() != null) {
            this.writeValue(serializer, "missing", activationFile.getMissing(), (InputLocationTracker)activationFile);
        }
        if (activationFile.getExists() != null) {
            this.writeValue(serializer, "exists", activationFile.getExists(), (InputLocationTracker)activationFile);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)activationFile, "", start, b.length());
    }

    private void writeActivationOS(ActivationOS activationOS, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (activationOS.getName() != null) {
            this.writeValue(serializer, "name", activationOS.getName(), (InputLocationTracker)activationOS);
        }
        if (activationOS.getFamily() != null) {
            this.writeValue(serializer, "family", activationOS.getFamily(), (InputLocationTracker)activationOS);
        }
        if (activationOS.getArch() != null) {
            this.writeValue(serializer, "arch", activationOS.getArch(), (InputLocationTracker)activationOS);
        }
        if (activationOS.getVersion() != null) {
            this.writeValue(serializer, "version", activationOS.getVersion(), (InputLocationTracker)activationOS);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)activationOS, "", start, b.length());
    }

    private void writeActivationProperty(ActivationProperty activationProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (activationProperty.getName() != null) {
            this.writeValue(serializer, "name", activationProperty.getName(), (InputLocationTracker)activationProperty);
        }
        if (activationProperty.getValue() != null) {
            this.writeValue(serializer, "value", activationProperty.getValue(), (InputLocationTracker)activationProperty);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)activationProperty, "", start, b.length());
    }

    private void writeBuild(Build build, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (build.getSourceDirectory() != null) {
            this.writeValue(serializer, "sourceDirectory", build.getSourceDirectory(), (InputLocationTracker)build);
        }
        if (build.getScriptSourceDirectory() != null) {
            this.writeValue(serializer, "scriptSourceDirectory", build.getScriptSourceDirectory(), (InputLocationTracker)build);
        }
        if (build.getTestSourceDirectory() != null) {
            this.writeValue(serializer, "testSourceDirectory", build.getTestSourceDirectory(), (InputLocationTracker)build);
        }
        if (build.getOutputDirectory() != null) {
            this.writeValue(serializer, "outputDirectory", build.getOutputDirectory(), (InputLocationTracker)build);
        }
        if (build.getTestOutputDirectory() != null) {
            this.writeValue(serializer, "testOutputDirectory", build.getTestOutputDirectory(), (InputLocationTracker)build);
        }
        if (build.getExtensions() != null && build.getExtensions().size() > 0) {
            serializer.startTag(NAMESPACE, "extensions");
            for (Extension o : build.getExtensions()) {
                this.writeExtension(o, "extension", serializer);
            }
            serializer.endTag(NAMESPACE, "extensions");
        }
        if (build.getDefaultGoal() != null) {
            this.writeValue(serializer, "defaultGoal", build.getDefaultGoal(), (InputLocationTracker)build);
        }
        if (build.getResources() != null && build.getResources().size() > 0) {
            serializer.startTag(NAMESPACE, "resources");
            for (Extension o : build.getResources()) {
                this.writeResource((Resource)o, "resource", serializer);
            }
            serializer.endTag(NAMESPACE, "resources");
        }
        if (build.getTestResources() != null && build.getTestResources().size() > 0) {
            serializer.startTag(NAMESPACE, "testResources");
            for (Extension o : build.getTestResources()) {
                this.writeResource((Resource)o, "testResource", serializer);
            }
            serializer.endTag(NAMESPACE, "testResources");
        }
        if (build.getDirectory() != null) {
            this.writeValue(serializer, "directory", build.getDirectory(), (InputLocationTracker)build);
        }
        if (build.getFinalName() != null) {
            this.writeValue(serializer, "finalName", build.getFinalName(), (InputLocationTracker)build);
        }
        if (build.getFilters() != null && build.getFilters().size() > 0) {
            serializer.startTag(NAMESPACE, "filters");
            this.flush(serializer);
            int start2 = b.length();
            InputLocation filtersTracker = build.getLocation((Object)"filters");
            int index = 0;
            for (String filter : build.getFilters()) {
                this.writeValue(serializer, "filter", filter, (InputLocationTracker)filtersTracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "filters").flush();
            this.logLocation((InputLocationTracker)build, "filters", start2, b.length());
        }
        if (build.getPluginManagement() != null) {
            this.writePluginManagement(build.getPluginManagement(), "pluginManagement", serializer);
        }
        if (build.getPlugins() != null && build.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (Extension o : build.getPlugins()) {
                this.writePlugin((Plugin)o, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)build, "", start, b.length());
    }

    private void writeBuildBase(BuildBase buildBase, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (buildBase.getDefaultGoal() != null) {
            this.writeValue(serializer, "defaultGoal", buildBase.getDefaultGoal(), (InputLocationTracker)buildBase);
        }
        if (buildBase.getResources() != null && buildBase.getResources().size() > 0) {
            serializer.startTag(NAMESPACE, "resources");
            for (Resource o : buildBase.getResources()) {
                this.writeResource(o, "resource", serializer);
            }
            serializer.endTag(NAMESPACE, "resources");
        }
        if (buildBase.getTestResources() != null && buildBase.getTestResources().size() > 0) {
            serializer.startTag(NAMESPACE, "testResources");
            for (Resource o : buildBase.getTestResources()) {
                this.writeResource(o, "testResource", serializer);
            }
            serializer.endTag(NAMESPACE, "testResources");
        }
        if (buildBase.getDirectory() != null) {
            this.writeValue(serializer, "directory", buildBase.getDirectory(), (InputLocationTracker)buildBase);
        }
        if (buildBase.getFinalName() != null) {
            this.writeValue(serializer, "finalName", buildBase.getFinalName(), (InputLocationTracker)buildBase);
        }
        if (buildBase.getFilters() != null && buildBase.getFilters().size() > 0) {
            serializer.startTag(NAMESPACE, "filters");
            this.flush(serializer);
            int start2 = b.length();
            InputLocation filtersTracker = buildBase.getLocation((Object)"filters");
            int index = 0;
            for (String filter : buildBase.getFilters()) {
                this.writeValue(serializer, "filter", filter, (InputLocationTracker)filtersTracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "filters").flush();
            this.logLocation((InputLocationTracker)buildBase, "filters", start2, b.length());
        }
        if (buildBase.getPluginManagement() != null) {
            this.writePluginManagement(buildBase.getPluginManagement(), "pluginManagement", serializer);
        }
        if (buildBase.getPlugins() != null && buildBase.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (Resource o : buildBase.getPlugins()) {
                this.writePlugin((Plugin)o, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)buildBase, "", start, b.length());
    }

    private void writeCiManagement(CiManagement ciManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (ciManagement.getSystem() != null) {
            this.writeValue(serializer, "system", ciManagement.getSystem(), (InputLocationTracker)ciManagement);
        }
        if (ciManagement.getUrl() != null) {
            this.writeValue(serializer, "url", ciManagement.getUrl(), (InputLocationTracker)ciManagement);
        }
        if (ciManagement.getNotifiers() != null && ciManagement.getNotifiers().size() > 0) {
            serializer.startTag(NAMESPACE, "notifiers");
            for (Notifier o : ciManagement.getNotifiers()) {
                this.writeNotifier(o, "notifier", serializer);
            }
            serializer.endTag(NAMESPACE, "notifiers");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)ciManagement, "", start, b.length());
    }

    private void writeContributor(Contributor contributor, String tagName, XmlSerializer serializer) throws IOException {
        int start2;
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (contributor.getName() != null) {
            this.writeValue(serializer, "name", contributor.getName(), (InputLocationTracker)contributor);
        }
        if (contributor.getEmail() != null) {
            this.writeValue(serializer, "email", contributor.getEmail(), (InputLocationTracker)contributor);
        }
        if (contributor.getUrl() != null) {
            this.writeValue(serializer, "url", contributor.getUrl(), (InputLocationTracker)contributor);
        }
        if (contributor.getOrganization() != null) {
            this.writeValue(serializer, "organization", contributor.getOrganization(), (InputLocationTracker)contributor);
        }
        if (contributor.getOrganizationUrl() != null) {
            this.writeValue(serializer, "organizationUrl", contributor.getOrganizationUrl(), (InputLocationTracker)contributor);
        }
        if (contributor.getRoles() != null && contributor.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "roles");
            this.flush(serializer);
            start2 = b.length();
            InputLocation rolesTracker = contributor.getLocation((Object)"roles");
            int index = 0;
            for (String role : contributor.getRoles()) {
                this.writeValue(serializer, "role", role, (InputLocationTracker)rolesTracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "roles").flush();
            this.logLocation((InputLocationTracker)contributor, "roles", start2, b.length());
        }
        if (contributor.getTimezone() != null) {
            this.writeValue(serializer, "timezone", contributor.getTimezone(), (InputLocationTracker)contributor);
            serializer.startTag(NAMESPACE, "timezone").text(contributor.getTimezone()).endTag(NAMESPACE, "timezone");
        }
        if (contributor.getProperties() != null && contributor.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            this.flush(serializer);
            start2 = b.length();
            InputLocation propTracker = contributor.getLocation((Object)"properties");
            for (String string : contributor.getProperties().keySet()) {
                String value = (String)contributor.getProperties().get(string);
                this.writeValue(serializer, string, value, (InputLocationTracker)propTracker);
            }
            serializer.endTag(NAMESPACE, "properties").flush();
            this.logLocation((InputLocationTracker)contributor, "properties", start2, b.length());
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)contributor, "", start, b.length());
    }

    private void writeDependency(Dependency dependency, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (dependency.getGroupId() != null) {
            this.writeValue(serializer, "groupId", dependency.getGroupId(), (InputLocationTracker)dependency);
        }
        if (dependency.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", dependency.getArtifactId(), (InputLocationTracker)dependency);
        }
        if (dependency.getVersion() != null) {
            this.writeValue(serializer, "version", dependency.getVersion(), (InputLocationTracker)dependency);
        }
        if (dependency.getType() != null && !dependency.getType().equals("jar")) {
            this.writeValue(serializer, "type", dependency.getType(), (InputLocationTracker)dependency);
        }
        if (dependency.getClassifier() != null) {
            this.writeValue(serializer, "classifier", dependency.getClassifier(), (InputLocationTracker)dependency);
        }
        if (dependency.getScope() != null) {
            this.writeValue(serializer, "scope", dependency.getScope(), (InputLocationTracker)dependency);
        }
        if (dependency.getSystemPath() != null) {
            this.writeValue(serializer, "systemPath", dependency.getSystemPath(), (InputLocationTracker)dependency);
        }
        if (dependency.getExclusions() != null && dependency.getExclusions().size() > 0) {
            serializer.startTag(NAMESPACE, "exclusions");
            for (Exclusion o : dependency.getExclusions()) {
                this.writeExclusion(o, "exclusion", serializer);
            }
            serializer.endTag(NAMESPACE, "exclusions");
        }
        if (dependency.getOptional() != null) {
            this.writeValue(serializer, "optional", dependency.getOptional(), (InputLocationTracker)dependency);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)dependency, "", start, b.length());
    }

    private void writeDependencyManagement(DependencyManagement dependencyManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (dependencyManagement.getDependencies() != null && dependencyManagement.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencies");
            for (Dependency o : dependencyManagement.getDependencies()) {
                this.writeDependency(o, "dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencies");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeDeploymentRepository(DeploymentRepository deploymentRepository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (!deploymentRepository.isUniqueVersion()) {
            this.writeValue(serializer, "uniqueVersion", String.valueOf(deploymentRepository.isUniqueVersion()), (InputLocationTracker)deploymentRepository);
        }
        if (deploymentRepository.getReleases() != null) {
            this.writeRepositoryPolicy(deploymentRepository.getReleases(), "releases", serializer);
        }
        if (deploymentRepository.getSnapshots() != null) {
            this.writeRepositoryPolicy(deploymentRepository.getSnapshots(), "snapshots", serializer);
        }
        if (deploymentRepository.getId() != null) {
            this.writeValue(serializer, "id", deploymentRepository.getId(), (InputLocationTracker)deploymentRepository);
        }
        if (deploymentRepository.getName() != null) {
            this.writeValue(serializer, "name", deploymentRepository.getName(), (InputLocationTracker)deploymentRepository);
        }
        if (deploymentRepository.getUrl() != null) {
            this.writeValue(serializer, "url", deploymentRepository.getUrl(), (InputLocationTracker)deploymentRepository);
        }
        if (deploymentRepository.getLayout() != null && !deploymentRepository.getLayout().equals("default")) {
            this.writeValue(serializer, "layout", deploymentRepository.getLayout(), (InputLocationTracker)deploymentRepository);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)deploymentRepository, "", start, b.length());
    }

    private void writeDeveloper(Developer developer, String tagName, XmlSerializer serializer) throws IOException {
        int start2;
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (developer.getId() != null) {
            this.writeValue(serializer, "id", developer.getId(), (InputLocationTracker)developer);
        }
        if (developer.getName() != null) {
            this.writeValue(serializer, "name", developer.getName(), (InputLocationTracker)developer);
        }
        if (developer.getEmail() != null) {
            this.writeValue(serializer, "email", developer.getEmail(), (InputLocationTracker)developer);
        }
        if (developer.getUrl() != null) {
            this.writeValue(serializer, "url", developer.getUrl(), (InputLocationTracker)developer);
        }
        if (developer.getOrganization() != null) {
            this.writeValue(serializer, "organization", developer.getOrganization(), (InputLocationTracker)developer);
        }
        if (developer.getOrganizationUrl() != null) {
            this.writeValue(serializer, "organizationUrl", developer.getOrganizationUrl(), (InputLocationTracker)developer);
        }
        if (developer.getRoles() != null && developer.getRoles().size() > 0) {
            serializer.startTag(NAMESPACE, "roles");
            this.flush(serializer);
            start2 = b.length();
            InputLocation rolesTracker = developer.getLocation((Object)"roles");
            int index = 0;
            for (String role : developer.getRoles()) {
                this.writeValue(serializer, "role", role, (InputLocationTracker)rolesTracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "roles").flush();
            this.logLocation((InputLocationTracker)developer, "roles", start2, b.length());
        }
        if (developer.getTimezone() != null) {
            this.writeValue(serializer, "timezone", developer.getTimezone(), (InputLocationTracker)developer);
        }
        if (developer.getProperties() != null && developer.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            this.flush(serializer);
            start2 = b.length();
            InputLocation propTracker = developer.getLocation((Object)"properties");
            for (String string : developer.getProperties().keySet()) {
                String value = (String)developer.getProperties().get(string);
                this.writeValue(serializer, string, value, (InputLocationTracker)propTracker);
            }
            serializer.endTag(NAMESPACE, "properties").flush();
            this.logLocation((InputLocationTracker)developer, "properties", start2, b.length());
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)developer, "", start, b.length());
    }

    private void writeDistributionManagement(DistributionManagement distributionManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (distributionManagement.getRepository() != null) {
            this.writeDeploymentRepository(distributionManagement.getRepository(), "repository", serializer);
        }
        if (distributionManagement.getSnapshotRepository() != null) {
            this.writeDeploymentRepository(distributionManagement.getSnapshotRepository(), "snapshotRepository", serializer);
        }
        if (distributionManagement.getSite() != null) {
            this.writeSite(distributionManagement.getSite(), "site", serializer);
        }
        if (distributionManagement.getDownloadUrl() != null) {
            this.writeValue(serializer, "downloadUrl", distributionManagement.getDownloadUrl(), (InputLocationTracker)distributionManagement);
        }
        if (distributionManagement.getRelocation() != null) {
            this.writeRelocation(distributionManagement.getRelocation(), "relocation", serializer);
        }
        if (distributionManagement.getStatus() != null) {
            this.writeValue(serializer, "status", distributionManagement.getStatus(), (InputLocationTracker)distributionManagement);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)distributionManagement, "", start, b.length());
    }

    private void writeExclusion(Exclusion exclusion, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (exclusion.getGroupId() != null) {
            this.writeValue(serializer, "groupId", exclusion.getGroupId(), (InputLocationTracker)exclusion);
        }
        if (exclusion.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", exclusion.getArtifactId(), (InputLocationTracker)exclusion);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)exclusion, "", start, b.length());
    }

    private void writeExtension(Extension extension, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (extension.getGroupId() != null) {
            this.writeValue(serializer, "groupId", extension.getGroupId(), (InputLocationTracker)extension);
        }
        if (extension.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", extension.getArtifactId(), (InputLocationTracker)extension);
        }
        if (extension.getVersion() != null) {
            this.writeValue(serializer, "version", extension.getVersion(), (InputLocationTracker)extension);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)extension, "", start, b.length());
    }

    private void writeIssueManagement(IssueManagement issueManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (issueManagement.getSystem() != null) {
            this.writeValue(serializer, "system", issueManagement.getSystem(), (InputLocationTracker)issueManagement);
        }
        if (issueManagement.getUrl() != null) {
            this.writeValue(serializer, "url", issueManagement.getUrl(), (InputLocationTracker)issueManagement);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)issueManagement, "", start, b.length());
    }

    private void writeLicense(License license, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (license.getName() != null) {
            this.writeValue(serializer, "name", license.getName(), (InputLocationTracker)license);
        }
        if (license.getUrl() != null) {
            this.writeValue(serializer, "url", license.getUrl(), (InputLocationTracker)license);
        }
        if (license.getDistribution() != null) {
            this.writeValue(serializer, "distribution", license.getDistribution(), (InputLocationTracker)license);
        }
        if (license.getComments() != null) {
            this.writeValue(serializer, "comments", license.getComments(), (InputLocationTracker)license);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)license, "", start, b.length());
    }

    private void writeMailingList(MailingList mailingList, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (mailingList.getName() != null) {
            this.writeValue(serializer, "name", mailingList.getName(), (InputLocationTracker)mailingList);
        }
        if (mailingList.getSubscribe() != null) {
            this.writeValue(serializer, "subscribe", mailingList.getSubscribe(), (InputLocationTracker)mailingList);
        }
        if (mailingList.getUnsubscribe() != null) {
            this.writeValue(serializer, "unsubscribe", mailingList.getUnsubscribe(), (InputLocationTracker)mailingList);
        }
        if (mailingList.getPost() != null) {
            this.writeValue(serializer, "post", mailingList.getPost(), (InputLocationTracker)mailingList);
        }
        if (mailingList.getArchive() != null) {
            this.writeValue(serializer, "archive", mailingList.getArchive(), (InputLocationTracker)mailingList);
        }
        if (mailingList.getOtherArchives() != null && mailingList.getOtherArchives().size() > 0) {
            serializer.startTag(NAMESPACE, "otherArchives");
            this.flush(serializer);
            InputLocation otherLoc = mailingList.getLocation((Object)"otherArchives");
            int index = 0;
            for (String otherArchive : mailingList.getOtherArchives()) {
                this.writeValue(serializer, "otherArchive", otherArchive, (InputLocationTracker)otherLoc, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "otherArchives");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)mailingList, "", start, b.length());
    }

    private void writeModel(Model model, String tagName, XmlSerializer serializer) throws IOException {
        serializer.setPrefix("", "http://maven.apache.org/POM/4.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd");
        StringBuffer b = this.b(serializer);
        if (model.getModelVersion() != null) {
            this.writeValue(serializer, "modelVersion", model.getModelVersion(), (InputLocationTracker)model);
        }
        if (model.getParent() != null) {
            this.writeParent(model.getParent(), "parent", serializer);
        }
        if (model.getGroupId() != null) {
            this.writeValue(serializer, "groupId", model.getGroupId(), (InputLocationTracker)model);
        }
        if (model.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", model.getArtifactId(), (InputLocationTracker)model);
        }
        if (model.getVersion() != null) {
            this.writeValue(serializer, "version", model.getVersion(), (InputLocationTracker)model);
        }
        if (model.getPackaging() != null && !model.getPackaging().equals("jar")) {
            this.writeValue(serializer, "packaging", model.getPackaging(), (InputLocationTracker)model);
        }
        if (model.getName() != null) {
            this.writeValue(serializer, "name", model.getName(), (InputLocationTracker)model);
        }
        if (model.getDescription() != null) {
            this.writeValue(serializer, "description", model.getDescription(), (InputLocationTracker)model);
        }
        if (model.getUrl() != null) {
            this.writeValue(serializer, "url", model.getUrl(), (InputLocationTracker)model);
        }
        if (model.getInceptionYear() != null) {
            this.writeValue(serializer, "inceptionYear", model.getInceptionYear(), (InputLocationTracker)model);
        }
        if (model.getOrganization() != null) {
            this.writeOrganization(model.getOrganization(), "organization", serializer);
        }
        if (model.getLicenses() != null && model.getLicenses().size() > 0) {
            serializer.startTag(NAMESPACE, "licenses");
            for (License o : model.getLicenses()) {
                this.writeLicense(o, "license", serializer);
            }
            serializer.endTag(NAMESPACE, "licenses");
        }
        if (model.getDevelopers() != null && model.getDevelopers().size() > 0) {
            serializer.startTag(NAMESPACE, "developers");
            for (License o : model.getDevelopers()) {
                this.writeDeveloper((Developer)o, "developer", serializer);
            }
            serializer.endTag(NAMESPACE, "developers");
        }
        if (model.getContributors() != null && model.getContributors().size() > 0) {
            serializer.startTag(NAMESPACE, "contributors");
            for (License o : model.getContributors()) {
                this.writeContributor((Contributor)o, "contributor", serializer);
            }
            serializer.endTag(NAMESPACE, "contributors");
        }
        if (model.getMailingLists() != null && model.getMailingLists().size() > 0) {
            serializer.startTag(NAMESPACE, "mailingLists");
            for (License o : model.getMailingLists()) {
                this.writeMailingList((MailingList)o, "mailingList", serializer);
            }
            serializer.endTag(NAMESPACE, "mailingLists");
        }
        if (model.getPrerequisites() != null) {
            this.writePrerequisites(model.getPrerequisites(), "prerequisites", serializer);
        }
        if (model.getModules() != null && model.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "modules");
            this.flush(serializer);
            int start2 = b.length();
            int index = 0;
            InputLocation tracker = model.getLocation((Object)"modules");
            for (String module : model.getModules()) {
                this.writeValue(serializer, "module", module, (InputLocationTracker)tracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "modules").flush();
            this.logLocation((InputLocationTracker)model, "modules", start2, b.length());
        }
        if (model.getScm() != null) {
            this.writeScm(model.getScm(), "scm", serializer);
        }
        if (model.getIssueManagement() != null) {
            this.writeIssueManagement(model.getIssueManagement(), "issueManagement", serializer);
        }
        if (model.getCiManagement() != null) {
            this.writeCiManagement(model.getCiManagement(), "ciManagement", serializer);
        }
        if (model.getDistributionManagement() != null) {
            this.writeDistributionManagement(model.getDistributionManagement(), "distributionManagement", serializer);
        }
        if (model.getProperties() != null && model.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            this.flush(serializer);
            int start2 = b.length();
            InputLocation tracker = model.getLocation((Object)"properties");
            for (String string : model.getProperties().keySet()) {
                String value = (String)model.getProperties().get(string);
                this.writeValue(serializer, string, value, (InputLocationTracker)tracker);
            }
            serializer.endTag(NAMESPACE, "properties").flush();
            this.logLocation((InputLocationTracker)model, "properties", start2, b.length());
        }
        if (model.getDependencyManagement() != null) {
            this.writeDependencyManagement(model.getDependencyManagement(), "dependencyManagement", serializer);
        }
        if (model.getDependencies() != null && model.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencies");
            for (Dependency o : model.getDependencies()) {
                this.writeDependency(o, "dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencies");
        }
        if (model.getRepositories() != null && model.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "repositories");
            for (Repository o : model.getRepositories()) {
                this.writeRepository(o, "repository", serializer);
            }
            serializer.endTag(NAMESPACE, "repositories");
        }
        if (model.getPluginRepositories() != null && model.getPluginRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "pluginRepositories");
            for (Repository o : model.getPluginRepositories()) {
                this.writeRepository(o, "pluginRepository", serializer);
            }
            serializer.endTag(NAMESPACE, "pluginRepositories");
        }
        if (model.getBuild() != null) {
            this.writeBuild(model.getBuild(), "build", serializer);
        }
        if (model.getReports() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)model.getReports(), (InputLocationTracker)model);
        }
        if (model.getReporting() != null) {
            this.writeReporting(model.getReporting(), "reporting", serializer);
        }
        if (model.getProfiles() != null && model.getProfiles().size() > 0) {
            serializer.startTag(NAMESPACE, "profiles");
            for (Profile o : model.getProfiles()) {
                this.writeProfile(o, "profile", serializer);
            }
            serializer.endTag(NAMESPACE, "profiles");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeNotifier(Notifier notifier, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (notifier.getType() != null && !notifier.getType().equals("mail")) {
            this.writeValue(serializer, "type", notifier.getType(), (InputLocationTracker)notifier);
        }
        if (!notifier.isSendOnError()) {
            this.writeValue(serializer, "sendOnError", String.valueOf(notifier.isSendOnError()), (InputLocationTracker)notifier);
        }
        if (!notifier.isSendOnFailure()) {
            this.writeValue(serializer, "sendOnFailure", String.valueOf(notifier.isSendOnFailure()), (InputLocationTracker)notifier);
        }
        if (!notifier.isSendOnSuccess()) {
            this.writeValue(serializer, "sendOnSuccess", String.valueOf(notifier.isSendOnSuccess()), (InputLocationTracker)notifier);
        }
        if (!notifier.isSendOnWarning()) {
            this.writeValue(serializer, "sendOnWarning", String.valueOf(notifier.isSendOnWarning()), (InputLocationTracker)notifier);
        }
        if (notifier.getAddress() != null) {
            this.writeValue(serializer, "address", notifier.getAddress(), (InputLocationTracker)notifier);
        }
        if (notifier.getConfiguration() != null && notifier.getConfiguration().size() > 0) {
            serializer.startTag(NAMESPACE, "configuration");
            for (String string : notifier.getConfiguration().keySet()) {
                String value = (String)notifier.getConfiguration().get(string);
                serializer.startTag(NAMESPACE, "" + string + "").text(value).endTag(NAMESPACE, "" + string + "");
            }
            serializer.endTag(NAMESPACE, "configuration");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)notifier, "", start, b.length());
    }

    private void writeOrganization(Organization organization, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (organization.getName() != null) {
            this.writeValue(serializer, "name", organization.getName(), (InputLocationTracker)organization);
        }
        if (organization.getUrl() != null) {
            this.writeValue(serializer, "url", organization.getUrl(), (InputLocationTracker)organization);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)organization, "", start, b.length());
    }

    private void writeParent(Parent parent, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (parent.getGroupId() != null) {
            this.writeValue(serializer, "groupId", parent.getGroupId(), (InputLocationTracker)parent);
        }
        if (parent.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", parent.getArtifactId(), (InputLocationTracker)parent);
        }
        if (parent.getVersion() != null) {
            this.writeValue(serializer, "version", parent.getVersion(), (InputLocationTracker)parent);
        }
        if (parent.getRelativePath() != null && !parent.getRelativePath().equals("../pom.xml")) {
            this.writeValue(serializer, "relativePath", parent.getRelativePath(), (InputLocationTracker)parent);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)parent, "", start, b.length());
    }

    private void writePlugin(Plugin plugin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (plugin.getGroupId() != null && !plugin.getGroupId().equals("org.apache.maven.plugins")) {
            this.writeValue(serializer, "groupId", plugin.getGroupId(), (InputLocationTracker)plugin);
        }
        if (plugin.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", plugin.getArtifactId(), (InputLocationTracker)plugin);
        }
        if (plugin.getVersion() != null) {
            this.writeValue(serializer, "version", plugin.getVersion(), (InputLocationTracker)plugin);
        }
        if (plugin.getExtensions() != null) {
            this.writeValue(serializer, "extensions", plugin.getExtensions(), (InputLocationTracker)plugin);
        }
        if (plugin.getExecutions() != null && plugin.getExecutions().size() > 0) {
            serializer.startTag(NAMESPACE, "executions");
            for (PluginExecution o : plugin.getExecutions()) {
                this.writePluginExecution(o, "execution", serializer);
            }
            serializer.endTag(NAMESPACE, "executions");
        }
        if (plugin.getDependencies() != null && plugin.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencies");
            for (PluginExecution o : plugin.getDependencies()) {
                this.writeDependency((Dependency)o, "dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencies");
        }
        if (plugin.getGoals() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)plugin.getGoals(), (InputLocationTracker)plugin);
        }
        if (plugin.getInherited() != null) {
            this.writeValue(serializer, "inherited", plugin.getInherited(), (InputLocationTracker)plugin);
        }
        if (plugin.getConfiguration() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)plugin.getConfiguration(), (InputLocationTracker)plugin);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)plugin, "", start, b.length());
    }

    private void writePluginExecution(PluginExecution pluginExecution, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (pluginExecution.getId() != null && !pluginExecution.getId().equals("default")) {
            this.writeValue(serializer, "id", pluginExecution.getId(), (InputLocationTracker)pluginExecution);
        }
        if (pluginExecution.getPhase() != null) {
            this.writeValue(serializer, "phase", pluginExecution.getPhase(), (InputLocationTracker)pluginExecution);
        }
        if (pluginExecution.getGoals() != null && pluginExecution.getGoals().size() > 0) {
            serializer.startTag(NAMESPACE, "goals");
            this.flush(serializer);
            int start2 = b.length();
            int index = 0;
            InputLocation tracker = pluginExecution.getLocation((Object)"goals");
            for (String goal : pluginExecution.getGoals()) {
                this.writeValue(serializer, "goal", goal, (InputLocationTracker)tracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "goals").flush();
            this.logLocation((InputLocationTracker)pluginExecution, "goals", start2, b.length());
        }
        if (pluginExecution.getInherited() != null) {
            this.writeValue(serializer, "inherited", pluginExecution.getInherited(), (InputLocationTracker)pluginExecution);
        }
        if (pluginExecution.getConfiguration() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)pluginExecution.getConfiguration(), (InputLocationTracker)pluginExecution);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)pluginExecution, "", start, b.length());
    }

    private void writePluginManagement(PluginManagement pluginManagement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (pluginManagement.getPlugins() != null && pluginManagement.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (Plugin o : pluginManagement.getPlugins()) {
                this.writePlugin(o, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)pluginManagement, "", start, b.length());
    }

    private void writePrerequisites(Prerequisites prerequisites, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (prerequisites.getMaven() != null && !prerequisites.getMaven().equals("2.0")) {
            this.writeValue(serializer, "maven", prerequisites.getMaven(), (InputLocationTracker)prerequisites);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)prerequisites, "", start, b.length());
    }

    private void writeProfile(Profile profile, String tagName, XmlSerializer serializer) throws IOException {
        int start2;
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (profile.getId() != null && !profile.getId().equals("default")) {
            this.writeValue(serializer, "id", profile.getId(), (InputLocationTracker)profile);
        }
        if (profile.getActivation() != null) {
            this.writeActivation(profile.getActivation(), "activation", serializer);
        }
        if (profile.getBuild() != null) {
            this.writeBuildBase(profile.getBuild(), "build", serializer);
        }
        if (profile.getModules() != null && profile.getModules().size() > 0) {
            serializer.startTag(NAMESPACE, "modules");
            this.flush(serializer);
            start2 = b.length();
            int index = 0;
            InputLocation tracker = profile.getLocation((Object)"modules");
            for (String module : profile.getModules()) {
                this.writeValue(serializer, "module", module, (InputLocationTracker)tracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "modules").flush();
            this.logLocation((InputLocationTracker)profile, "modules", start2, b.length());
        }
        if (profile.getDistributionManagement() != null) {
            this.writeDistributionManagement(profile.getDistributionManagement(), "distributionManagement", serializer);
        }
        if (profile.getProperties() != null && profile.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            this.flush(serializer);
            start2 = b.length();
            InputLocation tracker = profile.getLocation((Object)"properties");
            for (String string : profile.getProperties().keySet()) {
                String value = (String)profile.getProperties().get(string);
                this.writeValue(serializer, string, value, (InputLocationTracker)tracker);
            }
            serializer.endTag(NAMESPACE, "properties").flush();
            this.logLocation((InputLocationTracker)profile, "properties", start2, b.length());
        }
        if (profile.getDependencyManagement() != null) {
            this.writeDependencyManagement(profile.getDependencyManagement(), "dependencyManagement", serializer);
        }
        if (profile.getDependencies() != null && profile.getDependencies().size() > 0) {
            serializer.startTag(NAMESPACE, "dependencies");
            for (Dependency o : profile.getDependencies()) {
                this.writeDependency(o, "dependency", serializer);
            }
            serializer.endTag(NAMESPACE, "dependencies");
        }
        if (profile.getRepositories() != null && profile.getRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "repositories");
            for (Repository o : profile.getRepositories()) {
                this.writeRepository(o, "repository", serializer);
            }
            serializer.endTag(NAMESPACE, "repositories");
        }
        if (profile.getPluginRepositories() != null && profile.getPluginRepositories().size() > 0) {
            serializer.startTag(NAMESPACE, "pluginRepositories");
            for (Repository o : profile.getPluginRepositories()) {
                this.writeRepository(o, "pluginRepository", serializer);
            }
            serializer.endTag(NAMESPACE, "pluginRepositories");
        }
        if (profile.getReports() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)profile.getReports(), (InputLocationTracker)profile);
        }
        if (profile.getReporting() != null) {
            this.writeReporting(profile.getReporting(), "reporting", serializer);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)profile, "", start, b.length());
    }

    private void writeRelocation(Relocation relocation, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (relocation.getGroupId() != null) {
            this.writeValue(serializer, "groupId", relocation.getGroupId(), (InputLocationTracker)relocation);
        }
        if (relocation.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", relocation.getArtifactId(), (InputLocationTracker)relocation);
        }
        if (relocation.getVersion() != null) {
            this.writeValue(serializer, "version", relocation.getVersion(), (InputLocationTracker)relocation);
        }
        if (relocation.getMessage() != null) {
            this.writeValue(serializer, "message", relocation.getMessage(), (InputLocationTracker)relocation);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)relocation, "", start, b.length());
    }

    private void writeReportPlugin(ReportPlugin reportPlugin, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (reportPlugin.getGroupId() != null && !reportPlugin.getGroupId().equals("org.apache.maven.plugins")) {
            this.writeValue(serializer, "groupId", reportPlugin.getGroupId(), (InputLocationTracker)reportPlugin);
        }
        if (reportPlugin.getArtifactId() != null) {
            this.writeValue(serializer, "artifactId", reportPlugin.getArtifactId(), (InputLocationTracker)reportPlugin);
        }
        if (reportPlugin.getVersion() != null) {
            this.writeValue(serializer, "version", reportPlugin.getVersion(), (InputLocationTracker)reportPlugin);
        }
        if (reportPlugin.getReportSets() != null && reportPlugin.getReportSets().size() > 0) {
            serializer.startTag(NAMESPACE, "reportSets");
            for (ReportSet o : reportPlugin.getReportSets()) {
                this.writeReportSet(o, "reportSet", serializer);
            }
            serializer.endTag(NAMESPACE, "reportSets");
        }
        if (reportPlugin.getInherited() != null) {
            this.writeValue(serializer, "inherited", reportPlugin.getInherited(), (InputLocationTracker)reportPlugin);
        }
        if (reportPlugin.getConfiguration() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)reportPlugin.getConfiguration(), (InputLocationTracker)reportPlugin);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)reportPlugin, "", start, b.length());
    }

    private void writeReportSet(ReportSet reportSet, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (reportSet.getId() != null && !reportSet.getId().equals("default")) {
            this.writeValue(serializer, "id", reportSet.getId(), (InputLocationTracker)reportSet);
        }
        if (reportSet.getReports() != null && reportSet.getReports().size() > 0) {
            serializer.startTag(NAMESPACE, "reports");
            this.flush(serializer);
            int start2 = b.length();
            InputLocation tracker = reportSet.getLocation((Object)"reports");
            int index = 0;
            for (String report : reportSet.getReports()) {
                this.writeValue(serializer, "report", report, (InputLocationTracker)tracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "reports").flush();
            this.logLocation((InputLocationTracker)reportSet, "reports", start2, b.length());
        }
        if (reportSet.getInherited() != null) {
            this.writeValue(serializer, "inherited", reportSet.getInherited(), (InputLocationTracker)reportSet);
        }
        if (reportSet.getConfiguration() != null) {
            this.writeXpp3DOM(serializer, (Xpp3Dom)reportSet.getConfiguration(), (InputLocationTracker)reportSet);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)reportSet, "", start, b.length());
    }

    private void writeReporting(Reporting reporting, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (reporting.getExcludeDefaults() != null) {
            this.writeValue(serializer, "excludeDefaults", reporting.getExcludeDefaults(), (InputLocationTracker)reporting);
        }
        if (reporting.getOutputDirectory() != null) {
            this.writeValue(serializer, "outputDirectory", reporting.getOutputDirectory(), (InputLocationTracker)reporting);
        }
        if (reporting.getPlugins() != null && reporting.getPlugins().size() > 0) {
            serializer.startTag(NAMESPACE, "plugins");
            for (ReportPlugin o : reporting.getPlugins()) {
                this.writeReportPlugin(o, "plugin", serializer);
            }
            serializer.endTag(NAMESPACE, "plugins");
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)reporting, "", start, b.length());
    }

    private void writeRepository(Repository repository, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (repository.getReleases() != null) {
            this.writeRepositoryPolicy(repository.getReleases(), "releases", serializer);
        }
        if (repository.getSnapshots() != null) {
            this.writeRepositoryPolicy(repository.getSnapshots(), "snapshots", serializer);
        }
        if (repository.getId() != null) {
            this.writeValue(serializer, "id", repository.getId(), (InputLocationTracker)repository);
        }
        if (repository.getName() != null) {
            this.writeValue(serializer, "name", repository.getName(), (InputLocationTracker)repository);
        }
        if (repository.getUrl() != null) {
            this.writeValue(serializer, "url", repository.getUrl(), (InputLocationTracker)repository);
        }
        if (repository.getLayout() != null && !repository.getLayout().equals("default")) {
            this.writeValue(serializer, "layout", repository.getLayout(), (InputLocationTracker)repository);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)repository, "", start, b.length());
    }

    private void writeRepositoryPolicy(RepositoryPolicy repositoryPolicy, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (repositoryPolicy.getEnabled() != null) {
            this.writeValue(serializer, "enabled", repositoryPolicy.getEnabled(), (InputLocationTracker)repositoryPolicy);
        }
        if (repositoryPolicy.getUpdatePolicy() != null) {
            this.writeValue(serializer, "updatePolicy", repositoryPolicy.getUpdatePolicy(), (InputLocationTracker)repositoryPolicy);
        }
        if (repositoryPolicy.getChecksumPolicy() != null) {
            this.writeValue(serializer, "checksumPolicy", repositoryPolicy.getChecksumPolicy(), (InputLocationTracker)repositoryPolicy);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)repositoryPolicy, "", start, b.length());
    }

    private void writeResource(Resource resource, String tagName, XmlSerializer serializer) throws IOException {
        int index;
        InputLocation inclTracker;
        int start2;
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (resource.getTargetPath() != null) {
            this.writeValue(serializer, "targetPath", resource.getTargetPath(), (InputLocationTracker)resource);
        }
        if (resource.getFiltering() != null) {
            this.writeValue(serializer, "filtering", resource.getFiltering(), (InputLocationTracker)resource);
        }
        if (resource.getDirectory() != null) {
            this.writeValue(serializer, "directory", resource.getDirectory(), (InputLocationTracker)resource);
        }
        if (resource.getIncludes() != null && resource.getIncludes().size() > 0) {
            serializer.startTag(NAMESPACE, "includes");
            this.flush(serializer);
            start2 = b.length();
            inclTracker = resource.getLocation((Object)"includes");
            index = 0;
            for (String include : resource.getIncludes()) {
                this.writeValue(serializer, "include", include, (InputLocationTracker)inclTracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "includes").flush();
            this.logLocation((InputLocationTracker)resource, "includes", start2, b.length());
        }
        if (resource.getExcludes() != null && resource.getExcludes().size() > 0) {
            serializer.startTag(NAMESPACE, "excludes");
            this.flush(serializer);
            start2 = b.length();
            inclTracker = resource.getLocation((Object)"excludes");
            index = 0;
            for (String exclude : resource.getExcludes()) {
                this.writeValue(serializer, "exclude", exclude, (InputLocationTracker)inclTracker, index);
                ++index;
            }
            serializer.endTag(NAMESPACE, "excludes").flush();
            this.logLocation((InputLocationTracker)resource, "excludes", start2, b.length());
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)resource, "", start, b.length());
    }

    private void writeScm(Scm scm, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (scm.getConnection() != null) {
            this.writeValue(serializer, "connection", scm.getConnection(), (InputLocationTracker)scm);
        }
        if (scm.getDeveloperConnection() != null) {
            this.writeValue(serializer, "developerConnection", scm.getDeveloperConnection(), (InputLocationTracker)scm);
        }
        if (scm.getTag() != null && !scm.getTag().equals("HEAD")) {
            this.writeValue(serializer, "tag", scm.getTag(), (InputLocationTracker)scm);
        }
        if (scm.getUrl() != null) {
            this.writeValue(serializer, "url", scm.getUrl(), (InputLocationTracker)scm);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)scm, "", start, b.length());
    }

    private void writeSite(Site site, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        this.flush(serializer);
        StringBuffer b = this.b(serializer);
        int start = b.length();
        if (site.getId() != null) {
            this.writeValue(serializer, "id", site.getId(), (InputLocationTracker)site);
        }
        if (site.getName() != null) {
            this.writeValue(serializer, "name", site.getName(), (InputLocationTracker)site);
        }
        if (site.getUrl() != null) {
            this.writeValue(serializer, "url", site.getUrl(), (InputLocationTracker)site);
        }
        serializer.endTag(NAMESPACE, tagName).flush();
        this.logLocation((InputLocationTracker)site, "", start, b.length());
    }

    public static class Location {
        public final InputLocation loc;
        public final int startOffset;
        public final int endOffset;

        public Location(InputLocation loc, int startOffset, int endOffset) {
            this.loc = loc;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

