/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.UIResource;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public class ActiveConfigAction
extends CallableSystemAction
implements LookupListener,
PropertyChangeListener,
ContextAwareAction {
    private static final Logger LOGGER = Logger.getLogger(ActiveConfigAction.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ActiveConfigAction.class);
    private static final DefaultComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final Object CUSTOMIZE_ENTRY = new Object();
    private final PropertyChangeListener lst;
    private final LookupListener looklst;
    private JComboBox configListCombo;
    private boolean listeningToCombo = true;
    private Project currentProject;
    @NullAllowed
    private ProjectConfigurationProvider<?> pcp;
    private Lookup.Result<ProjectConfigurationProvider> currentResult;
    private final Lookup lookup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfigListCombo() {
        ProjectConfigurationProvider<?> _pcp;
        assert (EventQueue.isDispatchThread());
        if (this.configListCombo != null) {
            return;
        }
        LOGGER.finest("initConfigListCombo");
        this.configListCombo = new JComboBox(){
            private boolean layingOut = false;

            @Override
            public void doLayout() {
                try {
                    this.layingOut = true;
                    super.doLayout();
                }
                finally {
                    this.layingOut = false;
                }
            }

            @Override
            public Dimension getSize() {
                Dimension sz = super.getSize();
                if (!this.layingOut) {
                    sz.width = Math.max(sz.width, this.getPreferredSize().width);
                }
                return sz;
            }

            @Override
            public void setUI(ComboBoxUI ui) {
                super.setUI(ui);
                this.setRenderer(new ConfigCellRenderer());
            }
        };
        this.configListCombo.addPopupMenuListener(new PopupMenuListener(){
            private Component prevFocusOwner = null;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.prevFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                ActiveConfigAction.this.configListCombo.setFocusable(true);
                ActiveConfigAction.this.configListCombo.requestFocusInWindow();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (this.prevFocusOwner != null) {
                    this.prevFocusOwner.requestFocusInWindow();
                }
                this.prevFocusOwner = null;
                ActiveConfigAction.this.configListCombo.setFocusable(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.configListCombo.setRenderer(new ConfigCellRenderer());
        this.configListCombo.setToolTipText(Actions.cutAmpersand((String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.label")));
        this.configListCombo.setFocusable(false);
        this.configListCombo.setMaximumRowCount(20);
        ActiveConfigAction activeConfigAction = this;
        synchronized (activeConfigAction) {
            _pcp = this.pcp;
        }
        this.configurationsListChanged(_pcp == null ? null : ActiveConfigAction.getConfigurations(_pcp));
        this.configListCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ActiveConfigAction.this.listeningToCombo) {
                    return;
                }
                Object o = ActiveConfigAction.this.configListCombo.getSelectedItem();
                if (o == CUSTOMIZE_ENTRY) {
                    ProjectConfigurationProvider _pcp;
                    ActiveConfigAction activeConfigAction = ActiveConfigAction.this;
                    synchronized (activeConfigAction) {
                        _pcp = ActiveConfigAction.this.pcp;
                    }
                    ActiveConfigAction.this.activeConfigurationChanged(_pcp != null ? ActiveConfigAction.getActiveConfiguration(_pcp) : null);
                    _pcp.customize();
                } else if (o != null) {
                    ActiveConfigAction.this.activeConfigurationSelected((ProjectConfiguration)o, null);
                }
            }
        });
    }

    public ActiveConfigAction() {
        this.putValue("noIconInMenu", true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ActiveConfigAction.this.initConfigListCombo();
            }
        });
        this.lst = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectConfigurationProvider _pcp;
                ActiveConfigAction activeConfigAction = ActiveConfigAction.this;
                synchronized (activeConfigAction) {
                    _pcp = ActiveConfigAction.this.pcp;
                }
                if ("configurations".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.configurationsListChanged(_pcp != null ? ActiveConfigAction.getConfigurations(_pcp) : null);
                } else if ("activeConfiguration".equals(evt.getPropertyName())) {
                    ActiveConfigAction.this.activeConfigurationChanged(_pcp != null ? ActiveConfigAction.getActiveConfiguration(_pcp) : null);
                }
            }
        };
        this.looklst = new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                ActiveConfigAction.this.activeProjectProviderChanged();
            }
        };
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.lookup = LookupSensitiveAction.LastActivatedWindowLookup.INSTANCE;
        Lookup.Result resultPrj = this.lookup.lookupResult(Project.class);
        Lookup.Result resultDO = this.lookup.lookupResult(DataObject.class);
        resultPrj.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)resultPrj));
        resultDO.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)resultDO));
        this.refreshView(this.lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurationsListChanged(@NullAllowed Collection<? extends ProjectConfiguration> configs) {
        ProjectConfigurationProvider<?> _pcp;
        LOGGER.log(Level.FINER, "configurationsListChanged: {0}", configs);
        ActiveConfigAction activeConfigAction = this;
        synchronized (activeConfigAction) {
            _pcp = this.pcp;
        }
        if (configs == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveConfigAction.this.configListCombo.setModel(EMPTY_MODEL);
                    ActiveConfigAction.this.configListCombo.setEnabled(false);
                }
            });
        } else {
            final DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(configs.toArray());
            if (_pcp != null && _pcp.hasCustomizer()) {
                model.addElement(CUSTOMIZE_ENTRY);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveConfigAction.this.configListCombo.setModel(model);
                    ActiveConfigAction.this.configListCombo.setEnabled(true);
                }
            });
        }
        if (_pcp != null) {
            this.activeConfigurationChanged(ActiveConfigAction.getActiveConfiguration(_pcp));
        }
    }

    private void activeConfigurationChanged(final @NullAllowed ProjectConfiguration config) {
        LOGGER.log(Level.FINER, "activeConfigurationChanged: {0}", config);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block4: {
                    ActiveConfigAction.this.listeningToCombo = false;
                    try {
                        ActiveConfigAction.this.configListCombo.setSelectedIndex(-1);
                        if (config == null) break block4;
                        ComboBoxModel m = ActiveConfigAction.this.configListCombo.getModel();
                        for (int i = 0; i < m.getSize(); ++i) {
                            if (!config.equals(m.getElementAt(i))) continue;
                            ActiveConfigAction.this.configListCombo.setSelectedIndex(i);
                            break;
                        }
                    }
                    finally {
                        ActiveConfigAction.this.listeningToCombo = true;
                    }
                }
            }
        });
    }

    private synchronized void activeConfigurationSelected(final @NullAllowed ProjectConfiguration cfg, @NullAllowed ProjectConfigurationProvider<?> ppcp) {
        ProjectConfigurationProvider<?> lpcp;
        ProjectConfigurationProvider<?> projectConfigurationProvider = lpcp = ppcp != null ? ppcp : this.pcp;
        if (lpcp != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    LOGGER.log(Level.FINER, "activeConfigurationSelected: {0}", cfg);
                    Collection cfgs = lpcp.getConfigurations();
                    if (cfgs.contains(cfg)) {
                        if (cfg != null && !cfg.equals(ActiveConfigAction.getActiveConfiguration(lpcp))) {
                            try {
                                ActiveConfigAction.setActiveConfiguration(lpcp, cfg);
                            }
                            catch (IOException x) {
                                LOGGER.log(Level.WARNING, null, x);
                            }
                        }
                    } else {
                        LOGGER.log(Level.WARNING, "Unknown configuration: {0}, active project configurations: {1}", new Object[]{cfg, cfgs});
                    }
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ActiveConfigAction.class);
    }

    public String getName() {
        return "";
    }

    public void performAction() {
        Toolkit.getDefaultToolkit().beep();
    }

    public Component getToolbarPresenter() {
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        toolbarPanel.setOpaque(false);
        toolbarPanel.setMaximumSize(new Dimension(150, 80));
        toolbarPanel.setMinimumSize(new Dimension(150, 0));
        toolbarPanel.setPreferredSize(new Dimension(150, 23));
        this.initConfigListCombo();
        toolbarPanel.add((Component)this.configListCombo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(1, 6, 1, 5), 0, 0));
        return toolbarPanel;
    }

    public JMenuItem getMenuPresenter() {
        return new ConfigMenu(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeProjectChanged(Project p) {
        ProjectConfigurationProvider<?> _pcp;
        ActiveConfigAction activeConfigAction = this;
        synchronized (activeConfigAction) {
            LOGGER.log(Level.FINER, "activeProjectChanged: {0} -> {1}", new Object[]{this.currentProject, p});
            if (this.currentProject == p) {
                return;
            }
            if (this.currentResult != null) {
                this.currentResult.removeLookupListener(this.looklst);
            }
            this.currentResult = null;
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            this.currentProject = p;
            if (this.currentProject != null) {
                this.currentResult = this.currentProject.getLookup().lookupResult(ProjectConfigurationProvider.class);
                this.pcp = this.currentResult.allInstances().isEmpty() ? null : (ProjectConfigurationProvider)this.currentResult.allInstances().iterator().next();
                this.currentResult.addLookupListener(this.looklst);
                if (this.pcp != null) {
                    this.pcp.addPropertyChangeListener(this.lst);
                } else {
                    LOGGER.log(Level.FINEST, "currentResult on {0} is empty", this.currentProject);
                }
            } else {
                LOGGER.finest("currentProject is null");
                this.pcp = null;
            }
            _pcp = this.pcp;
        }
        this.configurationsListChanged(_pcp == null ? null : ActiveConfigAction.getConfigurations(_pcp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activeProjectProviderChanged() {
        ProjectConfigurationProvider<?> _pcp;
        ActiveConfigAction activeConfigAction = this;
        synchronized (activeConfigAction) {
            Collection all;
            if (this.currentResult == null) {
                return;
            }
            if (this.pcp != null) {
                this.pcp.removePropertyChangeListener(this.lst);
            }
            ProjectConfigurationProvider<?> projectConfigurationProvider = this.pcp = (all = this.currentResult.allInstances()).isEmpty() ? null : (ProjectConfigurationProvider<?>)all.iterator().next();
            if (this.pcp != null) {
                this.pcp.addPropertyChangeListener(this.lst);
            } else {
                LOGGER.finest("currentResult is empty");
            }
            _pcp = this.pcp;
        }
        this.configurationsListChanged(_pcp == null ? null : ActiveConfigAction.getConfigurations(_pcp));
    }

    public Action createContextAwareInstance(final Lookup actionContext) {
        class A
        extends AbstractAction
        implements Presenter.Popup {
            A() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new ConfigMenu(actionContext);
            }
        }
        return new A();
    }

    private static Collection<? extends ProjectConfiguration> getConfigurations(final @NonNull ProjectConfigurationProvider<?> pcp) {
        return (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectConfiguration>>(){

            public Collection<? extends ProjectConfiguration> run() {
                Collection configs = pcp.getConfigurations();
                assert (configs != null) : pcp;
                return configs;
            }
        });
    }

    @CheckForNull
    private static ProjectConfiguration getActiveConfiguration(final @NonNull ProjectConfigurationProvider<?> pcp) {
        return (ProjectConfiguration)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<ProjectConfiguration>(){

            public ProjectConfiguration run() {
                return pcp.getActiveConfiguration();
            }
        });
    }

    private static void setActiveConfiguration(@NonNull ProjectConfigurationProvider<?> pcp, final @NonNull ProjectConfiguration pc) throws IOException {
        final ProjectConfigurationProvider<?> _pcp = pcp;
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    _pcp.setActiveConfiguration(pc);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }

    private void refreshView(Lookup context) {
        Project p = OpenProjectList.getDefault().getMainProject();
        if (p != null) {
            this.activeProjectChanged(p);
        } else {
            Project[] selected = ActionsUtil.getProjectsFromLookup(context, null);
            if (selected.length == 1) {
                this.activeProjectChanged(selected[0]);
            } else {
                Project[] open = OpenProjectList.getDefault().getOpenProjects();
                if (open.length == 1) {
                    this.activeProjectChanged(open[0]);
                } else {
                    this.activeProjectChanged(null);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("MainProject") || evt.getPropertyName().equals("OpenProjects")) {
            this.refreshViewLater();
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshViewLater();
    }

    private void refreshViewLater() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ActiveConfigAction.this.refreshView(ActiveConfigAction.this.lookup);
                LOGGER.log(Level.FINEST, "view-refreshed");
            }
        });
    }

    private static class ConfigCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private Border defaultBorder = this.getBorder();

        ConfigCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String label = null;
            if (value instanceof ProjectConfiguration) {
                label = ((ProjectConfiguration)value).getDisplayName();
                this.setBorder(this.defaultBorder);
            } else if (value == CUSTOMIZE_ENTRY) {
                label = Actions.cutAmpersand((String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), this.defaultBorder));
            } else {
                assert (value == null);
                label = null;
                this.setBorder(this.defaultBorder);
            }
            this.setText(label);
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.setOpaque(true);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setOpaque(false);
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    class ConfigMenu
    extends JMenu
    implements DynamicMenuContent,
    ActionListener {
        private final Lookup context;

        ConfigMenu(Lookup context) {
            this.context = context;
            if (context != null) {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.context.label"));
            } else {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.label"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<ProjectConfigurationProvider<?>> findPCPs() {
            if (this.context != null) {
                Collection projects = this.context.lookupAll(Project.class);
                if (projects.size() > 0) {
                    HashSet toRet = new HashSet();
                    for (Project p : projects) {
                        ProjectConfigurationProvider tempPcp = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
                        if (tempPcp == null) continue;
                        toRet.add(tempPcp);
                    }
                    return toRet;
                }
                return null;
            }
            ActiveConfigAction activeConfigAction = ActiveConfigAction.this;
            synchronized (activeConfigAction) {
                if (ActiveConfigAction.this.pcp != null) {
                    return Collections.singleton(ActiveConfigAction.this.pcp);
                }
                return Collections.emptySet();
            }
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            Collection<ProjectConfigurationProvider<?>> pcps = this.findPCPs();
            if (pcps != null && pcps.size() > 0) {
                class Wrapper {
                    final ProjectConfiguration config;
                    final ProjectConfigurationProvider<?> prov;

                    public Wrapper(ProjectConfiguration config, ProjectConfigurationProvider<?> prov) {
                        this.config = config;
                        this.prov = prov;
                    }
                }
                boolean something = false;
                int size = pcps.size();
                ProjectConfiguration activeConfig = null;
                if (size == 1) {
                    activeConfig = ActiveConfigAction.getActiveConfiguration(pcps.iterator().next());
                }
                LinkedHashMap<String, ArrayList<Wrapper>> name2pc = new LinkedHashMap<String, ArrayList<Wrapper>>();
                for (ProjectConfigurationProvider<?> pcp : pcps) {
                    for (ProjectConfiguration config : ActiveConfigAction.getConfigurations(pcp)) {
                        ArrayList<Wrapper> found = (ArrayList<Wrapper>)name2pc.get(config.getDisplayName());
                        if (found == null) {
                            found = new ArrayList<Wrapper>();
                            name2pc.put(config.getDisplayName(), found);
                        }
                        found.add(new Wrapper(config, pcp));
                    }
                }
                Iterator it = name2pc.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry ent = it.next();
                    if (((Collection)ent.getValue()).size() == size) continue;
                    it.remove();
                }
                for (final Map.Entry entry : name2pc.entrySet()) {
                    boolean active = size == 1 ? ((Wrapper)((Collection)entry.getValue()).iterator().next()).config.equals(activeConfig) : false;
                    JRadioButtonMenuItem jmi = new JRadioButtonMenuItem((String)entry.getKey(), active);
                    jmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            for (Wrapper w : (Collection)entry.getValue()) {
                                ActiveConfigAction.this.activeConfigurationSelected(w.config, w.prov);
                            }
                        }
                    });
                    this.add(jmi);
                    something = true;
                }
                if (size == 1 && pcps.iterator().next().hasCustomizer()) {
                    if (something) {
                        this.addSeparator();
                    }
                    something = true;
                    JMenuItem customize = new JMenuItem();
                    Mnemonics.setLocalizedText((AbstractButton)customize, (String)NbBundle.getMessage(ActiveConfigAction.class, (String)"ActiveConfigAction.customize"));
                    customize.addActionListener(this);
                    this.add(customize);
                }
                this.setEnabled(something);
            } else {
                this.setEnabled(false);
            }
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Collection<ProjectConfigurationProvider<?>> pcp = this.findPCPs();
            if (pcp != null && pcp.size() == 1) {
                pcp.iterator().next().customize();
            }
        }
    }
}

