/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;

class FindAnonymousVisitor
extends ErrorAwareTreeScanner<Void, Void> {
    int noInner;
    boolean hasLocalClass;
    final Set<Tree> docOwners = new HashSet<Tree>();
    private Mode mode = Mode.COLLECT;

    FindAnonymousVisitor() {
    }

    public final void reset() {
        this.noInner = 0;
        this.hasLocalClass = false;
        this.mode = Mode.CHECK;
    }

    @Override
    public Void visitClass(ClassTree node, Void p) {
        if (node.getSimpleName().length() != 0) {
            this.hasLocalClass = true;
        }
        ++this.noInner;
        this.handleDoc(node);
        return (Void)super.visitClass(node, p);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        this.handleDoc(node);
        return (Void)super.visitMethod(node, p);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        this.handleDoc(node);
        return (Void)super.visitVariable(node, p);
    }

    private void handleDoc(Tree tree) {
        if (this.mode == Mode.COLLECT) {
            this.docOwners.add(tree);
        }
    }

    private static enum Mode {
        COLLECT,
        CHECK;

    }
}

