/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.ui.FailureDataDisplayer;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.spi.BuilderConnector;
import org.openide.awt.StatusDisplayer;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HudsonFailureDataProvider
extends BuilderConnector.FailureDataProvider {
    private static final Logger LOG = Logger.getLogger(HudsonFailureDataProvider.class.getName());

    @Override
    public void showFailures(final HudsonJobBuild build, final FailureDataDisplayer displayer) {
        new RequestProcessor(build.getUrl() + "failures").post(new Runnable(){

            @Override
            public void run() {
                HudsonFailureDataProvider.this.showBuildFailures(build.getJob(), build.getUrl(), displayer);
            }
        });
    }

    @Override
    public void showFailures(final HudsonMavenModuleBuild moduleBuild, final FailureDataDisplayer displayer) {
        new RequestProcessor(moduleBuild.getUrl() + "failures").post(new Runnable(){

            @Override
            public void run() {
                HudsonFailureDataProvider.this.showBuildFailures(moduleBuild.getBuild().getJob(), moduleBuild.getUrl(), displayer);
            }
        });
    }

    private void showBuildFailures(HudsonJob job, String url, FailureDataDisplayer displayer) {
        try {
            XMLReader parser = XMLUtil.createXMLReader();
            parser.setContentHandler(new ContentHandler(displayer));
            String u = url + "testReport/api/xml?xpath=//suite[case/errorStackTrace]&wrapper=failures";
            InputSource source = new InputSource(new ConnectionBuilder().job(job).url(u).connection().getInputStream());
            source.setSystemId(u);
            displayer.open();
            parser.parse(source);
        }
        catch (FileNotFoundException x) {
            Toolkit.getDefaultToolkit().beep();
            StatusDisplayer.getDefault().setStatusText(Bundle.no_test_result());
        }
        catch (Exception x) {
            Toolkit.getDefaultToolkit().beep();
            LOG.log(Level.INFO, null, x);
        }
    }

    private class ContentHandler
    extends DefaultHandler {
        private StringBuilder buf;
        private final FailureDataDisplayer displayer;
        FailureDataDisplayer.Suite suite = null;
        FailureDataDisplayer.Case caze = null;

        public ContentHandler(FailureDataDisplayer displayer) {
            this.displayer = displayer;
        }

        long parseDuration(String d) {
            if (d == null) {
                return 0L;
            }
            try {
                return (long)(1000.0f * Float.parseFloat(d));
            }
            catch (NumberFormatException x) {
                return 0L;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.matches("errorStackTrace|stdout|stderr|name|className")) {
                this.buf = new StringBuilder();
            } else if (qName.equals("suite")) {
                this.suite = new FailureDataDisplayer.Suite();
                this.caze = null;
            } else if (qName.equals("case") && this.suite != null) {
                this.caze = new FailureDataDisplayer.Case();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.buf != null) {
                this.buf.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.suite == null) {
                return;
            }
            String text = this.buf != null && this.buf.length() > 0 ? this.buf.toString() : null;
            this.buf = null;
            if (this.caze == null) {
                if (qName.equals("stdout")) {
                    this.suite.setStdout(text);
                } else if (qName.equals("stderr")) {
                    this.suite.setStderr(text);
                } else if (qName.equals("name")) {
                    this.suite.setName(text);
                } else if (qName.equals("duration")) {
                    this.suite.setDuration(this.parseDuration(text));
                }
            } else if (qName.equals("errorStackTrace")) {
                this.caze.setErrorStackTrace(text);
            } else if (qName.equals("name")) {
                this.caze.setName(text);
            } else if (qName.equals("className")) {
                this.caze.setClassName(text);
            } else if (qName.equals("duration")) {
                this.caze.setDuration(this.parseDuration(text));
            }
            if (qName.equals("case")) {
                this.suite.addCase(this.caze);
                this.caze = null;
            } else if (qName.equals("suite")) {
                try {
                    this.displayer.showSuite(this.suite);
                }
                catch (Exception x) {
                    LOG.log(Level.FINE, null, x);
                }
                this.suite = null;
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.displayer.close();
        }
    }
}

