/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.jaxws;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.WebProjectWebServicesSupport;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.ProjectJAXWSSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectJAXWSSupport
extends ProjectJAXWSSupport {
    private WebProject project;
    private static final String servletClassName = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String servletListener = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";

    public WebProjectJAXWSSupport(WebProject project, AntProjectHelper antProjectHelper) {
        super((Project)project, antProjectHelper);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject webInfFo;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (webInfFo = webModule.getWebInf()) != null) {
            FileObject wsdlFo = webInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return webInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    public String getWsdlLocation(String serviceName) {
        String localWsdlFile;
        Service service;
        String localWsdl = serviceName + ".wsdl";
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (service = jaxWsModel.findServiceByName(serviceName)) != null && (localWsdlFile = service.getLocalWsdlFile()) != null) {
            localWsdl = localWsdlFile;
        }
        String prefix = "WEB-INF/wsdl/";
        return prefix + serviceName + "/" + localWsdl;
    }

    private void addServiceEntriesToDD(String serviceName) {
        String servletName = serviceName;
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            try {
                Servlet servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{servletName, servletClassName}, "ServletName");
                servlet.setLoadOnStartup(new BigInteger("1"));
                webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{servletName, "/" + serviceName}, "ServletName");
                if (!this.webAppHasListener(webApp, servletListener)) {
                    webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{servletListener}, "ListenerClass");
                }
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (ClassNotFoundException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
            catch (NameAlreadyUsedException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
            catch (IOException exc) {
                Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
            }
        }
    }

    protected void addServletElement(Project project, String wsName, String serviceImpl) throws IOException {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            J2eePlatform j2eePlatform;
            String serverInstance;
            Map properties;
            boolean addServletEntry = false;
            JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
            if (wss != null && (properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()) != null && (serverInstance = (String)properties.get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null && j2eePlatform.isToolSupported("JaxWs-in-j2ee14-supported")) {
                addServletEntry = true;
            }
            if (addServletEntry) {
                try {
                    Servlet servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{wsName, serviceImpl}, "ServletName");
                    servlet.setLoadOnStartup(new BigInteger("1"));
                    webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{wsName, "/" + wsName}, "UrlPattern");
                    webApp.write(this.getDeploymentDescriptor());
                }
                catch (ClassNotFoundException exc) {
                    Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
                }
                catch (NameAlreadyUsedException exc) {
                    Logger.getLogger("global").log(Level.INFO, exc.getLocalizedMessage());
                }
            }
        }
    }

    private void removeServiceEntriesFromDD(String serviceName) {
        WebApp webApp = this.getWebApp();
        if (webApp != null) {
            boolean changed = this.removeNonJsr109ServletsFromDD(webApp, serviceName);
            boolean hasMoreWebServices = false;
            Servlet[] remainingServlets = webApp.getServlet();
            for (int i = 0; i < remainingServlets.length; ++i) {
                if (!remainingServlets[i].getServletClass().equals(servletClassName)) continue;
                hasMoreWebServices = true;
                break;
            }
            if (!hasMoreWebServices) {
                Listener[] listeners = webApp.getListener();
                for (int i = 0; i < listeners.length; ++i) {
                    Listener listener = listeners[i];
                    if (!listener.getListenerClass().equals(servletListener)) continue;
                    webApp.removeListener(listener);
                    changed = true;
                    break;
                }
            }
            if (changed) {
                try {
                    webApp.write(this.getDeploymentDescriptor());
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private boolean removeNonJsr109ServletsFromDD(WebApp webApp, String serviceName) {
        boolean changed = false;
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            Servlet servlet = servlets[i];
            if (!servlet.getServletName().equals(serviceName)) continue;
            webApp.removeServlet(servlet);
            changed = true;
            break;
        }
        ServletMapping[] mappings = webApp.getServletMapping();
        for (int i = 0; i < mappings.length; ++i) {
            ServletMapping mapping = mappings[i];
            if (!mapping.getServletName().equals(serviceName)) continue;
            webApp.removeServletMapping(mapping);
            changed = true;
        }
        return changed;
    }

    private boolean webAppHasListener(WebApp webApp, String listenerClass) {
        Listener[] listeners = webApp.getListener();
        for (int i = 0; i < listeners.length; ++i) {
            Listener listener = listeners[i];
            if (!listenerClass.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    public FileObject getDeploymentDescriptorFolder() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            return webModule.getWebInf();
        }
        return null;
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            Logger.getLogger("global").log(Level.INFO, e.getLocalizedMessage());
        }
        return null;
    }

    private boolean isProjectOpened() {
        if (OpenProjects.getDefault() == null) {
            return true;
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    private FileObject getDeploymentDescriptor() throws IOException {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            FileObject webInfFo;
            FileObject ddFo = webModule.getDeploymentDescriptor();
            if (ddFo == null && (webInfFo = webModule.getWebInf()) != null) {
                ddFo = DDHelper.createWebXml((Profile)webModule.getJ2eeProfile(), (FileObject)webInfFo);
            }
            return ddFo;
        }
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProjectWebServicesSupport.class, (String)"MSG_WebInfCorrupted"), 0));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addJaxwsArtifacts(Project project, String wsName, String serviceImpl) throws Exception {
        FileObject wsimportFO;
        ClassPath classPath;
        SourceGroup[] sgs = SourceGroups.getJavaSourceGroups((Project)project);
        if (sgs.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile")) != null && (wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class")) == null) {
            Library metroLib = LibraryManager.getDefault().getLibrary("metro");
            if (metroLib != null) {
                try {
                    ProjectClassPathModifier.addLibraries((Library[])new Library[]{metroLib}, (FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
                }
                catch (IOException e) {
                    throw new Exception("Unable to add Metro library", e);
                }
            } else {
                throw new Exception("Unable to add Metro Library");
            }
        }
        this.addServiceEntriesToDD(wsName);
        FileObject ddFolder = this.getDeploymentDescriptorFolder();
        if (ddFolder != null) {
            FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
            if (sunjaxwsFile == null) {
                WSUtils.generateSunJaxwsFile((FileObject)ddFolder);
            }
            sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
            Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
            Endpoint endpoint = endpoints.newEndpoint();
            endpoint.setEndpointName(wsName);
            endpoint.setImplementation(serviceImpl);
            endpoint.setUrlPattern("/" + wsName);
            endpoints.addEnpoint(endpoint);
            FileLock lock = null;
            OutputStream os = null;
            WebProjectJAXWSSupport webProjectJAXWSSupport = this;
            synchronized (webProjectJAXWSSupport) {
                try {
                    lock = sunjaxwsFile.lock();
                    os = sunjaxwsFile.getOutputStream(lock);
                    endpoints.write(os);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
        String mes = NbBundle.getMessage(WebProjectJAXWSSupport.class, (String)"MSG_CannotFindWEB-INF");
        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getWebModule().getConfDir();
    }

    public void serviceFromJavaRemoved(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Boolean isJsr109 = jaxWsModel.getJsr109();
        if (isJsr109 != null && !isJsr109.booleanValue()) {
            try {
                this.removeNonJsr109Entries(serviceName);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        } else {
            try {
                this.removeJsr109Entries(serviceName);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNonJsr109Entries(String serviceName) throws IOException {
        this.removeServiceEntriesFromDD(serviceName);
        FileObject ddFolder = this.getDeploymentDescriptorFolder();
        if (ddFolder != null) {
            FileObject sunjaxwsFile = ddFolder.getFileObject("sun-jaxws.xml");
            if (sunjaxwsFile != null) {
                FileLock lock = null;
                JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
                if (jaxWsModel.getServices().length == 0) {
                    WebProjectJAXWSSupport webProjectJAXWSSupport = this;
                    synchronized (webProjectJAXWSSupport) {
                        try {
                            lock = sunjaxwsFile.lock();
                            sunjaxwsFile.delete(lock);
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                        }
                    }
                }
                Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunjaxwsFile);
                Endpoint endpoint = endpoints.findEndpointByName(serviceName);
                if (endpoint != null) {
                    endpoints.removeEndpoint(endpoint);
                    OutputStream os = null;
                    WebProjectJAXWSSupport webProjectJAXWSSupport = this;
                    synchronized (webProjectJAXWSSupport) {
                        try {
                            lock = sunjaxwsFile.lock();
                            os = sunjaxwsFile.getOutputStream(lock);
                            endpoints.write(os);
                        }
                        finally {
                            if (lock != null) {
                                lock.releaseLock();
                            }
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                }
            }
        } else {
            String mes = NbBundle.getMessage(WebProjectJAXWSSupport.class, (String)"MSG_CannotFindDDDirectory");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
    }

    public void removeJsr109Entries(String serviceName) throws IOException {
        boolean changed;
        Service service;
        JaxWsModel jaxWsModel;
        WebApp webApp = this.getWebApp();
        if (webApp != null && (jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class)) != null && (service = jaxWsModel.findServiceByName(serviceName)) != null && (changed = this.removeJsr109ServletsFromDD(webApp, service))) {
            try {
                webApp.write(this.getDeploymentDescriptor());
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private boolean removeJsr109ServletsFromDD(WebApp webApp, Service service) {
        boolean changed = false;
        String implClass = service.getImplementationClass();
        if (implClass != null) {
            String servletName = null;
            for (Servlet servlet : webApp.getServlet()) {
                if (!implClass.equals(servlet.getServletClass())) continue;
                webApp.removeServlet(servlet);
                servletName = servlet.getServletName();
                changed = true;
                break;
            }
            if (servletName != null) {
                for (Servlet servlet : webApp.getServletMapping()) {
                    if (!servlet.getServletName().equals(servletName)) continue;
                    webApp.removeServletMapping((ServletMapping)servlet);
                    changed = true;
                    break;
                }
            }
        }
        return changed;
    }

    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109, boolean useProvider) {
        FileObject fo = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fo == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
                this.logWsDetected();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return super.addService(name, serviceImpl, wsdlUrl, serviceName, portName, packageName, isJsr109, useProvider);
    }

    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        FileObject fo = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fo == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
                this.logWsDetected();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        super.addService(serviceName, serviceImpl, isJsr109);
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        return this.project.getWebModule().getWebservicesMetadataModel();
    }

    private void logWsDetected() {
        Object[] params = new Object[]{"JAX-WS", this.project.getClass().getName(), "SERVICE"};
        LogUtils.logWsDetect((Object[])params);
    }

    protected String getProjectJavaEEVersion() {
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null) {
            if (Profile.JAVA_EE_6_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_6_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_7_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-17";
            }
            if (Profile.JAVA_EE_7_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-17";
            }
            if (Profile.JAVA_EE_8_WEB.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-18";
            }
            if (Profile.JAVA_EE_8_FULL.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-18";
            }
            if (Profile.JAKARTA_EE_8_WEB.equals(webModule.getJ2eeProfile())) {
                return "jakarta-ee-version-8";
            }
            if (Profile.JAKARTA_EE_8_FULL.equals(webModule.getJ2eeProfile())) {
                return "jakarta-ee-version-8";
            }
            if (Profile.JAKARTA_EE_9_WEB.equals(webModule.getJ2eeProfile())) {
                return "jakarta-ee-version-9";
            }
            if (Profile.JAKARTA_EE_9_FULL.equals(webModule.getJ2eeProfile())) {
                return "jakarta-ee-version-9";
            }
            if (Profile.JAKARTA_EE_9_1_WEB.equals(webModule.getJ2eeProfile())) {
                return "jakarta-ee-version-91";
            }
            if (Profile.JAKARTA_EE_9_1_FULL.equals(webModule.getJ2eeProfile())) {
                return "jakarta-ee-version-91";
            }
            if (Profile.JAVA_EE_5.equals(webModule.getJ2eeProfile())) {
                return "java-ee-version-15";
            }
        }
        return "java-ee-version-none";
    }
}

