/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.common.BulkResponseImpl;
import com.sun.xml.registry.common.util.Utility;
import com.sun.xml.registry.uddi.FuturesRequestManager;
import com.sun.xml.registry.uddi.JAXRCommand;
import com.sun.xml.registry.uddi.RegistryServiceImpl;
import com.sun.xml.registry.uddi.UDDIMapper;
import java.util.Collection;
import java.util.Locale;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.JAXRException;
import javax.xml.registry.QueryManager;
import javax.xml.registry.RegistryService;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.RegistryObject;

public class QueryManagerImpl
implements QueryManager {
    RegistryServiceImpl service;
    UDDIMapper uddi;

    public QueryManagerImpl() {
        String country = Locale.getDefault().getCountry();
        if (country == null || country == "") {
            Locale.setDefault(Locale.US);
        }
        System.out.println("Default locale: " + Locale.getDefault().toString());
    }

    public QueryManagerImpl(RegistryServiceImpl service) {
        this();
        this.service = service;
        this.uddi = service.getUDDIMapper();
    }

    public BulkResponse getRegistryObjects(Collection objectKeys) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse getRegistryObjects() throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl response = new BulkResponseImpl();
            response.setStatus(3);
            Utility.getInstance();
            response.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(response);
            FuturesRequestManager.invokeCommand(new JAXRCommand.GetRegistryObjectsCommand(this.service, response));
            return response;
        }
        return this.uddi.getRegistryObjects();
    }

    public RegistryObject getRegistryObject(String id) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public BulkResponse getRegistryObjects(String objectType) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl response = new BulkResponseImpl();
            response.setStatus(3);
            Utility.getInstance();
            response.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(response);
            FuturesRequestManager.invokeCommand(new JAXRCommand.GetRegistryObjectsByTypeCommand(this.service, response, objectType));
            return response;
        }
        return this.uddi.getRegistryObjects(objectType);
    }

    public RegistryObject getRegistryObject(String id, String type) throws JAXRException {
        return this.uddi.getRegistryObject(id, type);
    }

    public BulkResponse getRegistryObjects(Collection ids, String type) throws JAXRException {
        if (!this.service.getConnection().isSynchronous()) {
            BulkResponseImpl response = new BulkResponseImpl();
            response.setStatus(3);
            Utility.getInstance();
            response.setRequestId(Utility.generateUUID());
            this.service.storeBulkResponse(response);
            FuturesRequestManager.invokeCommand(new JAXRCommand.GetRegistryObjectsByKeysCommand(this.service, response, ids, type));
            return response;
        }
        return this.uddi.getRegistryObjects(ids, type);
    }

    public RegistryService getRegistryService() {
        return this.service;
    }
}

