/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.model.AnnotationProxyMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Array;
import javax.lang.model.AnnotatedConstruct;

public abstract class AnnoConstruct
implements AnnotatedConstruct {
    public abstract List<? extends Attribute.Compound> getAnnotationMirrors();

    protected <A extends Annotation> Attribute.Compound getAttribute(Class<A> annoType) {
        String name = annoType.getName();
        for (Attribute.Compound anno : this.getAnnotationMirrors()) {
            if (!name.equals(anno.type.tsym.flatName().toString())) continue;
            return anno;
        }
        return null;
    }

    protected <A extends Annotation> A[] getInheritedAnnotations(Class<A> annoType) {
        return (Annotation[])Array.newInstance(annoType, 0);
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annoType) {
        if (!annoType.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annoType);
        }
        Class<? extends Annotation> containerType = AnnoConstruct.getContainer(annoType);
        if (containerType == null) {
            A res = this.getAnnotation(annoType);
            int size = res == null ? 0 : 1;
            Annotation[] arr = (Annotation[])Array.newInstance(annoType, size);
            if (res != null) {
                arr[0] = res;
            }
            return arr;
        }
        String annoTypeName = annoType.getName();
        String containerTypeName = containerType.getName();
        int directIndex = -1;
        int containerIndex = -1;
        Attribute.Compound direct = null;
        Attribute.Compound container = null;
        int index = -1;
        for (Attribute.Compound attribute : this.getAnnotationMirrors()) {
            ++index;
            if (attribute.type.tsym.flatName().contentEquals(annoTypeName)) {
                directIndex = index;
                direct = attribute;
                continue;
            }
            if (containerTypeName == null || !attribute.type.tsym.flatName().contentEquals(containerTypeName)) continue;
            containerIndex = index;
            container = attribute;
        }
        if (direct == null && container == null && annoType.isAnnotationPresent(Inherited.class)) {
            return this.getInheritedAnnotations(annoType);
        }
        Attribute.Compound[] contained = this.unpackContained(container);
        if (direct == null && contained.length == 0 && annoType.isAnnotationPresent(Inherited.class)) {
            return this.getInheritedAnnotations(annoType);
        }
        int size = (direct == null ? 0 : 1) + contained.length;
        Annotation[] arr = (Annotation[])Array.newInstance(annoType, size);
        int insert = -1;
        int length = arr.length;
        if (directIndex >= 0 && containerIndex >= 0) {
            if (directIndex < containerIndex) {
                arr[0] = AnnotationProxyMaker.generateAnnotation(direct, annoType);
                insert = 1;
            } else {
                arr[arr.length - 1] = AnnotationProxyMaker.generateAnnotation(direct, annoType);
                insert = 0;
                --length;
            }
        } else {
            if (directIndex >= 0) {
                arr[0] = AnnotationProxyMaker.generateAnnotation(direct, annoType);
                return arr;
            }
            insert = 0;
        }
        int i = 0;
        while (i + insert < length) {
            arr[insert + i] = AnnotationProxyMaker.generateAnnotation(contained[i], annoType);
            ++i;
        }
        return arr;
    }

    private Attribute.Compound[] unpackContained(Attribute.Compound container) {
        Attribute[] contained0 = null;
        if (container != null) {
            contained0 = AnnoConstruct.unpackAttributes(container);
        }
        ListBuffer<Attribute.Compound> compounds = new ListBuffer<Attribute.Compound>();
        if (contained0 != null) {
            for (Attribute a : contained0) {
                Attribute attribute = a;
                if (!(attribute instanceof Attribute.Compound)) continue;
                Attribute.Compound attributeCompound = (Attribute.Compound)attribute;
                compounds = compounds.append(attributeCompound);
            }
        }
        return compounds.toArray(new Attribute.Compound[compounds.size()]);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annoType) {
        if (!annoType.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annoType);
        }
        Attribute.Compound c = this.getAttribute(annoType);
        return c == null ? null : (A)AnnotationProxyMaker.generateAnnotation(c, annoType);
    }

    private static Class<? extends Annotation> getContainer(Class<? extends Annotation> annoType) {
        Repeatable repeatable = annoType.getAnnotation(Repeatable.class);
        return repeatable == null ? null : repeatable.value();
    }

    private static Attribute[] unpackAttributes(Attribute.Compound container) {
        return ((Attribute.Array)container.member((Name)container.type.tsym.name.table.names.value)).values;
    }
}

