/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacTaskPool {
    private static final JavacTool systemProvider = JavacTool.create();
    private static final Queue<ReusableContext> EMPTY_QUEUE = new ArrayDeque<ReusableContext>(0);
    private final int maxPoolSize;
    private final Map<List<String>, Queue<ReusableContext>> options2Contexts = new HashMap<List<String>, Queue<ReusableContext>>();
    private int id;
    private int statReused = 0;
    private int statNew = 0;
    private int statPolluted = 0;
    private int statRemoved = 0;

    public JavacTaskPool(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Z> Z getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits, Worker<Z> worker) {
        ReusableContext ctx;
        List opts = StreamSupport.stream(options.spliterator(), false).collect(Collectors.toCollection(ArrayList::new));
        JavacTaskPool javacTaskPool = this;
        synchronized (javacTaskPool) {
            Queue<ReusableContext> cached = this.options2Contexts.getOrDefault(opts, EMPTY_QUEUE);
            if (cached.isEmpty()) {
                ctx = new ReusableContext(opts);
                ++this.statNew;
            } else {
                ctx = cached.remove();
                ++this.statReused;
            }
        }
        ++ctx.useCount;
        JavacTaskImpl task = (JavacTaskImpl)systemProvider.getTask(out, fileManager, diagnosticListener, opts, classes, compilationUnits, ctx);
        task.addTaskListener(ctx);
        if (out != null) {
            Log.instance(ctx).setWriters(new PrintWriter(out, true));
        }
        Z result = worker.withTask(task);
        ctx.clear();
        if (ctx.polluted) {
            ++this.statPolluted;
        } else {
            task.cleanup();
            JavacTaskPool javacTaskPool2 = this;
            synchronized (javacTaskPool2) {
                while (this.cacheSize() + 1L > (long)this.maxPoolSize) {
                    ReusableContext toRemove = (ReusableContext)this.options2Contexts.values().stream().flatMap(Collection::stream).sorted((c1, c2) -> c1.timeStamp < c2.timeStamp ? -1 : 1).findFirst().get();
                    this.options2Contexts.get(toRemove.arguments).remove(toRemove);
                    ++this.statRemoved;
                }
                this.options2Contexts.computeIfAbsent(ctx.arguments, x -> new ArrayDeque()).add(ctx);
                ctx.timeStamp = this.id++;
            }
        }
        return result;
    }

    private long cacheSize() {
        return this.options2Contexts.values().stream().flatMap(Collection::stream).count();
    }

    public void printStatistics(PrintStream out) {
        out.println(this.statReused + " reused Contexts");
        out.println(this.statNew + " newly created Contexts");
        out.println(this.statPolluted + " polluted Contexts");
        out.println(this.statRemoved + " removed Contexts");
    }

    static class ReusableContext
    extends Context
    implements TaskListener {
        Set<CompilationUnitTree> roots = new HashSet<CompilationUnitTree>();
        List<String> arguments;
        boolean polluted = false;
        int useCount;
        long timeStamp;
        TreeScanner<Void, Symtab> pollutionScanner = new TreeScanner<Void, Symtab>(){

            @Override
            public Void scan(Tree tree, Symtab syms) {
                Tree tree2 = tree;
                if (tree2 instanceof JCTree.LetExpr) {
                    JCTree.LetExpr letExpr = (JCTree.LetExpr)tree2;
                    this.scan(letExpr.defs, syms);
                    this.scan((Tree)letExpr.expr, syms);
                    return null;
                }
                return (Void)super.scan(tree, syms);
            }

            @Override
            public Void visitClass(ClassTree node, Symtab syms) {
                Symbol.ClassSymbol sym = ((JCTree.JCClassDecl)node).sym;
                if (sym != null) {
                    syms.removeClass(sym.packge().modle, ((Symbol)sym).flatName());
                    Type sup = this.supertype(sym);
                    if (this.isCoreClass(sym) || sup != null && this.isCoreClass(sup.tsym) && sup.tsym.kind != Kinds.Kind.TYP) {
                        polluted = true;
                    }
                }
                return (Void)super.visitClass(node, syms);
            }

            private boolean isCoreClass(Symbol s) {
                return s.flatName().toString().startsWith("java.");
            }

            private Type supertype(Symbol s) {
                if (s.type == null || !s.type.hasTag(TypeTag.CLASS)) {
                    return null;
                }
                Type.ClassType ct = (Type.ClassType)s.type;
                return ct.supertype_field;
            }
        };

        ReusableContext(List<String> arguments) {
            this.arguments = arguments;
            this.put(Log.logKey, ReusableLog.factory);
            this.put(JavaCompiler.compilerKey, ReusableJavaCompiler.factory);
        }

        void clear() {
            this.polluted |= this.get(JavaFileManager.class).hasLocation(StandardLocation.PATCH_MODULE_PATH);
            this.drop(Arguments.argsKey);
            this.drop(DiagnosticListener.class);
            this.drop(Log.outKey);
            this.drop(Log.errKey);
            this.drop(JavaFileManager.class);
            this.drop(JavacTask.class);
            this.drop(JavacTrees.class);
            this.drop(JavacElements.class);
            this.drop(PlatformDescription.class);
            if (this.ht.get(Log.logKey) instanceof ReusableLog) {
                ((ReusableLog)Log.instance(this)).clear();
                Enter.instance(this).newRound();
                ((ReusableJavaCompiler)ReusableJavaCompiler.instance(this)).clear();
                Types.instance(this).newRound();
                Check.instance(this).newRound();
                Check.instance(this).clear();
                Preview.instance(this).clear();
                Modules.instance(this).newRound();
                Annotate.instance(this).newRound();
                CompileStates.instance(this).clear();
                MultiTaskListener.instance(this).clear();
                Options.instance(this).clear();
                Symtab syms = Symtab.instance(this);
                this.pollutionScanner.scan(this.roots, syms);
                this.roots.clear();
            }
        }

        @Override
        public void finished(TaskEvent e) {
            if (e.getKind() == TaskEvent.Kind.PARSE) {
                this.roots.add(e.getCompilationUnit());
            }
        }

        @Override
        public void started(TaskEvent e) {
        }

        <T> void drop(Context.Key<T> k) {
            this.ht.remove(k);
        }

        <T> void drop(Class<T> c) {
            this.ht.remove(this.key(c));
        }

        static class ReusableLog
        extends Log {
            static final Context.Factory<Log> factory = ReusableLog::new;
            Context context;

            ReusableLog(Context context) {
                super(context);
                this.context = context;
            }

            void clear() {
                this.recorded.clear();
                this.sourceMap.clear();
                this.nerrors = 0;
                this.nwarnings = 0;
                this.diagListener = new DiagnosticListener<JavaFileObject>(){
                    DiagnosticListener<JavaFileObject> cachedListener;

                    @Override
                    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                        if (this.cachedListener == null) {
                            this.cachedListener = context.get(DiagnosticListener.class);
                        }
                        this.cachedListener.report(diagnostic);
                    }
                };
            }
        }

        static class ReusableJavaCompiler
        extends JavaCompiler {
            static final Context.Factory<JavaCompiler> factory = ReusableJavaCompiler::new;

            ReusableJavaCompiler(Context context) {
                super(context);
            }

            @Override
            public void close() {
            }

            void clear() {
                this.newRound();
            }

            @Override
            protected void checkReusable() {
            }
        }
    }

    public static interface Worker<Z> {
        public Z withTask(JavacTask var1);
    }
}

