/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.refactoring.ExtractInlinedStyleRefactoringPlugin;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class HtmlSourceUtils {
    public static void forceReindex(FileObject file) {
    }

    public static void rebuildTokenHierarchy(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                        if (mti != null) {
                            mti.tokenHierarchyControl().rebuild();
                        }
                    }
                });
            }
        });
    }

    public static boolean importStyleSheet(ModificationResult modificationResult, HtmlParsingResult result, Snapshot snapshot, FileObject targetFile) {
        try {
            final AtomicInteger insertPositionRef = new AtomicInteger(-1);
            final AtomicBoolean increaseIndent = new AtomicBoolean();
            final AtomicBoolean isLinkTagEmpty = new AtomicBoolean();
            Node jsfHtmlLibRoot = result.root("http://java.sun.com/jsf/html");
            if (jsfHtmlLibRoot != null) {
                ElementUtils.visitChildren((Element)jsfHtmlLibRoot, (ElementVisitor)new ElementVisitor(){

                    public void visit(Element node) {
                        OpenTag tag = (OpenTag)node;
                        if (LexerUtils.equals((CharSequence)"head", (CharSequence)tag.unqualifiedName(), (boolean)false, (boolean)false)) {
                            insertPositionRef.set(node.to());
                            increaseIndent.set(true);
                        }
                    }
                }, (ElementType)ElementType.OPEN_TAG);
            }
            Node root = result.root();
            ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    OpenTag tag = (OpenTag)node;
                    CharSequence name = tag.name();
                    if (LexerUtils.equals((CharSequence)"html", (CharSequence)name, (boolean)true, (boolean)true)) {
                        if (insertPositionRef.get() == -1) {
                            insertPositionRef.set(node.to());
                            increaseIndent.set(true);
                        }
                    } else if (LexerUtils.equals((CharSequence)"head", (CharSequence)name, (boolean)true, (boolean)true)) {
                        insertPositionRef.set(node.to());
                        increaseIndent.set(true);
                    } else if (LexerUtils.equals((CharSequence)"link", (CharSequence)name, (boolean)true, (boolean)true)) {
                        insertPositionRef.set(tag.semanticEnd());
                        increaseIndent.set(false);
                        isLinkTagEmpty.set(tag.isEmpty());
                    }
                }
            }, (ElementType)ElementType.OPEN_TAG);
            int embeddedInsertOffset = insertPositionRef.get();
            if (embeddedInsertOffset == -1) {
                return false;
            }
            int insertOffset = snapshot.getOriginalOffset(embeddedInsertOffset);
            if (insertOffset == -1) {
                return false;
            }
            int baseIndent = Utilities.getRowIndent((BaseDocument)((BaseDocument)snapshot.getSource().getDocument(true)), (int)insertOffset);
            if (baseIndent == -1) {
                baseIndent = 0;
            }
            Document document = snapshot.getSource().getDocument(true);
            if (increaseIndent.get()) {
                baseIndent += IndentUtils.indentLevelSize((Document)document);
            }
            FileObject file = snapshot.getSource().getFileObject();
            String baseIndentString = IndentUtils.createIndentString((Document)document, (int)baseIndent);
            String linkRelativePath = WebUtils.getRelativePath((FileObject)file, (FileObject)targetFile);
            String linkText = '\n' + baseIndentString + "<link rel=\"stylesheet\" href=\"" + linkRelativePath + "\" type=\"text/css\"" + (isLinkTagEmpty.get() ? "" : "/") + ">\n";
            CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)file);
            ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.INSERT, editor.createPositionRef(insertOffset, Position.Bias.Forward), editor.createPositionRef(insertOffset, Position.Bias.Backward), null, linkText, NbBundle.getMessage(ExtractInlinedStyleRefactoringPlugin.class, (String)"MSG_InsertStylesheetLink"));
            modificationResult.addDifferences(file, Collections.singletonList(diff));
            return true;
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }
}

