/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.IntersectionType;
import org.netbeans.modules.php.editor.parser.astnodes.UnionType;

public class BaseFunctionElementSupport {
    private final Parameters parameters;
    private final ReturnTypes returnTypes;

    protected BaseFunctionElementSupport(Parameters parameters, ReturnTypes returnTypes) {
        assert (parameters != null);
        assert (returnTypes != null);
        this.parameters = parameters;
        this.returnTypes = returnTypes;
    }

    public final List<ParameterElement> getParameters() {
        return this.parameters.getParameters();
    }

    public final Collection<TypeResolver> getReturnTypes() {
        return this.returnTypes.getReturnTypes();
    }

    public final boolean isReturnUnionType() {
        return this.returnTypes.isUnionType();
    }

    public final boolean isReturnIntersectionType() {
        return this.returnTypes.isIntersectionType();
    }

    public final String asString(BaseFunctionElement.PrintAs as, BaseFunctionElement element, TypeNameResolver typeNameResolver) {
        return this.asString(as, element, typeNameResolver, null);
    }

    public final String asString(BaseFunctionElement.PrintAs as, BaseFunctionElement element, TypeNameResolver typeNameResolver, @NullAllowed PhpVersion phpVersion) {
        StringBuilder template = new StringBuilder();
        switch (as) {
            case NameAndParamsDeclaration: {
                template.append(" ").append(element.getName()).append("(");
                template.append(BaseFunctionElementSupport.parameters2String(element, this.getParameters(), ParameterElement.OutputType.COMPLETE_DECLARATION, typeNameResolver));
                template.append(")");
                break;
            }
            case NameAndParamsInvocation: {
                template.append(" ").append(element.getName()).append("(");
                template.append(BaseFunctionElementSupport.parameters2String(element, this.getParameters(), ParameterElement.OutputType.SIMPLE_NAME, typeNameResolver));
                template.append(")");
                break;
            }
            case DeclarationWithoutBody: {
                String returnType;
                Collection<TypeResolver> returns1;
                String modifiers = element.getPhpModifiers().toString();
                if (modifiers.length() > 0) {
                    template.append(modifiers).append(" ");
                }
                template.append("function");
                template.append(this.asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration, element, typeNameResolver, phpVersion));
                if (phpVersion == null || phpVersion.compareTo((Enum)PhpVersion.PHP_70) < 0 || (returns1 = this.getReturnTypes()).size() != 1 && !this.isReturnUnionType() || !StringUtils.hasText((String)(returnType = this.asString(BaseFunctionElement.PrintAs.ReturnTypes, element, typeNameResolver, phpVersion)))) break;
                boolean isNullableType = CodeUtils.isNullableType(returnType);
                if (isNullableType) {
                    returnType = returnType.substring(1);
                }
                template.append(": ");
                if (isNullableType) {
                    template.append("?");
                }
                template.append(returnType);
                break;
            }
            case DeclarationWithEmptyBody: {
                template.append(this.asString(BaseFunctionElement.PrintAs.DeclarationWithoutBody, element, typeNameResolver, phpVersion));
                template.append("{\n}");
                break;
            }
            case DeclarationWithParentCallInBody: {
                template.append(this.asString(BaseFunctionElement.PrintAs.DeclarationWithoutBody, element, typeNameResolver, phpVersion));
                Collection<TypeResolver> returns2 = this.getReturnTypes();
                String methdodInvocation = this.asString(BaseFunctionElement.PrintAs.NameAndParamsInvocation, element, typeNameResolver, phpVersion);
                if (methdodInvocation.startsWith(" ")) {
                    methdodInvocation = methdodInvocation.substring(1);
                }
                if (returns2.size() > 0) {
                    template.append(String.format("{%nreturn parent::%s;%n}", methdodInvocation));
                    break;
                }
                template.append(String.format("{%nparent::%s;%n}", methdodInvocation));
                break;
            }
            case ReturnSemiTypes: {
                for (TypeResolver typeResolver : this.getReturnTypes()) {
                    Object typeName;
                    if (typeResolver.isResolved()) {
                        typeName = typeResolver.getTypeName(false);
                        if (typeName == null) continue;
                        if (template.length() > 0) {
                            template.append("|");
                        }
                        template.append(typeNameResolver.resolve((QualifiedName)typeName).toString());
                        continue;
                    }
                    typeName = typeResolver.getRawTypeName();
                    if (typeName == null) continue;
                    if (template.length() > 0) {
                        template.append("|");
                    }
                    template.append((String)typeName);
                }
                break;
            }
            case ReturnTypes: {
                boolean hasArray = false;
                for (TypeResolver typeResolver : this.getReturnTypes()) {
                    TypeElement typeElement;
                    String returnType;
                    QualifiedName typeName;
                    if (!typeResolver.isResolved() || (typeName = typeResolver.getTypeName(false)) == null) continue;
                    if (template.length() > 0) {
                        template.append("|");
                    }
                    if (typeResolver.isNullableType()) {
                        template.append("?");
                    }
                    if ("\\self".equals(returnType = typeNameResolver.resolve(typeName).toString()) && element instanceof TypeMemberElement) {
                        returnType = typeNameResolver.resolve(((TypeMemberElement)((Object)element)).getType().getFullyQualifiedName()).toString();
                    }
                    if ("\\parent".equals(returnType) && element instanceof TypeMemberElement && (typeElement = ((TypeMemberElement)((Object)element)).getType()) instanceof ClassElement) {
                        QualifiedName superClassName = ((ClassElement)typeElement).getSuperClassName();
                        returnType = superClassName != null ? typeNameResolver.resolve(superClassName).toString() : "parent";
                    }
                    if (returnType.endsWith("[]")) {
                        returnType = "array";
                    }
                    if (returnType.equals("array")) {
                        if (hasArray) continue;
                        hasArray = true;
                    }
                    template.append(returnType);
                }
                break;
            }
            default: {
                assert (false) : as;
                break;
            }
        }
        return template.toString();
    }

    private static String parameters2String(BaseFunctionElement element, List<ParameterElement> parameterList, ParameterElement.OutputType stringOutputType, TypeNameResolver typeNameResolver) {
        StringBuilder template = new StringBuilder();
        if (parameterList.size() > 0) {
            int n = parameterList.size();
            for (int i = 0; i < n; ++i) {
                ParameterElement param;
                String paramInfo;
                boolean isNullableType;
                StringBuilder paramSb = new StringBuilder();
                if (i > 0) {
                    paramSb.append(", ");
                }
                if (isNullableType = CodeUtils.isNullableType(paramInfo = (param = parameterList.get(i)).asString(stringOutputType, typeNameResolver))) {
                    paramInfo = paramInfo.substring(1);
                }
                paramInfo = BaseFunctionElementSupport.resolveSpecialTypes(paramInfo, element, typeNameResolver, param);
                if (isNullableType) {
                    paramSb.append("?");
                }
                paramSb.append(paramInfo);
                template.append((CharSequence)paramSb);
            }
        }
        return template.toString();
    }

    private static String resolveSpecialTypes(String paramInfo, BaseFunctionElement element, TypeNameResolver typeNameResolver, ParameterElement param) {
        QualifiedName superClassName;
        TypeElement typeElement;
        String parameterInfo = paramInfo;
        if (parameterInfo.startsWith("self ") && element instanceof TypeMemberElement) {
            parameterInfo = typeNameResolver.resolve(((TypeMemberElement)((Object)element)).getType().getFullyQualifiedName()).toString() + parameterInfo.substring("self".length());
        }
        if (parameterInfo.startsWith("parent ") && element instanceof TypeMemberElement && (typeElement = ((TypeMemberElement)((Object)element)).getType()) instanceof ClassElement && (superClassName = ((ClassElement)typeElement).getSuperClassName()) != null) {
            parameterInfo = typeNameResolver.resolve(superClassName).toString() + parameterInfo.substring("parent".length());
        }
        if (param.isUnionType() && element instanceof TypeMemberElement) {
            parameterInfo = BaseFunctionElementSupport.resolveSpecialTypesInUnionType(parameterInfo, element, typeNameResolver);
        }
        return parameterInfo;
    }

    private static String resolveSpecialTypesInUnionType(String paramInfo, BaseFunctionElement element, TypeNameResolver typeNameResolver) {
        String parameterInfo = paramInfo;
        int indexOfWhitespace = parameterInfo.indexOf(32);
        if (indexOfWhitespace == -1) {
            return parameterInfo;
        }
        String unionType = parameterInfo.substring(0, indexOfWhitespace);
        List unionTypeList = StringUtils.explode((String)unionType, (String)"|");
        StringBuilder sb = new StringBuilder();
        if (unionTypeList.contains("self") || unionTypeList.contains("parent")) {
            for (String type : unionTypeList) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                if ("self".equals(type)) {
                    sb.append(typeNameResolver.resolve(((TypeMemberElement)((Object)element)).getType().getFullyQualifiedName()).toString());
                    continue;
                }
                if ("parent".equals(type)) {
                    TypeElement typeElement = ((TypeMemberElement)((Object)element)).getType();
                    if (!(typeElement instanceof ClassElement)) continue;
                    QualifiedName superClassName = ((ClassElement)typeElement).getSuperClassName();
                    if (superClassName != null) {
                        sb.append(typeNameResolver.resolve(superClassName).toString());
                        continue;
                    }
                    sb.append(type);
                    continue;
                }
                sb.append(type);
            }
            parameterInfo = sb.toString() + parameterInfo.substring(indexOfWhitespace);
        }
        return parameterInfo;
    }

    public static final class ReturnTypesImpl
    implements ReturnTypes {
        private final Set<TypeResolver> returnTypes;
        private final boolean isUnionType;
        private final boolean isIntersectionType;

        public static ReturnTypes create(Set<TypeResolver> returnTypes, ASTNode node) {
            return new ReturnTypesImpl(returnTypes, node);
        }

        private ReturnTypesImpl(Set<TypeResolver> returnTypes, ASTNode node) {
            this.returnTypes = returnTypes;
            this.isUnionType = node instanceof UnionType;
            this.isIntersectionType = node instanceof IntersectionType;
        }

        @Override
        public Set<TypeResolver> getReturnTypes() {
            return Collections.unmodifiableSet(this.returnTypes);
        }

        @Override
        public boolean isUnionType() {
            return this.isUnionType;
        }

        @Override
        public boolean isIntersectionType() {
            return this.isIntersectionType;
        }
    }

    public static interface ReturnTypes {
        public static final ReturnTypes NONE = new ReturnTypes(){

            @Override
            public Set<TypeResolver> getReturnTypes() {
                return Collections.emptySet();
            }

            @Override
            public boolean isUnionType() {
                return false;
            }

            @Override
            public boolean isIntersectionType() {
                return false;
            }
        };

        public Set<TypeResolver> getReturnTypes();

        public boolean isUnionType();

        public boolean isIntersectionType();
    }

    public static final class ParametersImpl
    implements Parameters {
        private final List<ParameterElement> parameters;

        public static Parameters create(List<ParameterElement> parameters) {
            return new ParametersImpl(parameters);
        }

        private ParametersImpl(List<ParameterElement> parameters) {
            this.parameters = parameters;
        }

        @Override
        public List<ParameterElement> getParameters() {
            return this.parameters;
        }
    }

    public static interface Parameters {
        public List<ParameterElement> getParameters();
    }
}

