/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.metadata;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.jpa.metadata.MetadataSourceAdapter;
import org.eclipse.persistence.logging.SessionLog;

public class XMLMetadataSource
extends MetadataSourceAdapter {
    public Reader getEntityMappingsReader(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        String mappingFileName;
        InputStreamReader reader = null;
        String mappingURLName = (String)this.getConfigPropertyLogDebug("eclipselink.metadata-source.xml.url", properties, log);
        if (mappingURLName != null && mappingURLName.length() != 0) {
            try {
                URL url = new URL(mappingURLName);
                reader = new InputStreamReader(url.openStream());
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        if (reader == null && (mappingFileName = (String)this.getConfigPropertyLogDebug("eclipselink.metadata-source.xml.file", properties, log)) != null && mappingFileName.length() > 0) {
            try {
                URL fileURL = XMLMetadataSource.getFileURL(mappingFileName, classLoader, log);
                if (fileURL != null) {
                    reader = new InputStreamReader(fileURL.openStream());
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        if (reader == null) {
            throw ValidationException.missingXMLMetadataRepositoryConfig();
        }
        return reader;
    }

    @Override
    public XMLEntityMappings getEntityMappings(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        Reader reader = this.getEntityMappingsReader(properties, classLoader, log);
        if (reader == null) {
            return null;
        }
        try {
            XMLEntityMappings xMLEntityMappings = XMLEntityMappingsReader.read(this.getRepositoryName(), reader, classLoader, properties);
            return xMLEntityMappings;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getRepositoryName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Map<String, Object> getPropertyOverrides(Map<String, Object> properties, ClassLoader classLoader, SessionLog log) {
        String propertiesFileName;
        block5: {
            propertiesFileName = (String)this.getConfigPropertyLogDebug("eclipselink.metadata-source.properties.file", properties, log);
            if (propertiesFileName == null || propertiesFileName.length() == 0) {
                return null;
            }
            try {
                URL fileURL = XMLMetadataSource.getFileURL(propertiesFileName, classLoader, log);
                if (fileURL == null) break block5;
                Properties propertiesFromFile = new Properties();
                propertiesFromFile.load(fileURL.openStream());
                if (!propertiesFromFile.isEmpty()) {
                    return new HashMap<Object, Object>(propertiesFromFile);
                }
                return null;
            }
            catch (IOException exception) {
                throw ValidationException.fileError((IOException)exception);
            }
        }
        throw ValidationException.missingPropertiesFileForMetadataRepositoryConfig((String)propertiesFileName);
    }

    protected static URL getFileURL(String fileName, ClassLoader classLoader, SessionLog log) throws IOException {
        Enumeration<URL> fileURLs = classLoader.getResources(fileName);
        if (!fileURLs.hasMoreElements()) {
            fileURLs = classLoader.getResources("/./" + fileName);
        }
        if (fileURLs.hasMoreElements()) {
            URL nextURL = fileURLs.nextElement();
            if (fileURLs.hasMoreElements()) {
                log.logThrowable(2, "metadata", (Throwable)ValidationException.nonUniqueRepositoryFileName((String)fileName));
            }
            return nextURL;
        }
        return null;
    }

    public Object getConfigPropertyLogDebug(String propertyName, Map properties, SessionLog log) {
        String value = null;
        if (properties != null) {
            value = (String)properties.get(propertyName);
        }
        if (value == null) {
            value = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetSystemProperty(propertyName)) : System.getProperty(propertyName);
        }
        if (value != null && log != null) {
            log.log(1, "properties", "property_value_specified", new Object[]{propertyName, value});
        }
        return value;
    }
}

