/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.context.IndexingContext;

public class UniqueGAArtifactFilterPostprocessor
implements ArtifactInfoFilter {
    private static final String VERSION_LATEST = "LATEST";
    private final boolean repositoriesIgnored;
    private final Set<String> gas = new HashSet<String>();

    public UniqueGAArtifactFilterPostprocessor(boolean repositoriesIgnored) {
        this.repositoriesIgnored = repositoriesIgnored;
    }

    @Override
    public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
        String key = ai.getGroupId() + ai.getArtifactId() + ai.getPackaging() + ai.getClassifier();
        if (!this.repositoriesIgnored) {
            key = ai.getRepository() + key;
        }
        if (this.gas.contains(key)) {
            return false;
        }
        this.gas.add(key);
        this.postprocess(ctx, ai);
        return true;
    }

    public void postprocess(IndexingContext ctx, ArtifactInfo ai) {
        ai.setVersion(VERSION_LATEST);
        if (this.repositoriesIgnored) {
            ai.setContext(null);
            ai.setRepository(null);
        }
    }
}

