/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.ImageIcon;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.ClassItemFactory;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SimpleClassItem
extends AbstractCompletionItem {
    private static final Logger LOG = Logger.getLogger(SimpleClassItem.class.getName());
    private static final String ICON_CLASS = "org/netbeans/modules/javafx2/editor/resources/class.png";
    private String className;
    private String fullClassName;
    private String leftText;
    private boolean deprecated;
    private int priority;
    private static ImageIcon ICON;

    public SimpleClassItem(CompletionContext ctx, String text) {
        super(ctx, text);
    }

    void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    void setClassName(String n) {
        this.className = n;
    }

    void setFullClassName(String n) {
        this.fullClassName = n;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    @Override
    public int getSortPriority() {
        return this.priority;
    }

    @Override
    public CharSequence getSortText() {
        return this.className;
    }

    @Override
    protected String getLeftHtmlText() {
        if (this.leftText != null) {
            return this.leftText;
        }
        String s = this.deprecated ? NbBundle.getMessage(SimpleClassItem.class, (String)"FMT_Deprecated", (Object)this.className) : this.className;
        this.leftText = s = NbBundle.getMessage(SimpleClassItem.class, (String)"FMT_AddPackage", (Object)s, (Object)this.fullClassName.substring(0, this.fullClassName.length() - this.className.length() - 1));
        return this.leftText;
    }

    @Override
    protected ImageIcon getIcon() {
        if (ICON == null) {
            ICON = ImageUtilities.loadImageIcon((String)ICON_CLASS, (boolean)false);
        }
        return ICON;
    }

    @Override
    public CharSequence getInsertPrefix() {
        return this.className;
    }

    @Override
    protected String getSubstituteText() {
        return "<" + super.getSubstituteText() + (this.ctx.isReplaceExisting() ? "" : " ");
    }

    static SimpleClassItem setup(SimpleClassItem item, TypeElement elem, CompletionContext ctx, int priority) {
        item.setFullClassName(elem.getQualifiedName().toString());
        item.setClassName(elem.getSimpleName().toString());
        item.setDeprecated(ctx.isBlackListed(elem));
        item.setPriority(priority);
        return item;
    }

    public String toString() {
        return "simple-class[" + this.getFullClassName() + "]";
    }

    public static class ItemFactory
    implements ClassItemFactory {
        @Override
        public CompletionItem convert(TypeElement elem, CompletionContext ctx, int priorityHint) {
            FxBean bean;
            if (elem.getQualifiedName().contentEquals("java.lang.String")) {
                return null;
            }
            boolean ok = false;
            List<ExecutableElement> execs = ElementFilter.constructorsIn(elem.getEnclosedElements());
            for (ExecutableElement e : execs) {
                if (!e.getModifiers().contains((Object)Modifier.PUBLIC) || e.getModifiers().contains((Object)Modifier.ABSTRACT) || !e.getParameters().isEmpty()) continue;
                ok = true;
            }
            String fqn = elem.getQualifiedName().toString();
            if (!(ok || (bean = ctx.getBeanInfo(fqn)) == null || bean.isFxInstance() || elem.getModifiers().contains((Object)Modifier.ABSTRACT) || bean.getBuilder() == null)) {
                ok = true;
            }
            if (!ok) {
                return null;
            }
            String sn = ctx.getSimpleClassName(fqn);
            return SimpleClassItem.setup(new SimpleClassItem(ctx, sn == null ? fqn : sn), elem, ctx, priorityHint);
        }
    }
}

