/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.data;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ScopedDataSet
extends DataSet {
    protected final DataHolder parent;

    public ScopedDataSet(DataHolder parent) {
        this.parent = parent;
    }

    public ScopedDataSet(DataHolder parent, DataHolder other) {
        super(other);
        this.parent = parent;
    }

    public DataHolder getParent() {
        return this.parent;
    }

    @Override
    public Map<DataKey, Object> getAll() {
        if (this.parent != null) {
            HashMap<DataKey, Object> all = new HashMap<DataKey, Object>();
            all.putAll(super.getAll());
            for (DataKey key : this.parent.keySet()) {
                if (this.contains(key)) continue;
                all.put(key, this.parent.get(key));
            }
            return all;
        }
        return super.getAll();
    }

    @Override
    public Collection<DataKey> keySet() {
        if (this.parent != null) {
            ArrayList<DataKey> all = new ArrayList<DataKey>();
            all.addAll(super.keySet());
            for (DataKey key : this.parent.keySet()) {
                if (this.contains(key)) continue;
                all.add(key);
            }
            return all;
        }
        return super.keySet();
    }

    @Override
    public boolean contains(DataKey key) {
        return super.contains(key) || this.parent != null && this.parent.contains(key);
    }

    @Override
    public <T> T get(DataKey<T> key) {
        if (this.parent == null || super.contains(key) || !this.parent.contains(key)) {
            return super.get(key);
        }
        return this.parent.get(key);
    }
}

