/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.test.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.core.startup.Main;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.java.JavaDataLoader;
import org.netbeans.modules.java.hints.providers.code.CodeHintProviderImpl;
import org.netbeans.modules.java.hints.providers.code.FSWrapper;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintDescriptionFactory;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.SyntheticFix;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchUtilities;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.test.BootClassPathUtil;
import org.netbeans.modules.java.hints.test.Utilities;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.MimeTypes;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.hints.Hint;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.queries.CompilerOptionsQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class HintTest {
    private static final Logger INDEXING_LOGGER = Logger.getLogger("org.netbeans.ui.indexing");
    private static final Logger LEXER_LOG_LOCK = Logger.getLogger(MutableTextInput.class.getName());
    private final File workDir;
    private final FileObject sourceRoot;
    private final FileObject buildRoot;
    private final FileObject cache;
    private final Preferences testPreferences;
    private final HintsSettings hintSettings;
    private final List<FileObject> checkCompilable = new ArrayList<FileObject>();
    private String sourceLevel = "1.5";
    private List<String> extraOptions = new ArrayList<String>();
    private Character caretMarker;
    private FileObject testFile;
    private int caret = -1;
    private ClassPath sourcePath;
    private ClassPath compileClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static Set<List<ErrorDescription>> DEBUGGING_HELPER;
    private static final SourceForBinaryQuery.Result EMPTY_SFBQ_RESULT;
    private static Logger log;
    private static final Comparator<ErrorDescription> ERRORS_COMPARATOR;
    private static Set<String> usedPaths;
    private static final String JUNIT_PROPERTIES_FILENAME = "junit.properties";
    private static final String JUNIT_PROPERTIES_LOCATION_PROPERTY = "junit.properties.file";
    private static final String NBJUNIT_WORKDIR = "nbjunit.workdir";

    private HintTest() throws Exception {
        LinkedList<URL> layers = new LinkedList<URL>();
        for (String layer : new String[]{"META-INF/generated-layer.xml"}) {
            boolean found = false;
            Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources(layer);
            while (en.hasMoreElements()) {
                found = true;
                layers.add(en.nextElement());
            }
            Assert.assertTrue((String)layer, (boolean)found);
        }
        XMLFileSystem xmlFS = new XMLFileSystem();
        xmlFS.setXmlUrls(layers.toArray(new URL[0]));
        MultiFileSystem system = new MultiFileSystem(new FileSystem[]{FileUtil.createMemoryFileSystem(), xmlFS});
        Repository repository = new Repository((FileSystem)system);
        Assert.assertEquals((String)Lookup.getDefault().getClass().getCanonicalName(), Utilities.TestLookup.class, Lookup.getDefault().getClass());
        ((Utilities.TestLookup)Lookup.getDefault()).setLookupsImpl(Lookups.fixed((Object[])new Object[]{repository, new TestProxyClassPathProvider(), new TestSourceForBinaryQuery(), new TestSourceLevelQueryImplementation(), new TestCompilerOptionsQueryImplementation(), JavaDataLoader.findObject(JavaDataLoader.class, (boolean)true)}), Lookups.metaInfServices((ClassLoader)HintTest.class.getClassLoader()), Lookups.singleton((Object)HintTest.class.getClassLoader()));
        Set<String> amt = MimeTypes.getAllMimeTypes();
        amt = amt == null ? new HashSet<String>() : new HashSet<String>(amt);
        amt.add("text/x-java");
        MimeTypes.setAllMimeTypes(amt);
        OpenProjects.getDefault().getOpenProjects();
        this.testPreferences = new TempPreferences();
        this.hintSettings = new HintsSettings(){

            public boolean isEnabled(HintMetadata hint) {
                return true;
            }

            public void setEnabled(HintMetadata hint, boolean value) {
                throw new UnsupportedOperationException("Not supported.");
            }

            public Preferences getHintPreferences(HintMetadata hint) {
                return HintTest.this.testPreferences;
            }

            public Severity getSeverity(HintMetadata hint) {
                return hint.severity;
            }

            public void setSeverity(HintMetadata hint, Severity severity) {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
        this.workDir = HintTest.getWorkDir();
        HintTest.deleteSubFiles(this.workDir);
        FileUtil.refreshFor((File[])new File[]{this.workDir});
        FileObject wd = FileUtil.toFileObject((File)this.workDir);
        Assert.assertNotNull((Object)wd);
        this.sourceRoot = FileUtil.createFolder((FileObject)wd, (String)"src");
        this.buildRoot = FileUtil.createFolder((FileObject)wd, (String)"build");
        this.cache = FileUtil.createFolder((FileObject)wd, (String)"cache");
        CacheFolder.setCacheFolder((FileObject)this.cache);
        NbBundle.setBranding((String)"test");
        this.sourcePath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.sourceRoot});
        Main.initializeURLFactory();
        JavacParser.DISABLE_SOURCE_LEVEL_DOWNGRADE = true;
    }

    public static HintTest create() throws Exception {
        return new HintTest();
    }

    public HintTest setCaretMarker(char c) {
        this.caretMarker = Character.valueOf(c);
        return this;
    }

    public HintTest classpath(URL ... entries) {
        this.compileClassPath = ClassPathSupport.createClassPath((URL[])entries);
        return this;
    }

    public HintTest input(String code) throws Exception {
        return this.input("test/Test.java", code, true);
    }

    public HintTest input(String code, boolean compilable) throws Exception {
        return this.input("test/Test.java", code, compilable);
    }

    public HintTest input(String fileName, String code) throws Exception {
        return this.input(fileName, code, true);
    }

    public HintTest input(String fileName, String code, boolean compilable) throws Exception {
        int caret = -1;
        if (this.caretMarker != null && this.testFile == null) {
            caret = code.indexOf(this.caretMarker.charValue());
            Assert.assertNotSame((String)"A caret location must be specified", (Object)-1, (Object)caret);
            code = code.substring(0, caret) + code.substring(caret + 1);
        }
        FileObject file = FileUtil.createData((FileObject)this.sourceRoot, (String)fileName);
        HintTest.copyStringToFile(file, code);
        if (compilable) {
            this.checkCompilable.add(file);
        }
        if (this.testFile == null) {
            this.testFile = file;
            this.caret = caret;
        }
        return this;
    }

    private void ensureCompilable(FileObject file) throws IOException, AssertionError, IllegalArgumentException {
        CompilationInfo info = this.parse(file);
        Assert.assertNotNull((Object)info);
        for (Diagnostic d : info.getDiagnostics()) {
            if (d.getKind() == Diagnostic.Kind.ERROR) {
                throw new AssertionError((Object)(d.getLineNumber() + ":" + d.getColumnNumber() + " " + d.getMessage(null)));
            }
        }
    }

    public HintTest sourceLevel(String sourceLevel) {
        this.sourceLevel = sourceLevel;
        return this;
    }

    public HintTest options(String ... options) {
        this.extraOptions.addAll(Arrays.asList(options));
        return this;
    }

    public HintTest preference(String preferencesKey, String value) {
        this.testPreferences.put(preferencesKey, value);
        return this;
    }

    public HintTest preference(String preferencesKey, int value) {
        this.testPreferences.putInt(preferencesKey, value);
        return this;
    }

    public HintTest preference(String preferencesKey, boolean value) {
        this.testPreferences.putBoolean(preferencesKey, value);
        return this;
    }

    public HintOutput run(Class<?> hint) throws Exception {
        return this.run(hint, null);
    }

    public HintOutput run(Class<?> hint, String hintCode) throws Exception {
        IndexingManager.getDefault().refreshIndexAndWait(this.sourceRoot.toURL(), null);
        for (FileObject file : this.checkCompilable) {
            this.ensureCompilable(file);
        }
        HashMap hints = new HashMap();
        ArrayList<FSWrapper.ClassWrapper> found = new ArrayList<FSWrapper.ClassWrapper>();
        for (FSWrapper.ClassWrapper w : FSWrapper.listClasses()) {
            if (!hint.getCanonicalName().equals(w.getName().replace('$', '.'))) continue;
            found.add(w);
        }
        TestCase.assertFalse((boolean)found.isEmpty());
        for (FSWrapper.ClassWrapper w : found) {
            CodeHintProviderImpl.processClass((FSWrapper.ClassWrapper)w, hints);
        }
        LinkedList<HintDescription> total = new LinkedList<HintDescription>();
        final Set requiresJavaFix = Collections.newSetFromMap(new IdentityHashMap());
        for (Map.Entry e : hints.entrySet()) {
            if (null != hintCode && !((HintMetadata)e.getKey()).id.equals(hintCode)) continue;
            if (((HintMetadata)e.getKey()).options.contains(HintMetadata.Options.NO_BATCH) || ((HintMetadata)e.getKey()).options.contains(HintMetadata.Options.QUERY) || ((HintMetadata)e.getKey()).kind == Hint.Kind.ACTION) {
                total.addAll((Collection)e.getValue());
                continue;
            }
            for (final HintDescription hd : (Collection)e.getValue()) {
                total.add(HintDescriptionFactory.create().setTrigger(hd.getTrigger()).setMetadata((HintMetadata)e.getKey()).setAdditionalConstraints(hd.getAdditionalConstraints()).addOptions(hd.getOptions().toArray(new HintMetadata.Options[0])).setWorker(new HintDescription.Worker(){

                    public Collection<? extends ErrorDescription> createErrors(HintContext ctx) {
                        Collection errors = hd.getWorker().createErrors(ctx);
                        if (errors != null) {
                            for (ErrorDescription ed : errors) {
                                requiresJavaFix.add(ed);
                            }
                        }
                        return errors;
                    }
                }).produce());
            }
        }
        CompilationInfo info = this.parse(this.testFile);
        Assert.assertNotNull((Object)info);
        ArrayList result = new ArrayList();
        Handler h = new Handler(){

            @Override
            public void publish(LogRecord record) {
                if (record.getLevel().intValue() >= Level.WARNING.intValue() && record.getThrown() != null) {
                    throw new IllegalStateException(record.getThrown());
                }
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        };
        Logger log = Logger.getLogger(Exceptions.class.getName());
        log.addHandler(h);
        Map<HintDescription, List<ErrorDescription>> errors = this.computeErrors(info, total, new AtomicBoolean());
        log.removeHandler(h);
        for (Map.Entry<HintDescription, List<ErrorDescription>> e : errors.entrySet()) {
            result.addAll(e.getValue());
        }
        Collections.sort(result, ERRORS_COMPARATOR);
        WeakReference<CompilationInfo> infoRef = new WeakReference<CompilationInfo>(info);
        WeakReference<CompilationUnitTree> cut = new WeakReference<CompilationUnitTree>(info.getCompilationUnit());
        info = null;
        DEBUGGING_HELPER.add(result);
        NbTestCase.assertGC((String)"noone holds CompilationInfo", infoRef);
        NbTestCase.assertGC((String)"noone holds javac", cut);
        DEBUGGING_HELPER.remove(result);
        return new HintOutput(result, requiresJavaFix);
    }

    private CompilationInfo parse(FileObject file) throws DataObjectNotFoundException, IllegalArgumentException, IOException {
        DataObject od = DataObject.find((FileObject)file);
        EditorCookie ec = (EditorCookie)od.getLookup().lookup(EditorCookie.class);
        Assert.assertNotNull((Object)ec);
        StyledDocument doc = ec.openDocument();
        doc.putProperty(Language.class, JavaTokenId.language());
        doc.putProperty("mimeType", "text/x-java");
        JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)file), (FileObject[])new FileObject[]{file});
        Assert.assertNotNull((String)("found JavaSource for " + file), (Object)js);
        DeadlockTask bt = new DeadlockTask(JavaSource.Phase.RESOLVED);
        js.runUserActionTask((Task)bt, true);
        return bt.info;
    }

    private Map<HintDescription, List<ErrorDescription>> computeErrors(CompilationInfo info, Iterable<? extends HintDescription> hints, AtomicBoolean cancel) {
        return new HintsInvoker(this.hintSettings, this.caret, cancel).computeHints(info, new TreePath(info.getCompilationUnit()), hints, new LinkedList());
    }

    FileObject getSourceRoot() {
        return this.sourceRoot;
    }

    private static File getWorkDir() throws IOException {
        File workdir = FileUtil.normalizeFile((File)new File(HintTest.getWorkDirPath()));
        if (workdir.exists()) {
            if (!workdir.isDirectory()) {
                throw new IOException("workdir exists, but is not a directory, workdir = " + workdir);
            }
            return workdir;
        }
        boolean result = workdir.mkdirs();
        if (!result) {
            throw new IOException("workdir creation failed: " + workdir);
        }
        return workdir;
    }

    private static String getWorkDirPath() {
        String realP;
        int tooLong;
        int len3;
        String clazz;
        int len2;
        String workDirPath;
        int len1;
        StackTraceElement caller = null;
        boolean seenItself = false;
        for (StackTraceElement e : new Exception().getStackTrace()) {
            if (HintTest.class.getName().equals(e.getClassName())) {
                seenItself = true;
            }
            if (!seenItself || HintTest.class.getName().equals(e.getClassName())) continue;
            caller = e;
            break;
        }
        String name = caller != null ? caller.getMethodName() : "unknownTest";
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Windows")) {
            char[] ntfsIllegal = new char[]{'\"', '/', '\\', '?', '<', '>', '|', ':'};
            for (int i = 0; i < ntfsIllegal.length; ++i) {
                name = name.replace(ntfsIllegal[i], '~');
            }
        }
        if ((len1 = (workDirPath = HintTest.getWorkDirPathFromManager()).length()) + (len2 = (clazz = caller != null ? caller.getClassName() : "unknown.Class").length()) + (len3 = name.length()) > (tooLong = Integer.getInteger("nbjunit.too.long", 100).intValue())) {
            clazz = HintTest.abbrevDots(clazz);
            len2 = clazz.length();
        }
        if (len1 + len2 + len3 > tooLong) {
            name = HintTest.abbrevCapitals(name);
        }
        String p = workDirPath + File.separator + clazz + File.separator + name;
        int i = 0;
        while (true) {
            String string = realP = i == 0 ? p : p + "-" + i;
            if (usedPaths.add(realP)) break;
            ++i;
        }
        return realP;
    }

    private static String abbrevDots(String dotted) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (String item : dotted.split("\\.")) {
            sb.append(sep);
            sb.append(item.charAt(0));
            sep = ".";
        }
        return sb.toString();
    }

    private static String abbrevCapitals(String name) {
        if (name.startsWith("test")) {
            name = name.substring(4);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        return sb.toString();
    }

    private static String getWorkDirPathFromManager() {
        String path = System.getProperty(NBJUNIT_WORKDIR);
        if (path == null) {
            path = HintTest.readProperties().getProperty(NBJUNIT_WORKDIR);
        }
        path = path != null ? path.replace('/', File.separatorChar) : System.getProperty("java.io.tmpdir") + File.separatorChar + "tests-" + System.getProperty("user.name");
        return path;
    }

    private static Properties readProperties() {
        Properties result = new Properties();
        try {
            File propFile = HintTest.getPreferencesFile();
            try (FileInputStream is = new FileInputStream(propFile);){
                result.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static File getPreferencesFile() {
        File propertyFile;
        String junitPropertiesLocation = System.getProperty(JUNIT_PROPERTIES_LOCATION_PROPERTY);
        if (junitPropertiesLocation != null && (propertyFile = new File(junitPropertiesLocation)).exists()) {
            return propertyFile;
        }
        String home = System.getProperty("user.home");
        return new File(home, JUNIT_PROPERTIES_FILENAME);
    }

    private static void deleteFile(File file) throws IOException {
        boolean result;
        if (file.isDirectory() && file.equals(file.getCanonicalFile())) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                HintTest.deleteFile(files[i]);
            }
        }
        if (!(result = file.delete())) {
            throw new IOException("Cannot delete file, file = " + file.getPath());
        }
    }

    private static void deleteSubFiles(File file) throws IOException {
        File[] files = file.getCanonicalFile().listFiles();
        if (files != null) {
            for (File f : files) {
                HintTest.deleteFile(f);
            }
        }
    }

    private static FileObject copyStringToFile(FileObject f, String content) throws Exception {
        OutputStream os = f.getOutputStream();
        os.write(content.getBytes("UTF-8"));
        os.close();
        return f;
    }

    static {
        INDEXING_LOGGER.setLevel(Level.WARNING);
        LEXER_LOG_LOCK.setLevel(Level.OFF);
        DEBUGGING_HELPER = Collections.newSetFromMap(new IdentityHashMap());
        EMPTY_SFBQ_RESULT = new SourceForBinaryQuery.Result(){
            private final FileObject[] roots = new FileObject[0];

            public FileObject[] getRoots() {
                return this.roots;
            }

            public void addChangeListener(ChangeListener l) {
            }

            public void removeChangeListener(ChangeListener l) {
            }
        };
        log = Logger.getLogger(HintTest.class.getName());
        ERRORS_COMPARATOR = new Comparator<ErrorDescription>(){

            @Override
            public int compare(ErrorDescription e1, ErrorDescription e2) {
                return e1.getRange().getBegin().getOffset() - e2.getRange().getBegin().getOffset();
            }
        };
        System.setProperty("org.openide.util.Lookup", Utilities.TestLookup.class.getName());
        Assert.assertEquals(Utilities.TestLookup.class, Lookup.getDefault().getClass());
        usedPaths = new HashSet<String>();
    }

    public final class AppliedFix {
        public AppliedFix assertCompilable() throws Exception {
            return this.assertCompilable("test/Test.java");
        }

        public AppliedFix assertCompilable(String fileName) throws Exception {
            FileObject toCheck = HintTest.this.sourceRoot.getFileObject(fileName);
            Assert.assertNotNull((Object)toCheck);
            HintTest.this.ensureCompilable(toCheck);
            return this;
        }

        public AppliedFix assertOutput(String code) throws Exception {
            return this.assertOutput("test/Test.java", code);
        }

        public AppliedFix assertOutput(String fileName, String code) throws Exception {
            FileObject toCheck = HintTest.this.sourceRoot.getFileObject(fileName);
            Assert.assertNotNull((String)("Required file: " + fileName + " not found"), (Object)toCheck);
            DataObject toCheckDO = DataObject.find((FileObject)toCheck);
            EditorCookie ec = (EditorCookie)toCheckDO.getLookup().lookup(EditorCookie.class);
            StyledDocument toCheckDocument = ec.openDocument();
            String realCode = toCheckDocument.getText(0, toCheckDocument.getLength());
            this.assertSameOutput(realCode, code);
            return this;
        }

        private void assertSameOutput(String result, String golden) throws Exception {
            Language lng = Language.find((String)"text/x-java");
            if (lng == null || Boolean.getBoolean("org.netbeans.test.hints.strictOutputCompare")) {
                Assert.assertEquals((String)"The output code does not match the expected code.", (String)this.reduceWhitespaces(golden), (String)this.reduceWhitespaces(result));
                return;
            }
            TokenHierarchy h1 = TokenHierarchy.create((CharSequence)result, (Language)lng);
            TokenHierarchy h2 = TokenHierarchy.create((CharSequence)golden, (Language)lng);
            TokenSequence s1 = h1.tokenSequence();
            TokenSequence s2 = h2.tokenSequence();
            block0: while (s2.moveNext()) {
                boolean wh;
                Token gt = s2.token();
                boolean bl = wh = gt.id() == JavaTokenId.WHITESPACE;
                if (s1.moveNext()) {
                    Token rt;
                    do {
                        rt = s1.token();
                        if (!wh) {
                            if (rt.text().toString().equals(gt.text().toString())) continue;
                            this.failNotSame(result, golden, s1.offset(), s2.offset());
                            continue;
                        }
                        if (this.isWH(rt)) continue;
                        s1.movePrevious();
                        continue block0;
                    } while (this.isWH(rt) && s1.moveNext());
                    continue;
                }
                if (wh) continue;
                this.failNotSame(result, golden, s1.offset(), s2.offset());
            }
            s1.movePrevious();
            s2.movePrevious();
            if (s1.moveNext() != s2.moveNext()) {
                this.failNotSame(result, golden, s1.offset(), s2.offset());
            }
        }

        private boolean isWH(Token t) {
            return t.id() == JavaTokenId.WHITESPACE;
        }

        private void failNotSame(String result, String golden, int resultPoint, int goldenPoint) {
            String fakeGolden = result.substring(0, resultPoint) + golden.substring(goldenPoint);
            Assert.assertEquals((String)"The output code does not match the expected code.", (String)fakeGolden, (String)result);
        }

        private String reduceWhitespaces(String str) {
            int codePoint;
            StringBuilder result = new StringBuilder();
            boolean wasWhitespace = false;
            for (int i = 0; i < str.length(); i += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(i);
                if (Character.isWhitespace(codePoint)) {
                    if (wasWhitespace) continue;
                    result.append(" ");
                    wasWhitespace = true;
                    continue;
                }
                result.appendCodePoint(codePoint);
                wasWhitespace = false;
            }
            return result.toString();
        }

        public AppliedFix assertVerbatimOutput(String code) throws Exception {
            return this.assertVerbatimOutput("test/Test.java", code);
        }

        public AppliedFix assertVerbatimOutput(String fileName, String code) throws Exception {
            FileObject toCheck = HintTest.this.sourceRoot.getFileObject(fileName);
            Assert.assertNotNull((Object)toCheck);
            DataObject toCheckDO = DataObject.find((FileObject)toCheck);
            EditorCookie ec = (EditorCookie)toCheckDO.getLookup().lookup(EditorCookie.class);
            StyledDocument toCheckDocument = ec.openDocument();
            String realCode = toCheckDocument.getText(0, toCheckDocument.getLength());
            Assert.assertEquals((String)"The output code does not match the expected code.", (String)code, (String)realCode);
            return this;
        }

        public String getOutput() throws Exception {
            return this.getOutput("test/Test.java");
        }

        public String getOutput(String fileName) throws Exception {
            FileObject toCheck = HintTest.this.sourceRoot.getFileObject(fileName);
            Assert.assertNotNull((Object)toCheck);
            DataObject toCheckDO = DataObject.find((FileObject)toCheck);
            EditorCookie ec = (EditorCookie)toCheckDO.getLookup().lookup(EditorCookie.class);
            StyledDocument toCheckDocument = ec.openDocument();
            return toCheckDocument.getText(0, toCheckDocument.getLength());
        }
    }

    public final class HintWarning {
        private final ErrorDescription warning;
        private final boolean requiresJavaFix;

        HintWarning(ErrorDescription warning, boolean requiresJavaFix) {
            this.warning = warning;
            this.requiresJavaFix = requiresJavaFix;
        }

        public AppliedFix applyFix() throws Exception {
            return this.applyFix(true);
        }

        AppliedFix applyFix(boolean saveAll) throws Exception {
            Assert.assertTrue((String)"Must be computed", (boolean)this.warning.getFixes().isComputed());
            List fixes = this.warning.getFixes().getFixes();
            Assert.assertEquals((int)1, (int)fixes.size());
            this.doApplyFix((Fix)fixes.get(0));
            if (saveAll) {
                LifecycleManager.getDefault().saveAll();
            }
            return new AppliedFix();
        }

        public AppliedFix applyFix(String fix) throws Exception {
            Assert.assertTrue((String)"Must be computed", (boolean)this.warning.getFixes().isComputed());
            List fixes = this.warning.getFixes().getFixes();
            LinkedList<String> fixNames = new LinkedList<String>();
            Fix toApply = null;
            for (Fix f : fixes) {
                if (fix.equals(f.getText())) {
                    toApply = f;
                }
                fixNames.add(f.getText());
            }
            Assert.assertNotNull((String)("Cannot find fix to invoke: " + ((Object)fixNames).toString()), (Object)toApply);
            this.doApplyFix(toApply);
            LifecycleManager.getDefault().saveAll();
            return new AppliedFix();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doApplyFix(Fix f) throws Exception {
            Preferences preferences = (Preferences)MimeLookup.getLookup((String)JavaTokenId.language().mimeType()).lookup(Preferences.class);
            preferences.putBoolean("importInnerClasses", true);
            try {
                if (this.requiresJavaFix) {
                    Assert.assertTrue((String)"The fix must be a JavaFix", (boolean)(f instanceof JavaFixImpl));
                    ModificationResult result1 = this.runJavaFix(((JavaFixImpl)f).jf);
                    ModificationResult result2 = this.runJavaFix(((JavaFixImpl)f).jf);
                    Assert.assertEquals((String)"The fix must be repeatable", (Object)result1.getModifiedFileObjects(), (Object)result2.getModifiedFileObjects());
                    for (FileObject file : result1.getModifiedFileObjects()) {
                        Assert.assertEquals((String)"The fix must be repeatable", (String)result1.getResultingSource(file), (String)result2.getResultingSource(file));
                    }
                    result1.commit();
                } else {
                    f.implement();
                }
            }
            finally {
                preferences.remove("importInnerClasses");
            }
        }

        private ModificationResult runJavaFix(final JavaFix jf) throws IOException {
            FileObject file = JavaFixImpl.Accessor.INSTANCE.getFile(jf);
            JavaSource js = JavaSource.forFileObject((FileObject)file);
            final HashMap changes = new HashMap();
            ModificationResult mr = js.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    if (wc.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    HashMap resourceContentChanges = new HashMap();
                    JavaFixImpl.Accessor.INSTANCE.process(jf, wc, true, resourceContentChanges, new ArrayList());
                    BatchUtilities.addResourceContentChanges(resourceContentChanges, (Map)changes);
                }
            });
            changes.putAll(JavaSourceAccessor.getINSTANCE().getDiffsFromModificationResult(mr));
            return JavaSourceAccessor.getINSTANCE().createModificationResult(changes, Collections.emptyMap());
        }

        public HintWarning assertFixes(String ... expectedFixes) throws Exception {
            Assert.assertTrue((String)"Must be computed", (boolean)this.warning.getFixes().isComputed());
            LinkedList<String> fixNames = new LinkedList<String>();
            for (Fix f : this.warning.getFixes().getFixes()) {
                if (f instanceof SyntheticFix) continue;
                fixNames.add(f.getText());
            }
            Assert.assertEquals((String)("Fixes for the current warning do not match the expected fixes. All fixes: " + ((Object)fixNames).toString()), Arrays.asList(expectedFixes), fixNames);
            return this;
        }

        public HintWarning assertFixesNotPresent(String ... bannedFixes) throws Exception {
            Assert.assertTrue((String)"Must be computed", (boolean)this.warning.getFixes().isComputed());
            LinkedList<String> fixNames = new LinkedList<String>();
            for (Fix f : this.warning.getFixes().getFixes()) {
                if (f instanceof SyntheticFix) continue;
                fixNames.add(f.getText());
            }
            HashSet check = new HashSet(fixNames);
            check.retainAll(Arrays.asList(bannedFixes));
            Assert.assertTrue((String)("Fixes for the current warning do not match the expected fixes. All fixes: " + ((Object)fixNames).toString()), (boolean)check.isEmpty());
            return this;
        }
    }

    public final class HintOutput {
        private final List<ErrorDescription> errors;
        private final Set<ErrorDescription> requiresJavaFix;

        private HintOutput(List<ErrorDescription> errors, Set<ErrorDescription> requiresJavaFix) {
            this.errors = errors;
            this.requiresJavaFix = requiresJavaFix;
        }

        public HintOutput assertWarnings(String ... warnings) {
            Assert.assertEquals((String)"The warnings provided by the hint do not match expected warnings.", (String)Arrays.toString(warnings), (String)this.errors.toString());
            return this;
        }

        public HintOutput assertContainsWarnings(String ... warnings) {
            HashSet<String> goldenSet = new HashSet<String>(Arrays.asList(warnings));
            LinkedList<String> errorsNames = new LinkedList<String>();
            for (ErrorDescription d : this.errors) {
                goldenSet.remove(d.toString());
                errorsNames.add(d.toString());
            }
            Assert.assertTrue((String)("The warnings provided by the hint do not contain expected warnings. Provided warnings: " + ((Object)errorsNames).toString()), (boolean)goldenSet.isEmpty());
            return this;
        }

        public HintOutput assertNotContainsWarnings(String ... warnings) {
            HashSet<String> goldenSet = new HashSet<String>(Arrays.asList(warnings));
            LinkedList<String> errorsNames = new LinkedList<String>();
            boolean fail = false;
            for (ErrorDescription d : this.errors) {
                if (goldenSet.remove(d.getDescription())) {
                    fail = true;
                }
                errorsNames.add(d.toString());
            }
            TestCase.assertFalse((String)("The warnings provided by the hint do not exclude expected warnings. Provided warnings: " + ((Object)errorsNames).toString()), (boolean)fail);
            return this;
        }

        public HintWarning findWarning(String warning) {
            ErrorDescription toFix = null;
            for (ErrorDescription d : this.errors) {
                if (!warning.equals(d.toString())) continue;
                toFix = d;
                break;
            }
            Assert.assertNotNull((String)("Warning: \"" + warning + "\" not found. All ErrorDescriptions: " + this.errors.toString()), (Object)toFix);
            return new HintWarning(toFix, this.requiresJavaFix.contains(toFix));
        }
    }

    private static class DeadlockTask
    implements Task<CompilationController> {
        private final JavaSource.Phase phase;
        private CompilationInfo info;

        public DeadlockTask(JavaSource.Phase phase) {
            assert (phase != null);
            this.phase = phase;
        }

        public void run(CompilationController info) {
            block2: {
                try {
                    info.toPhase(this.phase);
                    this.info = info;
                }
                catch (IOException ioe) {
                    if (!log.isLoggable(Level.SEVERE)) break block2;
                    log.log(Level.SEVERE, ioe.getMessage(), ioe);
                }
            }
        }
    }

    private class TestCompilerOptionsQueryImplementation
    implements CompilerOptionsQueryImplementation {
        private TestCompilerOptionsQueryImplementation() {
        }

        public CompilerOptionsQueryImplementation.Result getOptions(FileObject file) {
            return new CompilerOptionsQueryImplementation.Result(){

                public List<? extends String> getArguments() {
                    return HintTest.this.extraOptions;
                }

                public void addChangeListener(ChangeListener listener) {
                }

                public void removeChangeListener(ChangeListener listener) {
                }
            };
        }
    }

    private class TestSourceLevelQueryImplementation
    implements SourceLevelQueryImplementation {
        private TestSourceLevelQueryImplementation() {
        }

        public String getSourceLevel(FileObject javaFile) {
            return HintTest.this.sourceLevel;
        }
    }

    private class TestProxyClassPathProvider
    implements ClassPathProvider {
        private TestProxyClassPathProvider() {
        }

        public ClassPath findClassPath(FileObject file, String type) {
            try {
                if ("classpath/boot" == type) {
                    return BootClassPathUtil.getBootClassPath();
                }
                if ("modules/boot" == type) {
                    return BootClassPathUtil.getModuleBootPath();
                }
                if ("classpath/source" == type) {
                    return HintTest.this.sourcePath;
                }
                if ("classpath/compile" == type) {
                    return HintTest.this.compileClassPath;
                }
                if ("classpath/execute" == type) {
                    return ClassPathSupport.createClassPath((FileObject[])new FileObject[]{HintTest.this.buildRoot});
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private class TestSourceForBinaryQuery
    implements SourceForBinaryQueryImplementation {
        private TestSourceForBinaryQuery() {
        }

        public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
            FileObject f = URLMapper.findFileObject((URL)binaryRoot);
            if (HintTest.this.buildRoot.equals(f)) {
                return new SourceForBinaryQuery.Result(){

                    public FileObject[] getRoots() {
                        return new FileObject[]{HintTest.this.sourceRoot};
                    }

                    public void addChangeListener(ChangeListener l) {
                    }

                    public void removeChangeListener(ChangeListener l) {
                    }
                };
            }
            return EMPTY_SFBQ_RESULT;
        }
    }

    private static class TempPreferences
    extends AbstractPreferences {
        Properties properties;

        private TempPreferences() {
            super(null, "");
        }

        private TempPreferences(TempPreferences parent, String name) {
            super(parent, name);
            this.newNode = true;
        }

        @Override
        protected final String getSpi(String key) {
            return this.properties().getProperty(key);
        }

        @Override
        protected final String[] childrenNamesSpi() throws BackingStoreException {
            return new String[0];
        }

        @Override
        protected final String[] keysSpi() throws BackingStoreException {
            return this.properties().keySet().toArray(new String[0]);
        }

        @Override
        protected final void putSpi(String key, String value) {
            this.properties().put(key, value);
        }

        @Override
        protected final void removeSpi(String key) {
            this.properties().remove(key);
        }

        @Override
        protected final void removeNodeSpi() throws BackingStoreException {
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            this.properties().clear();
        }

        @Override
        public void put(String key, String value) {
            try {
                super.put(key, value);
            }
            catch (IllegalArgumentException iae) {
                if (iae.getMessage().contains("too long")) {
                    this.putSpi(key, value);
                }
                throw iae;
            }
        }

        Properties properties() {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            return this.properties;
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            return new TempPreferences(this, name);
        }
    }
}

