/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.AbstractGeneratorBlockNode;
import com.oracle.truffle.js.nodes.control.YieldException;
import java.util.Set;

public final class GeneratorExprBlockNode
extends AbstractGeneratorBlockNode {
    GeneratorExprBlockNode(JavaScriptNode[] statements, JavaScriptNode readStateNode, WriteNode writeStateNode) {
        super(statements, readStateNode, writeStateNode);
    }

    public static JavaScriptNode create(JavaScriptNode[] statements, JavaScriptNode readStateNode, WriteNode writeStateNode) {
        return new GeneratorExprBlockNode(statements, readStateNode, writeStateNode);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        int startIndex = this.getStateAndReset(frame);
        assert (startIndex < this.getStatements().length);
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, startIndex);
        }
        return this.executeBoolean(frame, stmts[last], last, startIndex);
    }

    @Override
    @ExplodeLoop
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        int startIndex = this.getStateAndReset(frame);
        assert (startIndex < this.getStatements().length);
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, startIndex);
        }
        return this.executeInt(frame, stmts[last], last, startIndex);
    }

    @Override
    @ExplodeLoop
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        int startIndex = this.getStateAndReset(frame);
        assert (startIndex < this.getStatements().length);
        JavaScriptNode[] stmts = this.statements;
        int last = stmts.length - 1;
        for (int i = 0; i < last; ++i) {
            this.executeVoid(frame, stmts[i], i, startIndex);
        }
        return this.executeDouble(frame, stmts[last], last, startIndex);
    }

    public boolean executeBoolean(VirtualFrame frame, JavaScriptNode node, int index, int argument) throws UnexpectedResultException {
        assert (index == this.getStatements().length - 1);
        try {
            return node.executeBoolean(frame);
        }
        catch (YieldException e) {
            this.setState(frame, index);
            throw e;
        }
    }

    public int executeInt(VirtualFrame frame, JavaScriptNode node, int index, int argument) throws UnexpectedResultException {
        assert (index == this.getStatements().length - 1);
        try {
            return node.executeInt(frame);
        }
        catch (YieldException e) {
            this.setState(frame, index);
            throw e;
        }
    }

    public double executeDouble(VirtualFrame frame, JavaScriptNode node, int index, int argument) throws UnexpectedResultException {
        assert (index == this.getStatements().length - 1);
        try {
            return node.executeDouble(frame);
        }
        catch (YieldException e) {
            this.setState(frame, index);
            throw e;
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new GeneratorExprBlockNode(GeneratorExprBlockNode.cloneUninitialized(this.getStatements(), materializedTags), GeneratorExprBlockNode.cloneUninitialized(this.readStateNode, materializedTags), (WriteNode)((Object)GeneratorExprBlockNode.cloneUninitialized((JavaScriptNode)((Object)this.writeStateNode), materializedTags)));
    }
}

