/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.wizard;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cordova.CordovaPerformer;
import org.netbeans.modules.cordova.CordovaPlatform;
import org.netbeans.modules.cordova.project.ConfigUtils;
import org.netbeans.modules.cordova.wizard.Bundle;
import org.netbeans.modules.cordova.wizard.CordovaSetupPanel;
import org.netbeans.modules.cordova.wizard.CordovaTemplate;
import org.netbeans.modules.cordova.wizard.SamplePanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CordovaSampleIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    protected transient WizardDescriptor.Panel[] myPanels;
    protected transient int myIndex;
    protected transient WizardDescriptor descriptor;

    public Set<?> instantiate() throws IOException {
        assert (false);
        return null;
    }

    public void initialize(WizardDescriptor wizard) {
        this.descriptor = wizard;
        this.myPanels = this.createPanels(wizard);
        String[] steps = this.createSteps();
        for (int i = 0; i < this.myPanels.length; ++i) {
            Component c = this.myPanels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    protected String[] createSteps() {
        if (CordovaPlatform.getDefault().isReady()) {
            return new String[]{Bundle.LBL_NameNLocation()};
        }
        return new String[]{Bundle.LBL_CordovaSetup(), Bundle.LBL_NameNLocation()};
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.myPanels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.myPanels[this.myIndex];
    }

    public boolean hasNext() {
        return this.myIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myIndex > 0;
    }

    public String name() {
        return null;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myIndex;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected WizardDescriptor.Panel[] createPanels(WizardDescriptor wizard) {
        if (CordovaPlatform.getDefault().isReady()) {
            return new WizardDescriptor.Panel[]{new SamplePanel(this.descriptor)};
        }
        return new WizardDescriptor.Panel[]{new CordovaSetupPanel(this.descriptor), new SamplePanel(this.descriptor)};
    }

    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.descriptor);
        String targetName = Templates.getTargetName((WizardDescriptor)this.descriptor);
        FileUtil.toFile((FileObject)targetFolder).mkdirs();
        FileObject projectFolder = targetFolder.createFolder(targetName);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.descriptor);
        this.unZipFile(template.getInputStream(), projectFolder);
        CordovaPlatform cordovaPlatform = CordovaPlatform.getDefault();
        ProjectManager.getDefault().clearNonProjectCache();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CordovaMapsSample", targetName);
        ConfigUtils.replaceTokens(projectFolder, map, "nbproject/project.xml");
        Project project = FileOwnerQuery.getOwner((FileObject)projectFolder);
        CordovaPerformer.createScript(project, "mapplugins.properties", "nbproject/plugins.properties", true);
        CordovaTemplate.CordovaExtender.setPhoneGapBrowser(project);
        CordovaPerformer.getDefault().createPlatforms(project).waitFinished();
        return Collections.singleton(projectFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unZipFile(InputStream source, FileObject rootFolder) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)rootFolder, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)rootFolder, (String)entry.getName());
                FileLock lock = fo.lock();
                try (OutputStream out = fo.getOutputStream(lock);){
                    FileUtil.copy((InputStream)str, (OutputStream)out);
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
        finally {
            source.close();
        }
    }
}

