/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages;

import javax.swing.text.Position;
import org.codehaus.groovy.ast.ASTNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.refactoring.findusages.FindUsagesPainter;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;

public class FindUsagesElement
extends SimpleRefactoringElementImplementation
implements Comparable<FindUsagesElement> {
    private final RefactoringElement usageElement;
    private final BaseDocument doc;
    private final Line line;
    private final int lineNumber;

    public FindUsagesElement(RefactoringElement element, BaseDocument doc) {
        this.usageElement = element;
        this.doc = doc;
        this.line = GroovyProjectUtil.getLine(element.getFileObject(), element.getNode().getLineNumber() - 1);
        this.lineNumber = this.line.getLineNumber();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getText() {
        return this.usageElement.getName() + " -";
    }

    public String getDisplayText() {
        return FindUsagesPainter.colorASTNode(this.usageElement.getNode(), this.line);
    }

    public String getName() {
        return this.usageElement.getName();
    }

    public void performChange() {
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return this.usageElement.getFileObject();
    }

    public PositionBounds getPosition() {
        OffsetRange range = ASTUtils.getRange((ASTNode)this.usageElement.getNode(), (BaseDocument)this.doc);
        if (range == OffsetRange.NONE) {
            return null;
        }
        CloneableEditorSupport ces = GroovyProjectUtil.findCloneableEditorSupport(this.usageElement.getFileObject());
        PositionRef ref1 = ces.createPositionRef(range.getStart(), Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(range.getEnd(), Position.Bias.Forward);
        return new PositionBounds(ref1, ref2);
    }

    @Override
    public int compareTo(FindUsagesElement comparedElement) {
        return this.lineNumber - comparedElement.lineNumber;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.usageElement != null ? this.usageElement.hashCode() : 0);
        hash = 29 * hash + (this.doc != null ? this.doc.hashCode() : 0);
        hash = 29 * hash + (this.line != null ? this.line.hashCode() : 0);
        hash = 29 * hash + this.lineNumber;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FindUsagesElement other = (FindUsagesElement)obj;
        if (!(this.usageElement == other.usageElement || this.usageElement != null && this.usageElement.equals(other.usageElement))) {
            return false;
        }
        if (!(this.doc == other.doc || this.doc != null && this.doc.equals(other.doc))) {
            return false;
        }
        if (!(this.line == other.line || this.line != null && this.line.equals(other.line))) {
            return false;
        }
        return this.lineNumber == other.lineNumber;
    }
}

