/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;

public class CCDocHtmlFormatter
extends HtmlFormatter {
    protected boolean isDeprecated;
    protected boolean isParameter;
    protected boolean isType;
    protected boolean isName;
    protected boolean isEmphasis;
    protected StringBuilder sb = new StringBuilder();

    public void reset() {
        this.textLength = 0;
        this.sb.setLength(0);
    }

    public void appendHtml(String html) {
        this.sb.append(html);
    }

    public void appendText(String text, int fromInclusive, int toExclusive) {
        for (int i = fromInclusive; i < toExclusive; ++i) {
            if (this.textLength >= this.maxLength) {
                if (this.textLength != this.maxLength) break;
                this.sb.append("...");
                this.textLength += 3;
                break;
            }
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    this.sb.append("&lt;");
                    break;
                }
                case '>': {
                    if (i > 1 && text.charAt(i - 2) == ']' && text.charAt(i - 1) == ']') {
                        this.sb.append("&gt;");
                        break;
                    }
                    this.sb.append(c);
                    break;
                }
                case '&': {
                    this.sb.append("&amp;");
                    break;
                }
                default: {
                    this.sb.append(c);
                }
            }
            ++this.textLength;
        }
    }

    public void name(ElementKind kind, boolean start) {
        assert (start != this.isName);
        this.isName = start;
        if (this.isName) {
            this.sb.append("<b>");
        } else {
            this.sb.append("</b>");
        }
    }

    public void parameters(boolean start) {
        assert (start != this.isParameter);
        this.isParameter = start;
    }

    public void active(boolean start) {
        this.emphasis(start);
    }

    public void type(boolean start) {
        assert (start != this.isType);
        this.isType = start;
        if (this.isType) {
            this.sb.append("<i>");
            this.sb.append("<font color=\"#404040\">");
        } else {
            this.sb.append("</font>");
            this.sb.append("</i>");
        }
    }

    public void deprecated(boolean start) {
        assert (start != this.isDeprecated);
        this.isDeprecated = start;
        if (this.isDeprecated) {
            this.sb.append("<s>");
        } else {
            this.sb.append("</s>");
        }
    }

    public String getText() {
        assert (!(this.isParameter || this.isDeprecated || this.isName || this.isType));
        return this.sb.toString();
    }

    public void emphasis(boolean start) {
        assert (start != this.isEmphasis);
        this.isEmphasis = start;
        if (this.isEmphasis) {
            this.sb.append("<b>");
        } else {
            this.sb.append("</b>");
        }
    }
}

