/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.dtd.grammar;

import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.netbeans.modules.xml.api.model.ExtendedGrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.dtd.grammar.ContentModel;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.Text;

class DTDGrammar
implements ExtendedGrammarQuery {
    private Map elementDecls;
    private Map attrDecls;
    private Map contentModels;
    private Map attrEnumerations;
    private Map defaultAttributeValues;
    private Set<String> entities;
    private Set<String> notations;
    private Set emptyElements;
    private List<String> resolvedEntities;

    DTDGrammar(Map elementDecls, Map contentModels, Map attrDecls, Map attrDefs, Map enums, Set entities, Set notations, Set emptyElements) {
        this.elementDecls = elementDecls;
        this.attrDecls = attrDecls;
        this.entities = entities;
        this.notations = notations;
        this.attrEnumerations = enums;
        this.contentModels = contentModels;
        this.defaultAttributeValues = attrDefs;
        this.emptyElements = emptyElements;
    }

    void setResolvedEntities(List resolvedEntities) {
        this.resolvedEntities = resolvedEntities;
    }

    @Override
    public List getResolvedEntities() {
        return this.resolvedEntities;
    }

    public Enumeration queryEntities(String prefix) {
        if (this.entities == null) {
            return Enumerations.empty();
        }
        LinkedList<MyEntityReference> list = new LinkedList<MyEntityReference>();
        for (String next : this.entities) {
            if (!next.startsWith(prefix)) continue;
            list.add(new MyEntityReference(next));
        }
        if ("lt".startsWith(prefix)) {
            list.add(new MyEntityReference("lt"));
        }
        if ("gt".startsWith(prefix)) {
            list.add(new MyEntityReference("gt"));
        }
        if ("apos".startsWith(prefix)) {
            list.add(new MyEntityReference("apos"));
        }
        if ("quot".startsWith(prefix)) {
            list.add(new MyEntityReference("quot"));
        }
        if ("amp".startsWith(prefix)) {
            list.add(new MyEntityReference("amp"));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((MyEntityReference)o1).getNodeName().compareTo(((MyEntityReference)o2).getNodeName());
            }

            @Override
            public boolean equals(Object obj) {
                return true;
            }
        });
        return Collections.enumeration(list);
    }

    public Enumeration queryAttributes(HintContext ctx) {
        if (this.attrDecls == null) {
            return Enumerations.empty();
        }
        Element el = null;
        String currentAttrName = null;
        if (ctx.getNodeType() == 2) {
            currentAttrName = ctx.getNodeName();
            el = ((Attr)((Object)ctx)).getOwnerElement();
        } else if (ctx.getNodeType() == 1) {
            el = (Element)((Object)ctx);
        }
        if (el == null) {
            return Enumerations.empty();
        }
        NamedNodeMap existingAttributes = el.getAttributes();
        Set possibleAttributes = (Set)this.attrDecls.get(el.getTagName());
        if (possibleAttributes == null) {
            return Enumerations.empty();
        }
        String prefix = ctx.getCurrentPrefix();
        LinkedList<MyAttr> list = new LinkedList<MyAttr>();
        for (String next : possibleAttributes) {
            if (!next.startsWith(prefix) || existingAttributes.getNamedItem(next) != null && !next.equals(currentAttrName)) continue;
            list.add(new MyAttr(next));
        }
        return Collections.enumeration(list);
    }

    public Enumeration queryElements(HintContext ctx) {
        if (this.elementDecls == null) {
            return Enumerations.empty();
        }
        Node node = ctx.getParentNode();
        TreeSet<String> elements = null;
        if (node instanceof Element) {
            Element el = (Element)node;
            if (el == null) {
                return Enumerations.empty();
            }
            Object model = null;
            String prefs = System.getProperty("netbeans.xml.completion", "default");
            model = "fast".equals(prefs) ? null : ("default".equals(prefs) || "accurate".equals(prefs) ? this.contentModels.get(el.getTagName()) : null);
            if (model instanceof String) {
                model = ContentModel.parseContentModel((String)model);
                this.contentModels.put(el.getTagName(), model);
            }
            if (model instanceof ContentModel) {
                Enumeration en = ((ContentModel)model).whatCanFollow(new PreviousEnumeration(el, ctx));
                if (en == null) {
                    return Enumerations.empty();
                }
                String prefix = ctx.getCurrentPrefix();
                elements = new TreeSet<String>();
                while (en.hasMoreElements()) {
                    String next = (String)en.nextElement();
                    if (!next.startsWith(prefix)) continue;
                    elements.add(next);
                }
            }
            if (elements == null) {
                elements = (TreeSet<String>)this.elementDecls.get(el.getTagName());
            }
        } else if (node instanceof Document) {
            elements = this.elementDecls.keySet();
        } else {
            return Enumerations.empty();
        }
        if (elements == null) {
            return Enumerations.empty();
        }
        String prefix = ctx.getCurrentPrefix();
        LinkedList<MyElement> list = new LinkedList<MyElement>();
        for (String next : elements) {
            if (!next.startsWith(prefix)) continue;
            boolean empty = this.emptyElements.contains(next);
            list.add(new MyElement(next, empty));
        }
        return Collections.enumeration(list);
    }

    public Enumeration queryNotations(String prefix) {
        if (this.notations == null) {
            return Enumerations.empty();
        }
        LinkedList<MyNotation> list = new LinkedList<MyNotation>();
        for (String next : this.notations) {
            if (!next.startsWith(prefix)) continue;
            list.add(new MyNotation(next));
        }
        return Collections.enumeration(list);
    }

    public Enumeration queryValues(HintContext ctx) {
        if (this.attrEnumerations.isEmpty()) {
            return Enumerations.empty();
        }
        if (ctx.getNodeType() == 2) {
            String attributeName = ctx.getNodeName();
            Element element = ((Attr)((Object)ctx)).getOwnerElement();
            if (element == null) {
                return Enumerations.empty();
            }
            String elementName = element.getNodeName();
            String key = elementName + " " + attributeName;
            List values = (List)this.attrEnumerations.get(key);
            if (values == null) {
                return Enumerations.empty();
            }
            String prefix = ctx.getCurrentPrefix();
            LinkedList<MyText> en = new LinkedList<MyText>();
            for (String next : values) {
                if (!next.startsWith(prefix)) continue;
                en.add(new MyText(next, next));
            }
            return Collections.enumeration(en);
        }
        return Enumerations.empty();
    }

    @Override
    public GrammarResult queryDefault(HintContext ctx) {
        Node node = ctx;
        if (ctx.getNodeType() == 3 && (node = ctx.getParentNode()) == null) {
            return null;
        }
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            Element element = attr.getOwnerElement();
            if (element == null) {
                return null;
            }
            String elementName = element.getNodeName();
            String attributeName = attr.getNodeName();
            String key = elementName + " " + attributeName;
            String def = (String)this.defaultAttributeValues.get(key);
            if (def == null) {
                return null;
            }
            return new MyText(def, def);
        }
        return null;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    @Override
    public Component getCustomizer(HintContext ctx) {
        return null;
    }

    @Override
    public boolean hasCustomizer(HintContext ctx) {
        return false;
    }

    public Node.Property[] getProperties(HintContext ctx) {
        return null;
    }

    public String toString() {
        return "DTD grammar";
    }

    private static class MyText
    extends AbstractResultNode
    implements Text {
        private final String data;
        private final String displayName;

        MyText(String data, String displayName) {
            this.data = data;
            this.displayName = displayName;
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public int getLength() {
            return this.data == null ? -1 : this.data.length();
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class MyNotation
    extends AbstractResultNode
    implements Notation {
        private String name;

        MyNotation(String name) {
            this.name = name;
        }

        @Override
        public short getNodeType() {
            return 12;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }
    }

    private static class MyAttr
    extends AbstractResultNode
    implements Attr {
        private String name;

        MyAttr(String name) {
            this.name = name;
        }

        @Override
        public short getNodeType() {
            return 2;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return null;
        }
    }

    private static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;
        private boolean empty;

        MyElement(String name, boolean empty) {
            this.name = name;
            this.empty = empty;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        @Override
        public boolean isEmptyElement() {
            return this.empty;
        }
    }

    private static class MyEntityReference
    extends AbstractResultNode
    implements EntityReference {
        private String name;

        MyEntityReference(String name) {
            this.name = name;
        }

        @Override
        public short getNodeType() {
            return 5;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }
    }

    private static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private AbstractResultNode() {
        }

        @Override
        public Icon getIcon(int kind) {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        public String getText() {
            return this.getNodeName();
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public boolean isEmptyElement() {
            return false;
        }
    }

    private static class PreviousEnumeration
    implements Enumeration {
        private final Node parent;
        private final Element lastElement;
        private Node next;
        private boolean eoeSeen = false;

        PreviousEnumeration(Node parent, Node pointer) {
            Node last;
            this.parent = parent;
            for (last = pointer.getPreviousSibling(); last != null && last.getNodeType() != 1; last = last.getPreviousSibling()) {
            }
            this.lastElement = (Element)last;
            if (last != null) {
                this.fetchNext(parent.getFirstChild());
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            try {
                String string = this.next.getNodeName();
                return string;
            }
            finally {
                this.fetchNext(this.next.getNextSibling());
            }
        }

        private void fetchNext(Node candidate) {
            this.next = candidate;
            if (this.eoeSeen) {
                this.next = null;
            } else {
                while (this.next != null && this.next.getNodeType() != 1) {
                    this.next = this.next.getNextSibling();
                }
                if (this.lastElement.equals(this.next)) {
                    this.eoeSeen = true;
                }
            }
        }
    }
}

