/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.SwingUtilities;

public class Logger {
    private static boolean assertionsEnabled = false;
    private static Level nonUIThreadAssertionLevel;
    private static final long startTimeMillis;
    private static final java.util.logging.Logger instance;

    private Logger() {
    }

    public static java.util.logging.Logger getInstance() {
        return instance;
    }

    public static void severe(String message) {
        instance.severe(message);
    }

    public static void assertTrue(boolean value) {
        if (assertionsEnabled && !value) {
            String message = "Assertion error";
            instance.log(Level.SEVERE, message, new Exception(message));
        }
    }

    public static void assertTrue(boolean value, String message) {
        if (assertionsEnabled && !value) {
            instance.log(Level.SEVERE, message, new Exception(message));
        }
    }

    public static void assertFalse(boolean value) {
        if (assertionsEnabled && value) {
            String message = "Assertion error";
            instance.log(Level.SEVERE, message, new Exception(message));
        }
    }

    public static void assertFalse(boolean value, String message) {
        if (assertionsEnabled && value) {
            instance.log(Level.SEVERE, message, new Exception(message));
        }
    }

    public static void assertNonUiThread(String message) {
        if (assertionsEnabled && SwingUtilities.isEventDispatchThread()) {
            instance.log(nonUIThreadAssertionLevel, message, new Exception(message));
        }
    }

    public static void assertNonUiThread() {
        Logger.assertNonUiThread("Should not be called from UI thread");
    }

    public static void fullThreadDump(String title) {
        Set<Map.Entry<Thread, StackTraceElement[]>> stack = Thread.getAllStackTraces().entrySet();
        System.err.printf("----- %s Start Thread Dump-----\n", title == null ? "" : title);
        for (Map.Entry<Thread, StackTraceElement[]> entry : stack) {
            System.err.println(entry.getKey().getName());
            for (StackTraceElement element : entry.getValue()) {
                System.err.println("\tat " + element.toString());
            }
            System.err.println();
        }
        System.err.println("----- End Thread Dump-----");
    }

    static {
        startTimeMillis = System.currentTimeMillis();
        instance = java.util.logging.Logger.getLogger("nativeexecution.support.logger");
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        String level = System.getProperty("Execution.nonUIThreadAsservionLevel", "INFO").toUpperCase();
        try {
            nonUIThreadAssertionLevel = Level.parse(level);
        }
        catch (IllegalArgumentException ex) {
            nonUIThreadAssertionLevel = Level.INFO;
        }
        instance.addHandler(new LoggerHandler());
    }

    private static class LoggerHandler
    extends Handler {
        private LoggerHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            record.setMessage("[" + (System.currentTimeMillis() - startTimeMillis) + " ms.] " + record.getMessage());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

