/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientCapabilities;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientWrapper;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.ShowStatusMessageParams;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceIOContext;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceServiceImpl;
import org.netbeans.modules.java.lsp.server.protocol.WorkspaceUIContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Server {
    private static final Logger LOG = Logger.getLogger(Server.class.getName());
    static final ThreadLocal<NbCodeLanguageClient> DISPATCHERS = new ThreadLocal();
    private static final RequestProcessor SERVER_INIT_RP = new RequestProcessor(LanguageServerImpl.class.getName());
    public static final String JAVA_BUILD_WORKSPACE = "java.build.workspace";
    public static final String GRAALVM_PAUSE_SCRIPT = "graalvm.pause.script";
    static final String INDEXING_COMPLETED = "Indexing completed.";
    static final String NO_JAVA_SUPPORT = "Cannot initialize Java support on JDK ";
    static final NbCodeLanguageClient STUB_CLIENT = new NbCodeLanguageClient(){
        private final NbCodeClientCapabilities caps = new NbCodeClientCapabilities();

        private void logWarning(Object ... args) {
            LOG.log(Level.WARNING, "LSP Client called without proper context with param(s): {0}", Arrays.asList(args));
        }

        @Override
        public void showStatusBarMessage(ShowStatusMessageParams params) {
            this.logWarning(new Object[]{params});
        }

        @Override
        public NbCodeClientCapabilities getNbCodeCapabilities() {
            this.logWarning(new Object[0]);
            return this.caps;
        }

        public void telemetryEvent(Object object) {
            this.logWarning(object);
        }

        public void publishDiagnostics(PublishDiagnosticsParams diagnostics) {
            this.logWarning(diagnostics);
        }

        public void showMessage(MessageParams messageParams) {
            this.logWarning(messageParams);
        }

        public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams requestParams) {
            this.logWarning(requestParams);
            CompletableFuture<MessageActionItem> x = new CompletableFuture<MessageActionItem>();
            x.complete(null);
            return x;
        }

        public void logMessage(MessageParams message) {
            this.logWarning(message);
        }
    };

    private Server() {
    }

    public static NbCodeLanguageClient getStubClient() {
        return STUB_CLIENT;
    }

    public static boolean isClientResponseThread(NbCodeLanguageClient client) {
        return client != null ? DISPATCHERS.get() == client : DISPATCHERS.get() != null;
    }

    public static void launchServer(InputStream in, OutputStream out) {
        LanguageServerImpl server = new LanguageServerImpl();
        ConsumeWithLookup msgProcessor = new ConsumeWithLookup(server.getSessionLookup());
        Launcher<NbCodeLanguageClient> serverLauncher = Server.createLauncher(server, in, out, msgProcessor::attachLookup);
        NbCodeLanguageClient remote = (NbCodeLanguageClient)serverLauncher.getRemoteProxy();
        server.connect(remote);
        msgProcessor.attachClient(server.client);
        Future runningServer = serverLauncher.startListening();
        try {
            runningServer.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static Launcher<NbCodeLanguageClient> createLauncher(LanguageServerImpl server, InputStream in, OutputStream out, Function<MessageConsumer, MessageConsumer> processor) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(NbCodeLanguageClient.class).setInput(in).setOutput(out).wrapMessages(processor).create();
    }

    private static class LanguageServerImpl
    implements LanguageServer,
    LanguageClientAware {
        private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class.getName());
        private NbCodeClientWrapper client;
        private final TextDocumentService textDocumentService = new TextDocumentServiceImpl();
        private final WorkspaceService workspaceService = new WorkspaceServiceImpl();
        private final InstanceContent sessionServices = new InstanceContent();
        private final Lookup sessionLookup = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)this.sessionServices), Lookup.getDefault()});

        private LanguageServerImpl() {
        }

        Lookup getSessionLookup() {
            return this.sessionLookup;
        }

        private void asyncOpenSelectedProjects(CompletableFuture f, List<FileObject> projectCandidates) {
            ArrayList<Project> projects = new ArrayList<Project>();
            try {
                for (FileObject candidate : projectCandidates) {
                    Project prj = FileOwnerQuery.getOwner((FileObject)candidate);
                    if (prj == null) continue;
                    projects.add(prj);
                }
                try {
                    Project[] previouslyOpened = (Project[])OpenProjects.getDefault().openProjects().get();
                    if (previouslyOpened.length > 0) {
                        Level level = Level.FINEST;
                        assert ((level = Level.CONFIG) != null);
                        for (Project p : previouslyOpened) {
                            LOG.log(level, "Previously opened project at {0}", p.getProjectDirectory());
                        }
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
                OpenProjects.getDefault().open(projects.toArray(new Project[0]), false);
                try {
                    OpenProjects.getDefault().openProjects().get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new IllegalStateException(ex);
                }
                for (Project prj : projects) {
                    ProjectUtils.getSources((Project)prj).getSourceGroups("generic");
                }
                Project[] prjs = projects.toArray(new Project[projects.size()]);
                f.complete(prjs);
            }
            catch (RuntimeException ex) {
                f.completeExceptionally(ex);
            }
        }

        private JavaSource showIndexingCompleted(Project[] opened) {
            try {
                ClasspathInfo info = ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY);
                JavaSource source = JavaSource.create((ClasspathInfo)info, (FileObject[])new FileObject[0]);
                if (source == null) {
                    SERVER_INIT_RP.post(() -> {
                        String msg = Server.NO_JAVA_SUPPORT + System.getProperty("java.version");
                        this.showStatusBarMessage(MessageType.Error, msg, 5000);
                    });
                } else {
                    source.runWhenScanFinished(cc -> this.showStatusBarMessage(MessageType.Info, Server.INDEXING_COMPLETED, 0), true);
                }
                return source;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private void showStatusBarMessage(MessageType type, String msg, int timeout) {
            if (this.client.getNbCodeCapabilities().hasStatusBarMessageSupport()) {
                this.client.showStatusBarMessage(new ShowStatusMessageParams(type, msg, timeout));
            } else {
                this.client.showMessage(new ShowStatusMessageParams(type, msg, timeout));
            }
        }

        private InitializeResult constructInitResponse(JavaSource src) {
            ServerCapabilities capabilities = new ServerCapabilities();
            if (src != null) {
                capabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
                CompletionOptions completionOptions = new CompletionOptions();
                completionOptions.setResolveProvider(Boolean.valueOf(true));
                completionOptions.setTriggerCharacters(Collections.singletonList("."));
                capabilities.setCompletionProvider(completionOptions);
                capabilities.setCodeActionProvider(Boolean.valueOf(true));
                capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
                capabilities.setDefinitionProvider(Boolean.valueOf(true));
                capabilities.setDocumentHighlightProvider(Boolean.valueOf(true));
                capabilities.setReferencesProvider(Boolean.valueOf(true));
                capabilities.setExecuteCommandProvider(new ExecuteCommandOptions(Arrays.asList(Server.JAVA_BUILD_WORKSPACE, Server.GRAALVM_PAUSE_SCRIPT)));
            }
            return new InitializeResult(capabilities);
        }

        public CompletableFuture<InitializeResult> initialize(InitializeParams init) {
            NbCodeClientCapabilities capa = NbCodeClientCapabilities.get(init);
            this.client.setClientCaps(capa);
            ArrayList<FileObject> projectCandidates = new ArrayList<FileObject>();
            List folders = init.getWorkspaceFolders();
            if (folders != null) {
                for (WorkspaceFolder w : folders) {
                    try {
                        projectCandidates.add(TextDocumentServiceImpl.fromUri(w.getUri()));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            } else {
                String root = init.getRootUri();
                if (root != null) {
                    try {
                        projectCandidates.add(TextDocumentServiceImpl.fromUri(root));
                    }
                    catch (MalformedURLException ex) {
                        LOG.log(Level.FINE, null, ex);
                    }
                }
            }
            CompletableFuture fProjects = new CompletableFuture();
            SERVER_INIT_RP.post(() -> this.asyncOpenSelectedProjects(fProjects, projectCandidates));
            return ((CompletableFuture)fProjects.thenApply(this::showIndexingCompleted)).thenApply(this::constructInitResponse);
        }

        public CompletableFuture<Object> shutdown() {
            return CompletableFuture.completedFuture(null);
        }

        public void exit() {
        }

        public TextDocumentService getTextDocumentService() {
            return this.textDocumentService;
        }

        public WorkspaceService getWorkspaceService() {
            return this.workspaceService;
        }

        public void connect(LanguageClient aClient) {
            this.client = new NbCodeClientWrapper((NbCodeLanguageClient)aClient);
            this.sessionServices.add((Object)this.client);
            this.sessionServices.add((Object)new WorkspaceIOContext(){

                @Override
                protected LanguageClient client() {
                    return client;
                }
            });
            this.sessionServices.add((Object)new WorkspaceUIContext(this.client));
            ((LanguageClientAware)this.getTextDocumentService()).connect(aClient);
            ((LanguageClientAware)this.getWorkspaceService()).connect(aClient);
        }
    }

    private static class ConsumeWithLookup {
        private final Lookup sessionLookup;
        private NbCodeLanguageClient client;

        public ConsumeWithLookup(Lookup sessionLookup) {
            this.sessionLookup = sessionLookup;
        }

        synchronized void attachClient(NbCodeLanguageClient client) {
            this.client = client;
        }

        public MessageConsumer attachLookup(final MessageConsumer delegate) {
            return new MessageConsumer(){

                public void consume(Message msg) throws MessageIssueException, JsonRpcException {
                    try {
                        DISPATCHERS.set(client);
                        Lookups.executeWith((Lookup)sessionLookup, () -> delegate.consume(msg));
                    }
                    finally {
                        DISPATCHERS.remove();
                    }
                }
            };
        }
    }
}

