/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ModuleLifecycleManager
extends ModuleInstall
implements ErrorHandler,
EntityResolver {
    static final String[] vcsGenericModules = new String[]{"org.netbeans.modules.vcs.advanced", "org.netbeans.modules.vcs.profiles.cvsprofiles", "org.netbeans.modules.vcs.profiles.vss", "org.netbeans.modules.vcs.profiles.pvcs", "org.netbeans.modules.vcs.profiles.teamware"};

    public void restored() {
        this.disableOldModules();
    }

    private void disableOldModules() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean notified = false;
                block17: for (int i = 0; i < vcsGenericModules.length; ++i) {
                    FileLock lock = null;
                    OutputStream os = null;
                    try {
                        String newModule = vcsGenericModules[i];
                        String newModuleXML = "Modules/" + newModule.replace('.', '-') + ".xml";
                        FileObject fo = FileUtil.getConfigFile((String)newModuleXML);
                        if (fo == null) continue;
                        Document document = ModuleLifecycleManager.this.readModuleDocument(fo);
                        NodeList list = document.getDocumentElement().getElementsByTagName("param");
                        int n = list.getLength();
                        for (int j = 0; j < n; ++j) {
                            Element node = (Element)list.item(j);
                            if (!"enabled".equals(node.getAttribute("name"))) continue;
                            Text text = (Text)node.getChildNodes().item(0);
                            String value = text.getNodeValue();
                            if (!"true".equals(value)) continue block17;
                            text.setNodeValue("false");
                            break;
                        }
                        if (!notified) {
                            JOptionPane.showMessageDialog(null, NbBundle.getBundle(ModuleLifecycleManager.class).getString("MSG_Install_Warning"), NbBundle.getBundle(ModuleLifecycleManager.class).getString("MSG_Install_Warning_Title"), 2);
                            notified = true;
                        }
                        lock = fo.lock();
                        os = fo.getOutputStream(lock);
                        XMLUtil.write((Document)document, (OutputStream)os, (String)"UTF-8");
                        continue;
                    }
                    catch (Exception e) {
                        Subversion.LOG.log(Level.INFO, e.getMessage(), e);
                        continue;
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            }
        };
        Utils.post((Runnable)runnable);
    }

    private Document readModuleDocument(FileObject fo) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        DocumentBuilder parser = dbf.newDocumentBuilder();
        parser.setEntityResolver(this);
        parser.setErrorHandler(this);
        InputStream is = fo.getInputStream();
        Document document = parser.parse(is);
        is.close();
        return document;
    }

    public void uninstalled() {
        Subversion.getInstance().shutdown();
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    @Override
    public void error(SAXParseException exception) {
        Subversion.LOG.log(Level.INFO, exception.getMessage(), exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        Subversion.LOG.log(Level.INFO, exception.getMessage(), exception);
    }

    @Override
    public void warning(SAXParseException exception) {
        Subversion.LOG.log(Level.INFO, exception.getMessage(), exception);
    }
}

