/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.grizzly;

import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.istack.NotNull;
import com.sun.xml.ws.transport.tcp.grizzly.WSTCPStreamAlgorithm;
import com.sun.xml.ws.transport.tcp.server.IncomeMessageProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public final class WSTCPFramedConnectionHandler
implements Handler {
    private final WSTCPStreamAlgorithm streamAlgorithm;
    private final IncomeMessageProcessor messageProcessor;

    public WSTCPFramedConnectionHandler(@NotNull WSTCPStreamAlgorithm streamAlgorithm) {
        this.streamAlgorithm = streamAlgorithm;
        this.messageProcessor = IncomeMessageProcessor.getMessageProcessorForPort(streamAlgorithm.getPort());
    }

    public int handle(Object request, int code) throws IOException {
        if (code == 2) {
            ByteBuffer messageBuffer = this.streamAlgorithm.getByteBuffer();
            SocketChannel socketChannel = this.streamAlgorithm.getSocketChannel();
            this.messageProcessor.process(messageBuffer, socketChannel);
        }
        return 1;
    }

    @Override
    public void attachChannel(SocketChannel socketChannel) {
    }
}

