/**
 * @syntax // Object initialiser or literal { [ nameValuePair1[, nameValuePair2[, ...nameValuePairN] ] ] } // Called as a constructor new Object([value])
 * @returns {Object}
 */
function Object() {
}
/**
 * @since ECMAScript6
 * @syntax Object.getOwnPropertySymbols(obj)
 * @param {Object} obj
 * @returns {Array}
 * @static
 */
Object.getOwnPropertySymbols = function(obj) {};

/**
 * @returns {Function}
 */
Object.prototype.constructor = new Function();

/**
 * @since ECMAScript6
 * @syntax Object.is(value1, value2)
 * @param {String} value1
 * @param {String} value2
 * @returns {Boolean}
 * @static
 */
Object.is = function(value1, value2) {};

/**
 * @syntax obj.toLocaleString()
 * @returns {String}
 */
Object.prototype.toLocaleString = function() {};

/**
 * @syntax Object.defineProperties(obj, props)
 * @param {Object} obj
 * @param {Object} props
 * @returns {undefined}
 * @static
 */
Object.defineProperties = function(obj, props) {};

/**
 * @syntax Object.create(proto[, propertiesObject])
 * @param {Object} proto
 * @param {Object} propertiesObject
 * @returns {Object}
 * @static
 */
Object.create = function(proto) {};

/**
 * @syntax Object.getOwnPropertyDescriptor(obj, prop)
 * @param {Object} obj
 * @param {String} prop
 * @returns {Object}
 * @static
 */
Object.getOwnPropertyDescriptor = function(obj, prop) {};

/**
 * @since ECMAScript7
 * @syntax Object.getOwnPropertyDescriptors(obj)
 * @param {Object} obj
 * @returns {Object}
 * @static
 */
Object.getOwnPropertyDescriptors = function(obj) {};

/**
 * @syntax Object.seal(obj)
 * @param {Object} obj
 * @returns {Object}
 * @static
 */
Object.seal = function(obj) {};

/**
 * @syntax Object.preventExtensions(obj)
 * @param {Object} obj
 * @returns {Object}
 * @static
 */
Object.preventExtensions = function(obj) {};

/**
 * @syntax Object.freeze(obj)
 * @param {Object} obj
 * @returns {Object}
 * @static
 */
Object.freeze = function(obj) {};

/**
 * @syntax Object.getPrototypeOf(obj)
 * @param {Object} obj
 * @returns {Object}
 * @static
 */
Object.getPrototypeOf = function(obj) {};

/**
 * @syntax obj.toString()
 * @returns {String}
 */
Object.prototype.toString = function() {};

/**
 * @syntax Object.defineProperty(obj, prop, descriptor)
 * @param {Object} obj
 * @param {String} prop
 * @param {String} descriptor
 * @returns {Object}
 * @static
 */
Object.defineProperty = function(obj, prop, descriptor) {};

/**
 * @syntax Object.isSealed(obj)
 * @param {Object} obj
 * @returns {Boolean}
 * @static
 */
Object.isSealed = function(obj) {};

/**
 * @syntax Object.isExtensible(obj)
 * @param {Object} obj
 * @returns {Boolean}
 * @static
 */
Object.isExtensible = function(obj) {};

/**
 * @syntax prototypeObj.isPrototypeOf(obj)
 * @param {Object} prototypeObj
 * @param {Object} object
 * @returns {Boolean}
 */
Object.prototype.isPrototypeOf = function(obj) {};

/**
 * @syntax obj.hasOwnProperty(prop)
 * @param {String} prop
 * @returns {Boolean}
 */
Object.prototype.hasOwnProperty = function(prop) {};

/**
 * @syntax obj.propertyIsEnumerable(prop)
 * @param {String} prop
 * @returns {Boolean}
 */
Object.prototype.propertyIsEnumerable = function(prop) {};

/**
 * @since ECMAScript6
 * @syntax Object.assign(target, ...sources)
 * @param {Object} target
 * @param {Object} sources
 * @returns {Object}
 * @static
 */
Object.assign = function(target) {};

/**
 * @syntax Object.isFrozen(obj)
 * @param {Object} obj
 * @returns {Boolean}
 * @static
 */
Object.isFrozen = function(obj) {};

/**
 * @syntax Object.keys(obj)
 * @param {Object} obj
 * @returns {Array}
 * @static
 */
Object.keys = function(obj) {};

/**
 * @since ECMAScript7
 * @syntax Object.values(obj)
 * @param {Object} obj
 * @returns {Array}
 * @static
 */
Object.values = function(obj) {};

/**
 * @since ECMAScript7
 * @syntax Object.entries(obj)
 * @param {Object} obj
 * @returns {Array}
 * @static
 */
Object.entries = function(obj) {};

/**
 * @syntax Object.getOwnPropertyNames(obj)
 * @param {Object} obj
 * @returns {Array}
 * @static
 */
Object.getOwnPropertyNames = function(obj) {};

/**
 * @syntax object.valueOf()
 * @returns {Object}
 */
Object.prototype.valueOf = function() {};

/**
 * Represents the Object prototype object.
 * @syntax Object.prototype
 * @static
 */
Object.prototype;

