/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.RegexLanguageObject;
import com.oracle.truffle.regex.result.NoMatchResult;
import com.oracle.truffle.regex.result.RegexResultGetEndNode;
import com.oracle.truffle.regex.result.RegexResultGetStartNode;
import com.oracle.truffle.regex.runtime.nodes.ToIntNode;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public abstract class RegexResult
extends AbstractConstantKeysObject {
    static final String PROP_IS_MATCH = "isMatch";
    static final String PROP_GET_START = "getStart";
    static final String PROP_GET_END = "getEnd";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("isMatch", "getStart", "getEnd");

    public abstract int getStart(int var1);

    public abstract int getEnd(int var1);

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public final Object readMemberImpl(String symbol) throws UnknownIdentifierException {
        switch (symbol) {
            case "isMatch": {
                return this != NoMatchResult.getInstance();
            }
            case "getStart": {
                return new RegexResultGetStartMethod(this);
            }
            case "getEnd": {
                return new RegexResultGetEndMethod(this);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnknownIdentifierException.create((String)symbol);
    }

    @ExportMessage
    boolean isMemberInvocable(String member, @Cached IsInvocableCacheNode cache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) {
        return cache.execute((RegexResult)receiverProfile.profile((Object)this), member);
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToIntNode toIntNode, @Cached InvokeCacheNode invokeCache, @Cached.Shared(value="receiverProfile") @Cached(value="createIdentityProfile()") ValueProfile receiverProfile) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (args.length != 1) {
            CompilerDirectives.transferToInterpreter();
            throw ArityException.create((int)1, (int)args.length);
        }
        return invokeCache.execute((RegexResult)receiverProfile.profile((Object)this), member, toIntNode.execute(args[0]));
    }

    @ReportPolymorphism
    @ImportStatic(value={RegexResult.class})
    @GenerateUncached
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(RegexResult var1, String var2, int var3) throws UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        Object getStartIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        Object getStartEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        Object getEndIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        Object getEndEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(replaces={"getStartEquals", "getEndEquals"})
        static Object invokeGeneric(RegexResult receiver, String symbol, int groupNumber, @Cached RegexResultGetStartNode getStartNode, @Cached RegexResultGetEndNode getEndNode) throws UnknownIdentifierException {
            switch (symbol) {
                case "getStart": {
                    return getStartNode.execute(receiver, groupNumber);
                }
                case "getEnd": {
                    return getEndNode.execute(receiver, groupNumber);
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.create((String)symbol);
        }
    }

    @GenerateUncached
    static abstract class IsInvocableCacheNode
    extends Node {
        IsInvocableCacheNode() {
        }

        abstract boolean execute(RegexResult var1, String var2);

        @Specialization(guards={"symbol == cachedSymbol"}, limit="2")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(RegexResult receiver, String symbol) {
            return RegexResult.PROP_GET_START.equals(symbol) || RegexResult.PROP_GET_END.equals(symbol);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public final class RegexResultGetEndMethod
    implements RegexLanguageObject {
        private final RegexResult result;

        public RegexResultGetEndMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetEndNode getEndNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreter();
                throw ArityException.create((int)1, (int)args.length);
            }
            return getEndNode.execute(this.result, toIntNode.execute(args[1]));
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public final class RegexResultGetStartMethod
    implements RegexLanguageObject {
        private final RegexResult result;

        public RegexResultGetStartMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetStartNode getStartNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreter();
                throw ArityException.create((int)1, (int)args.length);
            }
            return getStartNode.execute(this.result, toIntNode.execute(args[0]));
        }
    }
}

