/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.result.condition.AbstractRequestCondition;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class PatternsRequestCondition
extends AbstractRequestCondition<PatternsRequestCondition> {
    private static final SortedSet<PathPattern> EMPTY_PATTERNS = new TreeSet<PathPattern>(Collections.singleton(new PathPatternParser().parse("")));
    private final SortedSet<PathPattern> patterns;

    public PatternsRequestCondition(PathPattern ... patterns) {
        this(Arrays.asList(patterns));
    }

    public PatternsRequestCondition(List<PathPattern> patterns) {
        this((SortedSet<PathPattern>)(patterns.isEmpty() ? EMPTY_PATTERNS : new TreeSet<PathPattern>(patterns)));
    }

    private PatternsRequestCondition(SortedSet<PathPattern> patterns) {
        this.patterns = patterns;
    }

    public Set<PathPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<PathPattern> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public PatternsRequestCondition combine(PatternsRequestCondition other) {
        SortedSet<PathPattern> combined;
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            combined = new TreeSet<PathPattern>();
            for (PathPattern pattern1 : this.patterns) {
                for (PathPattern pattern2 : other.patterns) {
                    combined.add(pattern1.combine(pattern2));
                }
            }
        } else {
            combined = !this.patterns.isEmpty() ? this.patterns : (!other.patterns.isEmpty() ? other.patterns : EMPTY_PATTERNS);
        }
        return new PatternsRequestCondition(combined);
    }

    @Override
    @Nullable
    public PatternsRequestCondition getMatchingCondition(ServerWebExchange exchange) {
        if (this.patterns.isEmpty()) {
            return this;
        }
        SortedSet<PathPattern> matches = this.getMatchingPatterns(exchange);
        return !matches.isEmpty() ? new PatternsRequestCondition(matches) : null;
    }

    private SortedSet<PathPattern> getMatchingPatterns(ServerWebExchange exchange) {
        PathContainer lookupPath = exchange.getRequest().getPath().pathWithinApplication();
        TreeSet<PathPattern> pathPatterns = new TreeSet<PathPattern>();
        for (PathPattern pattern : this.patterns) {
            if (!pattern.matches(lookupPath)) continue;
            pathPatterns.add(pattern);
        }
        return pathPatterns;
    }

    @Override
    public int compareTo(PatternsRequestCondition other, ServerWebExchange exchange) {
        Iterator iterator = this.patterns.iterator();
        Iterator<PathPattern> iteratorOther = other.getPatterns().iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = PathPattern.SPECIFICITY_COMPARATOR.compare(iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

