/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server.support;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import reactor.core.publisher.Mono;

public class RouterFunctionMapping
extends AbstractHandlerMapping
implements InitializingBean {
    @Nullable
    private RouterFunction<?> routerFunction;
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();

    public RouterFunctionMapping() {
    }

    public RouterFunctionMapping(RouterFunction<?> routerFunction) {
        this.routerFunction = routerFunction;
    }

    @Nullable
    public RouterFunction<?> getRouterFunction() {
        return this.routerFunction;
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isEmpty(this.messageReaders)) {
            ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
            this.messageReaders = codecConfigurer.getReaders();
        }
        if (this.routerFunction == null) {
            this.initRouterFunctions();
        }
    }

    protected void initRouterFunctions() {
        List<RouterFunction<?>> routerFunctions = this.routerFunctions();
        this.routerFunction = routerFunctions.stream().reduce(RouterFunction::andOther).orElse(null);
        this.logRouterFunctions(routerFunctions);
    }

    private List<RouterFunction<?>> routerFunctions() {
        List<RouterFunction<?>> functions = this.obtainApplicationContext().getBeanProvider(RouterFunction.class).orderedStream().map(router -> router).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(functions) ? functions : Collections.emptyList();
    }

    private void logRouterFunctions(List<RouterFunction<?>> routerFunctions) {
        if (this.logger.isDebugEnabled()) {
            int total = routerFunctions.size();
            String message = total + " RouterFunction(s) in " + this.formatMappingName();
            if (this.logger.isTraceEnabled()) {
                if (total > 0) {
                    routerFunctions.forEach(routerFunction -> this.logger.trace((Object)("Mapped " + routerFunction)));
                } else {
                    this.logger.trace((Object)message);
                }
            } else if (total > 0) {
                this.logger.debug((Object)message);
            }
        }
    }

    @Override
    protected Mono<?> getHandlerInternal(ServerWebExchange exchange) {
        if (this.routerFunction != null) {
            ServerRequest request = ServerRequest.create(exchange, this.messageReaders);
            return this.routerFunction.route(request).doOnNext(handler -> this.setAttributes(exchange.getAttributes(), request, (HandlerFunction<?>)handler));
        }
        return Mono.empty();
    }

    private void setAttributes(Map<String, Object> attributes, ServerRequest serverRequest, HandlerFunction<?> handlerFunction) {
        Map uriVariables;
        attributes.put(RouterFunctions.REQUEST_ATTRIBUTE, serverRequest);
        attributes.put(BEST_MATCHING_HANDLER_ATTRIBUTE, handlerFunction);
        PathPattern matchingPattern = (PathPattern)attributes.get(RouterFunctions.MATCHING_PATTERN_ATTRIBUTE);
        if (matchingPattern != null) {
            attributes.put(BEST_MATCHING_PATTERN_ATTRIBUTE, matchingPattern);
        }
        if ((uriVariables = (Map)attributes.get(RouterFunctions.URI_TEMPLATE_VARIABLES_ATTRIBUTE)) != null) {
            attributes.put(URI_TEMPLATE_VARIABLES_ATTRIBUTE, uriVariables);
        }
    }
}

