/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;

public class NbGlobalActionGoalProvider
extends AbstractMavenActionsProvider {
    private static final String FILENAME_FOLDER = "Projects/org-netbeans-modules-maven";
    private static final String FILENAME = "nbactions.xml";
    private static final String FILE_NAME_PATH = "Projects/org-netbeans-modules-maven/nbactions.xml";
    private static final Logger LOG = Logger.getLogger(NbGlobalActionGoalProvider.class.getName());
    private final AtomicBoolean resetCache = new AtomicBoolean(false);
    private FileChangeListener listener = null;

    @Override
    public InputStream getActionDefinitionStream() {
        this.checkListener();
        FileObject fo = FileUtil.getConfigFile((String)FILE_NAME_PATH);
        this.resetCache.set(false);
        if (fo != null) {
            try {
                return fo.getInputStream();
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.FINE, "File not found: " + FileUtil.getFileDisplayName((FileObject)fo), ex);
            }
        }
        return null;
    }

    private synchronized void checkListener() {
        if (this.listener == null) {
            this.listener = new FileChangeAdapter(){

                public void fileRenamed(FileRenameEvent fe) {
                    if (NbGlobalActionGoalProvider.FILENAME.equals(fe.getName() + "." + fe.getExt())) {
                        NbGlobalActionGoalProvider.this.resetCache();
                    }
                }

                public void fileDeleted(FileEvent fe) {
                    if (NbGlobalActionGoalProvider.FILENAME.equals(fe.getFile().getNameExt())) {
                        NbGlobalActionGoalProvider.this.resetCache();
                    }
                }

                public void fileChanged(FileEvent fe) {
                    if (NbGlobalActionGoalProvider.FILENAME.equals(fe.getFile().getNameExt())) {
                        NbGlobalActionGoalProvider.this.resetCache();
                    }
                }

                public void fileDataCreated(FileEvent fe) {
                    if (NbGlobalActionGoalProvider.FILENAME.equals(fe.getFile().getNameExt())) {
                        NbGlobalActionGoalProvider.this.resetCache();
                    }
                }
            };
            FileUtil.getConfigFile((String)FILENAME_FOLDER).addFileChangeListener(this.listener);
        }
    }

    private void resetCache() {
        this.resetCache.compareAndSet(false, true);
    }

    public NetbeansActionMapping[] getCustomMappings() {
        NetbeansActionMapping[] fallbackActions = new NetbeansActionMapping[]{};
        try {
            ArrayList<NetbeansActionMapping> toRet = new ArrayList<NetbeansActionMapping>();
            Reader read = this.performDynamicSubstitutions(Collections.emptyMap(), this.getRawMappingsAsString());
            ActionToGoalMapping mapping = this.reader.read(read);
            List<NetbeansActionMapping> lst = mapping.getActions();
            if (lst != null) {
                for (NetbeansActionMapping mapp : lst) {
                    if (!mapp.getActionName().startsWith("CUSTOM-")) continue;
                    toRet.add(mapp);
                }
            }
            return toRet.toArray(new NetbeansActionMapping[toRet.size()]);
        }
        catch (XmlPullParserException ex) {
            LOG.log(Level.FINE, "cannot parse", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "", ex);
        }
        return fallbackActions;
    }

    @Override
    protected boolean reloadStream() {
        return this.resetCache.get();
    }
}

