/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ArrayLengthNode.class)
public final class ArrayLengthNodeFactory {

    @GeneratedBy(value=ArrayLengthNode.SetArrayLengthOrDeleteNode.class)
    public static final class SetArrayLengthOrDeleteNodeGen
    extends ArrayLengthNode.SetArrayLengthOrDeleteNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile generic_mustDeleteProfile_;
        @CompilerDirectives.CompilationFinal
        private ScriptArray.ProfileHolder generic_setLengthProfile_;

        private SetArrayLengthOrDeleteNodeGen(boolean strict) {
            super(strict);
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void executeVoid(DynamicObject arg0Value, int arg1Value, boolean arg2Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg2Value))) {
                            assert (s1_.arrayType_.isStatelessType());
                            this.doCached(arg0Value, arg1Value, arg2Value, s1_.arrayType_, s1_.setLengthProfile_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    this.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_mustDeleteProfile_, this.generic_setLengthProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(DynamicObject arg0Value, int arg1Value, boolean arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : this.countCaches();
            try {
                if (exclude == 0) {
                    ScriptArray arrayType__;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg2Value))) {
                                assert (s1_.arrayType_.isStatelessType());
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (arrayType__ = ArrayLengthNode.getArrayType(arg0Value, arg2Value)).isInstance(ArrayLengthNode.getArrayType(arg0Value, arg2Value)) && arrayType__.isStatelessType() && count1_ < 4) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.arrayType_ = arrayType__;
                        s1_.setLengthProfile_ = ScriptArray.createSetLengthProfile();
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCached(arg0Value, arg1Value, arg2Value, s1_.arrayType_, s1_.setLengthProfile_);
                        return;
                    }
                }
                this.generic_mustDeleteProfile_ = ConditionProfile.createBinaryProfile();
                this.generic_setLengthProfile_ = ScriptArray.createSetLengthProfile();
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_mustDeleteProfile_, this.generic_setLengthProfile_);
                return;
            }
            finally {
                if (oldState != 0 || oldExclude != 0) {
                    this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            CachedData s1_ = this.cached_cache;
            while (s1_ != null) {
                ++cacheCount;
                s1_ = s1_.next_;
            }
            return cacheCount;
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.arrayType_, s1_.setLengthProfile_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_mustDeleteProfile_, this.generic_setLengthProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ArrayLengthNode.SetArrayLengthOrDeleteNode create(boolean strict) {
            return new SetArrayLengthOrDeleteNodeGen(strict);
        }

        @GeneratedBy(value=ArrayLengthNode.SetArrayLengthOrDeleteNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;
            @CompilerDirectives.CompilationFinal
            ScriptArray.ProfileHolder setLengthProfile_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=ArrayLengthNode.SetArrayLengthNode.class)
    public static final class SetArrayLengthNodeGen
    extends ArrayLengthNode.SetArrayLengthNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile generic_sealedProfile_;
        @CompilerDirectives.CompilationFinal
        private ScriptArray.ProfileHolder generic_setLengthProfile_;

        private SetArrayLengthNodeGen(boolean strict) {
            super(strict);
        }

        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public void executeVoid(DynamicObject arg0Value, int arg1Value, boolean arg2Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg2Value))) {
                            assert (s1_.arrayType_.isStatelessType());
                            this.doCached(arg0Value, arg1Value, arg2Value, s1_.arrayType_, s1_.setLengthProfile_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    this.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_sealedProfile_, this.generic_setLengthProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(DynamicObject arg0Value, int arg1Value, boolean arg2Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : this.countCaches();
            try {
                if (exclude == 0) {
                    ScriptArray arrayType__;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg2Value))) {
                                assert (s1_.arrayType_.isStatelessType());
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (arrayType__ = ArrayLengthNode.getArrayType(arg0Value, arg2Value)).isInstance(ArrayLengthNode.getArrayType(arg0Value, arg2Value)) && arrayType__.isStatelessType() && count1_ < 4) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.arrayType_ = arrayType__;
                        s1_.setLengthProfile_ = ScriptArray.createSetLengthProfile();
                        this.cached_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCached(arg0Value, arg1Value, arg2Value, s1_.arrayType_, s1_.setLengthProfile_);
                        return;
                    }
                }
                this.generic_sealedProfile_ = ConditionProfile.createBinaryProfile();
                this.generic_setLengthProfile_ = ScriptArray.createSetLengthProfile();
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state &= 0xFFFFFFFE;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                this.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_sealedProfile_, this.generic_setLengthProfile_);
                return;
            }
            finally {
                if (oldState != 0 || oldExclude != 0) {
                    this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            CachedData s1_ = this.cached_cache;
            while (s1_ != null) {
                ++cacheCount;
                s1_ = s1_.next_;
            }
            return cacheCount;
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.arrayType_, s1_.setLengthProfile_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_sealedProfile_, this.generic_setLengthProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ArrayLengthNode.SetArrayLengthNode create(boolean strict) {
            return new SetArrayLengthNodeGen(strict);
        }

        @GeneratedBy(value=ArrayLengthNode.SetArrayLengthNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;
            @CompilerDirectives.CompilationFinal
            ScriptArray.ProfileHolder setLengthProfile_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=ArrayLengthNode.ArrayLengthReadNode.class)
    public static final class ArrayLengthReadNodeGen
    extends ArrayLengthNode.ArrayLengthReadNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private int state_;
        @CompilerDirectives.CompilationFinal
        private int exclude_;
        @CompilerDirectives.CompilationFinal
        private IntLengthData intLength_cache;
        @CompilerDirectives.CompilationFinal
        private LongLengthData longLength_cache;

        private ArrayLengthReadNodeGen() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public Object executeObject(DynamicObject arg0Value, boolean arg1Value) {
            int state = this.state_;
            if (state != 0) {
                if ((state & 1) != 0) {
                    IntLengthData s1_ = this.intLength_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value))) {
                            assert (s1_.arrayType_.isStatelessType());
                            assert (ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt(s1_.arrayType_));
                            return ArrayLengthNode.ArrayLengthReadNode.doIntLength(arg0Value, arg1Value, s1_.arrayType_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 2) != 0) {
                    LongLengthData s2_ = this.longLength_cache;
                    while (s2_ != null) {
                        if (s2_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value))) {
                            assert (s2_.arrayType_.isStatelessType());
                            return ArrayLengthNode.ArrayLengthReadNode.doLongLength(arg0Value, arg1Value, s2_.arrayType_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    try {
                        return ArrayLengthNode.ArrayLengthReadNode.doUncachedIntLength(arg0Value, arg1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_ &= 0xFFFFFFFB;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state & 8) != 0) {
                    return ArrayLengthNode.ArrayLengthReadNode.doUncachedLongLength(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
        public int executeInt(DynamicObject arg0Value, boolean arg1Value) throws UnexpectedResultException {
            int state = this.state_;
            if ((state & 5) != 0) {
                if ((state & 1) != 0) {
                    IntLengthData s1_ = this.intLength_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value))) {
                            assert (s1_.arrayType_.isStatelessType());
                            assert (ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt(s1_.arrayType_));
                            return ArrayLengthNode.ArrayLengthReadNode.doIntLength(arg0Value, arg1Value, s1_.arrayType_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 4) != 0) {
                    try {
                        return ArrayLengthNode.ArrayLengthReadNode.doUncachedIntLength(arg0Value, arg1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_ &= 0xFFFFFFFB;
                        }
                        finally {
                            lock.unlock();
                        }
                        return JSTypesGen.expectInteger(ex.getResult());
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arg0Value, arg1Value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private Object executeAndSpecialize(DynamicObject arg0Value, boolean arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state = this.state_;
            int exclude = this.exclude_;
            int oldState = state;
            int oldExclude = exclude;
            int oldCacheCount = state == 0 ? 0 : this.countCaches();
            try {
                Object arrayType__;
                if ((exclude & 1) == 0) {
                    int count1_ = 0;
                    IntLengthData s1_ = this.intLength_cache;
                    if ((state & 1) != 0) {
                        while (s1_ != null) {
                            if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value))) {
                                assert (s1_.arrayType_.isStatelessType());
                                assert (ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt(s1_.arrayType_));
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && ((ScriptArray)(arrayType__ = ArrayLengthNode.getArrayType(arg0Value, arg1Value))).isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value)) && ((ScriptArray)arrayType__).isStatelessType() && ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt((ScriptArray)arrayType__) && count1_ < 4) {
                        s1_ = new IntLengthData(this.intLength_cache);
                        s1_.arrayType_ = arrayType__;
                        this.intLength_cache = s1_;
                        this.state_ = state |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        arrayType__ = ArrayLengthNode.ArrayLengthReadNode.doIntLength(arg0Value, arg1Value, s1_.arrayType_);
                        return arrayType__;
                    }
                }
                if ((exclude & 2) == 0) {
                    int count2_ = 0;
                    LongLengthData s2_ = this.longLength_cache;
                    if ((state & 2) != 0) {
                        while (s2_ != null) {
                            if (s2_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value))) {
                                assert (s2_.arrayType_.isStatelessType());
                                break;
                            }
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && ((ScriptArray)(arrayType__ = ArrayLengthNode.getArrayType(arg0Value, arg1Value))).isInstance(ArrayLengthNode.getArrayType(arg0Value, arg1Value)) && ((ScriptArray)arrayType__).isStatelessType() && count2_ < 4) {
                        s2_ = new LongLengthData(this.longLength_cache);
                        s2_.arrayType_ = arrayType__;
                        this.longLength_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.intLength_cache = null;
                        state &= 0xFFFFFFFE;
                        this.state_ = state |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Double d = ArrayLengthNode.ArrayLengthReadNode.doLongLength(arg0Value, arg1Value, s2_.arrayType_);
                        return d;
                    }
                }
                if ((exclude & 4) == 0) {
                    this.exclude_ = exclude |= 3;
                    this.intLength_cache = null;
                    this.longLength_cache = null;
                    state &= 0xFFFFFFFC;
                    this.state_ = state |= 4;
                    try {
                        lock.unlock();
                        hasLock = false;
                        Integer count2_ = ArrayLengthNode.ArrayLengthReadNode.doUncachedIntLength(arg0Value, arg1Value);
                        return count2_;
                    }
                    catch (UnexpectedResultException ex) {
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_ &= 0xFFFFFFFB;
                        }
                        finally {
                            lock.unlock();
                        }
                        Object object = ex.getResult();
                        if (oldState != 0 || oldExclude != 0) {
                            this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                        }
                        if (hasLock) {
                            lock.unlock();
                        }
                        return object;
                    }
                }
                this.exclude_ = exclude |= 7;
                this.intLength_cache = null;
                this.longLength_cache = null;
                state &= 0xFFFFFFF8;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Double d = ArrayLengthNode.ArrayLengthReadNode.doUncachedLongLength(arg0Value, arg1Value);
                return d;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (oldState != 0 || oldExclude != 0) {
                    this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
                }
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
            int newState = this.state_;
            int newExclude = this.exclude_;
            if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
                this.reportPolymorphicSpecialize();
            }
        }

        private int countCaches() {
            int cacheCount = 0;
            IntLengthData s1_ = this.intLength_cache;
            while (s1_ != null) {
                ++cacheCount;
                s1_ = s1_.next_;
            }
            LongLengthData s2_ = this.longLength_cache;
            while (s2_ != null) {
                ++cacheCount;
                s2_ = s2_.next_;
            }
            return cacheCount;
        }

        public NodeCost getCost() {
            int state = this.state_;
            if (state == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state & state - 1) == 0) {
                IntLengthData s1_ = this.intLength_cache;
                LongLengthData s2_ = this.longLength_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<ScriptArray>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state = this.state_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doIntLength";
            if ((state & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<ScriptArray>>();
                IntLengthData s1_ = this.intLength_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.arrayType_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doLongLength";
            if ((state & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                LongLengthData s2_ = this.longLength_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.arrayType_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doUncachedIntLength";
            s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[3] = s;
            s = new Object[3];
            s[0] = "doUncachedLongLength";
            s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ArrayLengthNode.ArrayLengthReadNode create() {
            return new ArrayLengthReadNodeGen();
        }

        @GeneratedBy(value=ArrayLengthNode.ArrayLengthReadNode.class)
        private static final class LongLengthData {
            @CompilerDirectives.CompilationFinal
            LongLengthData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;

            LongLengthData(LongLengthData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=ArrayLengthNode.ArrayLengthReadNode.class)
        private static final class IntLengthData {
            @CompilerDirectives.CompilationFinal
            IntLengthData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;

            IntLengthData(IntLengthData next_) {
                this.next_ = next_;
            }
        }
    }
}

