/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.JSGetOwnPropertyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSGetOwnPropertyNode.class)
public final class JSGetOwnPropertyNodeGen
extends JSGetOwnPropertyNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private ArrayData array_cache;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile getOwnPropertyString_stringCaseProfile_;
    @CompilerDirectives.CompilationFinal
    private CachedOrdinaryData cachedOrdinary_cache;
    @CompilerDirectives.CompilationFinal
    private JSClassProfile generic_jsclassProfile_;

    private JSGetOwnPropertyNodeGen(boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, boolean allowCaching) {
        super(needValue, needEnumerability, needConfigurability, needWritability, allowCaching);
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public PropertyDescriptor execute(DynamicObject arg0Value, Object arg1Value) {
        int state = this.state_;
        if (state != 0) {
            ArrayData s1_;
            if ((state & 1) != 0 && (s1_ = this.array_cache) != null && JSGuards.isJSArray(arg0Value)) {
                return this.array(arg0Value, arg1Value, s1_.toArrayIndexNode_, s1_.noSuchElementBranch_, s1_.typeProfile_);
            }
            if ((state & 2) != 0 && JSGuards.isJSString(arg0Value)) {
                return this.getOwnPropertyString(arg0Value, arg1Value, this.getOwnPropertyString_stringCaseProfile_);
            }
            if ((state & 4) != 0) {
                assert (this.allowCaching);
                CachedOrdinaryData s3_ = this.cachedOrdinary_cache;
                while (s3_ != null) {
                    if (!Assumption.isValidAssumption((Assumption)s3_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.removeCachedOrdinary_(s3_);
                        return this.executeAndSpecialize(arg0Value, arg1Value);
                    }
                    assert (s3_.cachedJSClass_ != null);
                    if (s3_.cachedJSClass_.isInstance(arg0Value) && s3_.cachedPropertyKey_.equals(arg1Value) && s3_.cachedShape_ == arg0Value.getShape()) {
                        return this.cachedOrdinary(arg0Value, arg1Value, s3_.cachedJSClass_, s3_.cachedShape_, s3_.cachedPropertyKey_, s3_.cachedProperty_);
                    }
                    s3_ = s3_.next_;
                }
            }
            if ((state & 8) != 0 && JSGetOwnPropertyNode.getJSClassIfOrdinary(arg0Value) != null) {
                return this.uncachedOrdinary(arg0Value, arg1Value);
            }
            if (!((state & 0x10) == 0 || this.generic_jsclassProfile_.getJSClass(arg0Value).usesOrdinaryGetOwnProperty() || JSGuards.isJSArray(arg0Value) || JSGuards.isJSString(arg0Value))) {
                return JSGetOwnPropertyNode.generic(arg0Value, arg1Value, this.generic_jsclassProfile_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value);
    }

    private PropertyDescriptor executeAndSpecialize(DynamicObject arg0Value, Object arg1Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            JSClassProfile generic_jsclassProfile__;
            if (JSGuards.isJSArray(arg0Value)) {
                ArrayData s1_ = (ArrayData)super.insert((Node)new ArrayData());
                s1_.toArrayIndexNode_ = s1_.insertAccessor(ToArrayIndexNode.create());
                s1_.noSuchElementBranch_ = BranchProfile.create();
                s1_.typeProfile_ = ValueProfile.createIdentityProfile();
                this.array_cache = s1_;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                PropertyDescriptor propertyDescriptor = this.array(arg0Value, arg1Value, s1_.toArrayIndexNode_, s1_.noSuchElementBranch_, s1_.typeProfile_);
                return propertyDescriptor;
            }
            if (JSGuards.isJSString(arg0Value)) {
                this.getOwnPropertyString_stringCaseProfile_ = ConditionProfile.createBinaryProfile();
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                PropertyDescriptor s1_ = this.getOwnPropertyString(arg0Value, arg1Value, this.getOwnPropertyString_stringCaseProfile_);
                return s1_;
            }
            if (exclude == 0 && this.allowCaching) {
                Assumption assumption0;
                Shape cachedShape__;
                JSClass cachedJSClass__;
                int count3_ = 0;
                CachedOrdinaryData s3_ = this.cachedOrdinary_cache;
                if ((state & 4) != 0) {
                    while (s3_ != null) {
                        assert (s3_.cachedJSClass_ != null);
                        if (s3_.cachedJSClass_.isInstance(arg0Value) && s3_.cachedPropertyKey_.equals(arg1Value) && s3_.cachedShape_ == arg0Value.getShape() && (s3_.assumption0_ == null || Assumption.isValidAssumption((Assumption)s3_.assumption0_))) break;
                        s3_ = s3_.next_;
                        ++count3_;
                    }
                }
                if (s3_ == null && (cachedJSClass__ = JSGetOwnPropertyNode.getJSClassIfOrdinary(arg0Value)) != null && cachedJSClass__.isInstance(arg0Value) && (cachedShape__ = arg0Value.getShape()) == arg0Value.getShape() && Assumption.isValidAssumption((Assumption)(assumption0 = cachedShape__.getValidAssumption())) && count3_ < 3) {
                    s3_ = new CachedOrdinaryData(this.cachedOrdinary_cache);
                    s3_.cachedJSClass_ = cachedJSClass__;
                    s3_.cachedShape_ = cachedShape__;
                    s3_.cachedPropertyKey_ = arg1Value;
                    s3_.cachedProperty_ = cachedShape__.getProperty(arg1Value);
                    s3_.assumption0_ = assumption0;
                    this.cachedOrdinary_cache = s3_;
                    this.state_ = state |= 4;
                }
                if (s3_ != null) {
                    lock.unlock();
                    hasLock = false;
                    PropertyDescriptor propertyDescriptor = this.cachedOrdinary(arg0Value, arg1Value, s3_.cachedJSClass_, s3_.cachedShape_, s3_.cachedPropertyKey_, s3_.cachedProperty_);
                    return propertyDescriptor;
                }
            }
            if (JSGetOwnPropertyNode.getJSClassIfOrdinary(arg0Value) != null) {
                this.exclude_ = exclude |= 1;
                this.cachedOrdinary_cache = null;
                state &= 0xFFFFFFFB;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                PropertyDescriptor count3_ = this.uncachedOrdinary(arg0Value, arg1Value);
                return count3_;
            }
            boolean Generic_duplicateFound_ = false;
            if (!((state & 0x10) == 0 || this.generic_jsclassProfile_.getJSClass(arg0Value).usesOrdinaryGetOwnProperty() || JSGuards.isJSArray(arg0Value) || JSGuards.isJSString(arg0Value))) {
                Generic_duplicateFound_ = true;
            }
            if (!(Generic_duplicateFound_ || (generic_jsclassProfile__ = JSClassProfile.create()).getJSClass(arg0Value).usesOrdinaryGetOwnProperty() || JSGuards.isJSArray(arg0Value) || JSGuards.isJSString(arg0Value) || (state & 0x10) != 0)) {
                this.generic_jsclassProfile_ = generic_jsclassProfile__;
                this.state_ = state |= 0x10;
                Generic_duplicateFound_ = true;
            }
            if (Generic_duplicateFound_) {
                lock.unlock();
                hasLock = false;
                PropertyDescriptor propertyDescriptor = JSGetOwnPropertyNode.generic(arg0Value, arg1Value, this.generic_jsclassProfile_);
                return propertyDescriptor;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null, null}, new Object[]{arg0Value, arg1Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        CachedOrdinaryData s3_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s3_ = this.cachedOrdinary_cache) == null || s3_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCachedOrdinary_(Object s3_) {
        Lock lock = this.getLock();
        lock.lock();
        try {
            CachedOrdinaryData prev = null;
            CachedOrdinaryData cur = this.cachedOrdinary_cache;
            while (cur != null) {
                if (cur == s3_) {
                    if (prev == null) {
                        this.cachedOrdinary_cache = cur.next_;
                        break;
                    }
                    prev.next_ = cur.next_;
                    break;
                }
                prev = cur;
                cur = cur.next_;
            }
            if (this.cachedOrdinary_cache == null) {
                this.state_ &= 0xFFFFFFFB;
            }
        }
        finally {
            lock.unlock();
        }
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "array";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            ArrayData s1_ = this.array_cache;
            if (s1_ != null) {
                cached.add(Arrays.asList(new Cloneable[]{s1_.toArrayIndexNode_, s1_.noSuchElementBranch_, s1_.typeProfile_}));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "getOwnPropertyString";
        if ((state & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.getOwnPropertyString_stringCaseProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "cachedOrdinary";
        if ((state & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            CachedOrdinaryData s3_ = this.cachedOrdinary_cache;
            while (s3_ != null) {
                cached.add(Arrays.asList(new Object[]{s3_.cachedJSClass_, s3_.cachedShape_, s3_.cachedPropertyKey_, s3_.cachedProperty_}));
                s3_ = s3_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "uncachedOrdinary";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "generic";
        if ((state & 0x10) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.generic_jsclassProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSGetOwnPropertyNode create(boolean needValue, boolean needEnumerability, boolean needConfigurability, boolean needWritability, boolean allowCaching) {
        return new JSGetOwnPropertyNodeGen(needValue, needEnumerability, needConfigurability, needWritability, allowCaching);
    }

    @GeneratedBy(value=JSGetOwnPropertyNode.class)
    private static final class CachedOrdinaryData {
        @CompilerDirectives.CompilationFinal
        CachedOrdinaryData next_;
        @CompilerDirectives.CompilationFinal
        JSClass cachedJSClass_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        Object cachedPropertyKey_;
        @CompilerDirectives.CompilationFinal
        Property cachedProperty_;
        @CompilerDirectives.CompilationFinal
        Assumption assumption0_;

        CachedOrdinaryData(CachedOrdinaryData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSGetOwnPropertyNode.class)
    private static final class ArrayData
    extends Node {
        @Node.Child
        ToArrayIndexNode toArrayIndexNode_;
        @CompilerDirectives.CompilationFinal
        BranchProfile noSuchElementBranch_;
        @CompilerDirectives.CompilationFinal
        ValueProfile typeProfile_;

        ArrayData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

