/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateConfigurationSettingsRequest
extends AmazonWebServiceRequest {
    private String applicationName;
    private String templateName;
    private String environmentName;
    private List<ConfigurationOptionSetting> optionSettings;

    public ValidateConfigurationSettingsRequest() {
    }

    public ValidateConfigurationSettingsRequest(String applicationName, List<ConfigurationOptionSetting> optionSettings) {
        this.applicationName = applicationName;
        this.optionSettings = optionSettings;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ValidateConfigurationSettingsRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public ValidateConfigurationSettingsRequest withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public ValidateConfigurationSettingsRequest withEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<ConfigurationOptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>();
        if (optionSettings != null) {
            optionSettingsCopy.addAll(optionSettings);
        }
        this.optionSettings = optionSettingsCopy;
    }

    public ValidateConfigurationSettingsRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        for (ConfigurationOptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public ValidateConfigurationSettingsRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>();
        if (optionSettings != null) {
            optionSettingsCopy.addAll(optionSettings);
        }
        this.optionSettings = optionSettingsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ApplicationName: " + this.applicationName + ", ");
        sb.append("TemplateName: " + this.templateName + ", ");
        sb.append("EnvironmentName: " + this.environmentName + ", ");
        sb.append("OptionSettings: " + this.optionSettings + ", ");
        sb.append("}");
        return sb.toString();
    }
}

