/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.data;

import java.util.Optional;

public final class JDKVersion {
    private final short major;
    private final Optional<Short> minor;
    private final Optional<Short> subminor;
    private final Optional<Short> update;
    public static JDKVersion IDE_JDK_VERSION;
    private static final String VERSION_MATCHER = "([0-9]+[\\._u\\-]+)*[0-9]+";
    private static final String VERSION_SPLITTER = "[\\._u\\-]+";
    private static final Short DEFAULT_VALUE;

    private JDKVersion(String string) {
        String[] split = string.split(VERSION_SPLITTER);
        this.major = split.length > 0 ? Short.parseShort(split[0]) : (short)0;
        this.minor = split.length > 1 ? Optional.of(Short.parseShort(split[1])) : Optional.empty();
        this.subminor = split.length > 2 ? Optional.of(Short.parseShort(split[2])) : Optional.empty();
        this.update = split.length > 3 ? Optional.of(Short.parseShort(split[3])) : Optional.empty();
    }

    private JDKVersion(Short major, Short minor, Short subminor, Short update) {
        this.major = major;
        this.minor = Optional.of(minor);
        this.subminor = Optional.of(subminor);
        this.update = Optional.of(update);
    }

    public short getMajor() {
        return this.major;
    }

    public Optional<Short> getMinor() {
        return this.minor;
    }

    public Optional<Short> getSubMinor() {
        return this.subminor;
    }

    public Optional<Short> getUpdate() {
        return this.update;
    }

    public boolean gt(JDKVersion version) {
        if (this.major > version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.gt(this.minor, version.getMinor())) {
                return true;
            }
            if (this.eq(this.minor, version.getMinor())) {
                if (this.gt(this.subminor, version.getSubMinor())) {
                    return true;
                }
                if (this.eq(this.subminor, version.getSubMinor()) && this.gt(this.update, version.getUpdate())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean lt(JDKVersion version) {
        if (this.major < version.getMajor()) {
            return true;
        }
        if (this.major == version.getMajor()) {
            if (this.lt(this.minor, version.getMinor())) {
                return true;
            }
            if (this.eq(this.minor, version.getMinor())) {
                if (this.lt(this.subminor, version.getSubMinor())) {
                    return true;
                }
                if (this.eq(this.subminor, version.getSubMinor()) && this.lt(this.update, version.getUpdate())) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean ge(JDKVersion version) {
        return this.gt(version) || this.equals(version);
    }

    public boolean le(JDKVersion version) {
        return this.lt(version) || this.equals(version);
    }

    private boolean gt(Optional<Short> v1, Optional<Short> v2) {
        return v1.orElse(DEFAULT_VALUE) > v2.orElse(DEFAULT_VALUE);
    }

    private boolean lt(Optional<Short> v1, Optional<Short> v2) {
        return v1.orElse(DEFAULT_VALUE) < v2.orElse(DEFAULT_VALUE);
    }

    private boolean eq(Optional<Short> v1, Optional<Short> v2) {
        if (!v1.isPresent() || !v2.isPresent()) {
            return true;
        }
        return v1.orElse(DEFAULT_VALUE).equals(v2.orElse(DEFAULT_VALUE));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JDKVersion other = (JDKVersion)obj;
        if (this.major != other.getMajor()) {
            return false;
        }
        if (!this.eq(this.minor, other.getMinor())) {
            return false;
        }
        if (!this.eq(this.subminor, other.getSubMinor())) {
            return false;
        }
        return this.eq(this.update, other.getUpdate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.major;
        hash = 89 * hash + this.minor.orElse(DEFAULT_VALUE);
        hash = 89 * hash + this.subminor.orElse(DEFAULT_VALUE);
        hash = 89 * hash + this.update.orElse(DEFAULT_VALUE);
        return hash;
    }

    public String toString() {
        StringBuilder value = new StringBuilder(this.major);
        if (this.minor.isPresent()) {
            value.append('.').append(this.minor.get());
        }
        if (this.subminor.isPresent()) {
            value.append('.').append(this.subminor.get());
        }
        if (this.update.isPresent()) {
            value.append('.').append(this.update.get());
        }
        return value.toString();
    }

    public static JDKVersion toValue(String version) {
        if (version != null && version.matches(VERSION_MATCHER)) {
            return new JDKVersion(version);
        }
        return null;
    }

    public static JDKVersion getDefaultPlatformVersion() {
        return IDE_JDK_VERSION;
    }

    public static boolean isCorrectJDK(JDKVersion jdkVersion, Optional<JDKVersion> minVersion, Optional<JDKVersion> maxVersion) {
        boolean correctJDK = true;
        if (minVersion.isPresent()) {
            correctJDK = jdkVersion.ge(minVersion.get());
        }
        if (correctJDK && maxVersion.isPresent()) {
            correctJDK = jdkVersion.le(maxVersion.get());
        }
        return correctJDK;
    }

    public static boolean isCorrectJDK(Optional<JDKVersion> minVersion, Optional<JDKVersion> maxVersion) {
        return JDKVersion.isCorrectJDK(IDE_JDK_VERSION, minVersion, maxVersion);
    }

    private static void initialize() {
        short major = 1;
        short minor = 0;
        short subminor = 0;
        short update = 0;
        try {
            String javaSpecVersion = System.getProperty("java.specification.version");
            String javaVersion = System.getProperty("java.version");
            String[] javaSpecVersionSplit = javaSpecVersion.split("\\.");
            if (javaSpecVersionSplit.length == 1) {
                String[] javaVersionSplit = javaVersion.split("-");
                String javaVersionCategory = javaVersionSplit[0];
                String[] split = javaVersionCategory.split("[\\.]+");
                if (split.length > 0) {
                    if (split.length > 0) {
                        major = Short.parseShort(split[0]);
                    }
                    if (split.length > 1) {
                        minor = Short.parseShort(split[1]);
                    }
                    if (split.length > 2) {
                        subminor = Short.parseShort(split[2]);
                    }
                    if (split.length > 3) {
                        update = Short.parseShort(split[3]);
                    }
                }
            } else {
                if (javaVersion == null || javaVersion.length() <= 0) {
                    return;
                }
                String[] javaVersionSplit = javaVersion.split("\\.");
                if (javaVersionSplit.length < 3 || !javaVersionSplit[0].equals("1")) {
                    return;
                }
                major = Short.parseShort(javaVersionSplit[0]);
                minor = Short.parseShort(javaVersionSplit[1]);
                if ((javaVersionSplit = javaVersionSplit[2].split("_")).length < 1) {
                    return;
                }
                subminor = Short.parseShort(javaVersionSplit[0]);
                if (javaVersionSplit.length > 1) {
                    update = Short.parseShort(javaVersionSplit[1]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IDE_JDK_VERSION = new JDKVersion(major, minor, subminor, update);
    }

    static {
        DEFAULT_VALUE = 0;
        JDKVersion.initialize();
    }
}

