/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;

public class Jdk12Support
extends Jdk11Compat {
    public ClassLoader newClassLoaderInstance(URL[] urls, ClassLoader parent) {
        return URLClassLoader.newInstance(urls, parent);
    }

    public Object doPrivileged(Action action) throws Exception {
        Object proxy = action.getProxy();
        if (proxy == null) {
            proxy = new PrivilegedProxy(action);
            action.setProxy(proxy);
        }
        try {
            return AccessController.doPrivileged((PrivilegedExceptionAction)proxy);
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            throw e;
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public URL[] getURLs(ClassLoader cl) {
        return ((URLClassLoader)cl).getURLs();
    }

    public URL[] getParentURLs(ClassLoader cl) {
        URLClassLoader scl = (URLClassLoader)cl;
        return ((URLClassLoader)cl.getParent()).getURLs();
    }

    static class PrivilegedProxy
    implements PrivilegedExceptionAction {
        Action action;

        PrivilegedProxy(Action act) {
            this.action = act;
        }

        public Object run() throws Exception {
            return this.action.run();
        }
    }
}

