/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import org.apache.tomcat.util.BufferEvent;
import org.apache.tomcat.util.BufferListener;

public class ByteBuffer {
    BufferEvent bufferEvent = new BufferEvent(this);
    BufferListener[] listeners = new BufferListener[10];
    int listenerCount = 0;
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    int defaultBufferSize = 8192;
    int bytesWritten = 0;
    public byte[] buf = new byte[this.defaultBufferSize];
    public int start;
    public int end;
    public int count;
    Object parent;
    public int pos;
    static final int debug = 0;

    public void recycle() {
        this.bytesWritten = 0;
        this.count = 0;
        this.pos = 0;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object o) {
        this.parent = o;
    }

    public void addBufferListener(BufferListener l) {
        this.listeners[this.listenerCount] = l;
        ++this.listenerCount;
    }

    public void doWrite(byte[] buf, int off, int count) {
        this.bufferEvent.setByteBuffer(buf);
        this.bufferEvent.setOffset(off);
        this.bufferEvent.setLength(count);
        int i = 0;
        while (i < this.listenerCount) {
            this.listeners[i].bufferFull(this.bufferEvent);
            ++i;
        }
    }

    public int doRead(byte[] buf, int off, int count) {
        this.bufferEvent.setByteBuffer(buf);
        this.bufferEvent.setOffset(off);
        this.bufferEvent.setLength(count);
        int i = 0;
        while (i < this.listenerCount) {
            this.listeners[i].bufferEmpty(this.bufferEvent);
            ++i;
        }
        return this.bufferEvent.getLength();
    }

    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
        ++this.bytesWritten;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int avail = this.buf.length - this.count;
        if (len <= avail) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            this.bytesWritten += len;
            return;
        }
        if (len - avail < this.buf.length) {
            System.arraycopy(b, off, this.buf, this.count, avail);
            this.count += avail;
            this.flush();
            System.arraycopy(b, off + avail, this.buf, this.count, len - avail);
            this.count += len - avail;
            this.bytesWritten += len - avail;
            return;
        }
        this.flush();
        this.doWrite(b, off, len);
    }

    public void flush() {
        if (this.count > 0) {
            this.doWrite(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public int read() {
        if (this.count == -1) {
            return -1;
        }
        if (this.pos >= this.count) {
            this.fill();
            if (this.count < 0) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int cnt;
        if (len == 0) {
            return 0;
        }
        int n = 0;
        int avail = this.count - this.pos;
        if (avail > 0) {
            cnt = avail < len ? avail : len;
            System.arraycopy(this.buf, this.pos, b, off, cnt);
            this.pos += cnt;
            n = cnt;
        }
        if (n >= len) {
            return n;
        }
        if (len - n >= this.buf.length) {
            return n + this.doRead(b, off + n, len - n);
        }
        this.fill();
        avail = this.count - this.pos;
        if (avail <= 0) {
            return n;
        }
        cnt = avail < len - n ? avail : len - n;
        System.arraycopy(this.buf, this.pos, b, off + n, cnt);
        this.pos += cnt;
        return n += cnt;
    }

    private void fill() {
        this.pos = 0;
        this.count = this.doRead(this.buf, 0, this.buf.length);
        if (this.count == 0) {
            this.count = -1;
        }
    }

    public boolean isContentWritten() {
        return this.bytesWritten != 0;
    }

    public void setBufferSize(int size) {
        if (size > this.buf.length) {
            this.buf = new byte[size];
        }
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    void log(String s) {
        System.out.println("ByteBuffer: " + s);
    }
}

