<?php



/**
 * Get number of rows affected by a query
 * <p>Returns the number of rows affected by a query associated with <code>result_id</code>.</p><p>For inserts, updates and deletes the number is the real number (sqlerrd[2]) of affected rows. For selects it is an estimate (sqlerrd[0]). Don't rely on it. The database server can never return the actual number of rows that will be returned by a SELECT because it has not even begun fetching them at this stage (just after the "PREPARE" when the optimizer has determined the query plan).</p><p>Useful after <code>ifx_prepare()</code> to limit queries to reasonable result sets.</p>
 * @param resource $result_id <p>A valid result id returned by <code>ifx_query()</code> or <code>ifx_prepare()</code>.</p>
 * @return int <p>Returns the number of rows as an integer.</p>
 * @link http://php.net/manual/en/function.ifx-affected-rows.php
 * @see ifx_num_rows()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_affected_rows($result_id): int {}

/**
 * Set the default blob mode for all select queries
 * <p>Set the default blob mode for all select queries.</p>
 * @param int $mode <p>Mode "0" means save Byte-Blobs in memory, and mode "1" means save Byte-Blobs in a file.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-blobinfile-mode.php
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_blobinfile_mode(int $mode): bool {}

/**
 * Set the default byte mode
 * <p>Sets the default byte mode for all select-queries.</p>
 * @param int $mode <p>Mode "0" will return a blob id, and mode "1" will return a varchar with text content.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-byteasvarchar.php
 * @see ifx_textasvarchar()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_byteasvarchar(int $mode): bool {}

/**
 * Close Informix connection
 * <p><b>ifx_close()</b> closes the link to an Informix database that's associated with the specified link identifier.</p><p>Note that this isn't usually necessary, as non-persistent open links are automatically closed at the end of the script's execution.</p><p><b>ifx_close()</b> will not close persistent links generated by <code>ifx_pconnect()</code>.</p>
 * @param resource $link_identifier <p>The link identifier. If not specified, the last opened link is assumed.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-close.php
 * @see ifx_connect(), ifx_pconnect()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_close($link_identifier = NULL): bool {}

/**
 * Open Informix server connection
 * <p><b>ifx_connect()</b> establishes a connection to an Informix server.</p><p>In case a second call is made to <b>ifx_connect()</b> with the same arguments, no new link will be established, but instead, the link identifier of the already opened link will be returned.</p><p>The link to the server will be closed as soon as the execution of the script ends, unless it's closed earlier by explicitly calling <code>ifx_close()</code>.</p>
 * @param string $database <p>The database name, as a string.</p>
 * @param string $userid <p>The username, as a string.</p>
 * @param string $password <p>The password, as a string.</p>
 * @return resource <p>Returns a connection identifier on success, or <b><code>FALSE</code></b> on error.</p>
 * @link http://php.net/manual/en/function.ifx-connect.php
 * @see ifx_pconnect(), ifx_close()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_connect(string $database = NULL, string $userid = NULL, string $password = NULL) {}

/**
 * Duplicates the given blob object
 * <p>Duplicates the given blob object.</p>
 * @param int $bid <p>A BLOB identifier.</p>
 * @return int <p>Returns the new blob object-id, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-copy-blob.php
 * @see ifx_create_blob(), ifx_free_blob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_copy_blob(int $bid): int {}

/**
 * Creates an blob object
 * <p>Creates a blob object.</p>
 * @param int $type <p>1 = TEXT, 0 = BYTE</p>
 * @param int $mode <p>0 = blob-object holds the content in memory, 1 = blob-object holds the content in file.</p>
 * @param string $param <p>if mode = 0: pointer to the content, if mode = 1: pointer to the filestring.</p>
 * @return int <p>Returns the new BLOB object-id, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-create-blob.php
 * @see ifx_copy_blob(), ifx_free_blob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_create_blob(int $type, int $mode, string $param): int {}

/**
 * Creates an char object
 * <p>Creates an char object.</p>
 * @param string $param <p>The char content.</p>
 * @return int <p>Returns the new char object id, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-create-char.php
 * @see ifx_free_char()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_create_char(string $param): int {}

/**
 * Execute a previously prepared SQL-statement
 * <p>Executes a previously prepared query or opens a cursor for it.</p><p>Does NOT free <code>result_id</code> on error.</p><p>Also sets the real number of <code>ifx_affected_rows()</code> for non-select statements for retrieval by <code>ifx_affected_rows()</code>.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-do.php
 * @see ifx_prepare()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_do($result_id): bool {}

/**
 * Returns error code of last Informix call
 * <p>Returns in a string one character describing the general results of a statement and both SQLSTATE and SQLCODE associated with the most recent SQL statement executed.</p>
 * @param resource $link_identifier <p>The link identifier.</p>
 * @return string <p>The Informix error codes (SQLSTATE &amp; SQLCODE) formatted as <i>x [SQLSTATE = aa bbb SQLCODE=cccc]</i>.</p><p>where x = space : no error</p><p>E : error</p><p>N : no more data</p><p>W : warning</p><p>&#63; : undefined</p><p>If the "x" character is anything other than space, SQLSTATE and SQLCODE describe the error in more detail.</p><p>See the Informix manual for the description of SQLSTATE and SQLCODE</p>
 * @link http://php.net/manual/en/function.ifx-error.php
 * @see ifx_errormsg()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_error($link_identifier = NULL): string {}

/**
 * Returns error message of last Informix call
 * <p>Returns the Informix error message associated with the most recent Informix error.</p>
 * @param int $errorcode <p>If specified, the function will return the message corresponding to the specified code.</p>
 * @return string <p>Return the error message, as a string.</p>
 * @link http://php.net/manual/en/function.ifx-errormsg.php
 * @see ifx_error()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_errormsg(int $errorcode = NULL): string {}

/**
 * Get row as an associative array
 * <p>Fetches one row of data from the result associated with the specified result identifier.</p><p>Subsequent calls to <b>ifx_fetch_row()</b> would return the next row in the result set, or <b><code>FALSE</code></b> if there are no more rows.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @param mixed $position <p>An optional parameter for a "fetch" operation on "scroll" cursors: <i>NEXT</i>, <i>PREVIOUS</i>, <i>CURRENT</i>, <i>FIRST</i>, <i>LAST</i> or a number. If you specify a number, an "absolute" row fetch is executed. This parameter is optional, and only valid for SCROLL cursors.</p>
 * @return array <p>Returns an associative array that corresponds to the fetched row, or <b><code>FALSE</code></b> if there are no more rows.</p><p>Blob columns are returned as integer blob id values for use in <code>ifx_get_blob()</code> unless you have used ifx_textasvarchar(1) or ifx_byteasvarchar(1), in which case blobs are returned as string values.</p>
 * @link http://php.net/manual/en/function.ifx-fetch-row.php
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_fetch_row($result_id, $position = NULL): array {}

/**
 * List of SQL fieldproperties
 * <p>Returns the Informix SQL fieldproperties of every field in the query as an associative array. Properties are encoded as: "SQLTYPE;length;precision;scale;ISNULLABLE" where SQLTYPE = the Informix type like "SQLVCHAR" etc. and ISNULLABLE = "Y" or "N".</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return array <p>Returns an associative array with fieldnames as key and the SQL fieldproperties as data for a query with <code>result_id</code>. Returns <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-fieldproperties.php
 * @see ifx_fieldtypes()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_fieldproperties($result_id): array {}

/**
 * List of Informix SQL fields
 * <p>Returns an associative array with fieldnames as key and the SQL fieldtypes as data for the query associated with <code>result_id</code>.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return array <p>Returns an associative array with fieldnames as key and the SQL fieldtypes as data for query with <code>result_id</code>. Returns <b><code>FALSE</code></b> on error.</p>
 * @link http://php.net/manual/en/function.ifx-fieldtypes.php
 * @see ifx_fieldproperties()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_fieldtypes($result_id): array {}

/**
 * Deletes the blob object
 * <p>Deletes the blobobject for the given blob object-id.</p>
 * @param int $bid <p>The BLOB object id.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-free-blob.php
 * @see ifx_create_blob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_free_blob(int $bid): bool {}

/**
 * Deletes the char object
 * <p>Deletes the charobject for the given char object-id.</p>
 * @param int $bid <p>The char object id.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-free-char.php
 * @see ifx_create_char()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_free_char(int $bid): bool {}

/**
 * Releases resources for the query
 * <p>Releases resources for the query associated with <code>result_id</code>.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-free-result.php
 * @see ifx_do()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_free_result($result_id): bool {}

/**
 * Return the content of a blob object
 * <p>Returns the content of the blob object.</p>
 * @param int $bid <p>The BLOB object id.</p>
 * @return string <p>The contents of the BLOB as a string, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-get-blob.php
 * @see ifx_get_char()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_get_blob(int $bid): string {}

/**
 * Return the content of the char object
 * <p>Returns the content of the char object.</p>
 * @param int $bid <p>The char object-id.</p>
 * @return string <p>Returns the contents as a string, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-get-char.php
 * @see ifx_get_blob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_get_char(int $bid): string {}

/**
 * Get the contents of sqlca.sqlerrd[0..5] after a query
 * <p>Returns a pseudo-row with sqlca.sqlerrd[0] ... sqlca.sqlerrd[5] after the query associated with <code>result_id</code>.</p><p>For inserts, updates and deletes the values returned are those as set by the server after executing the query. This gives access to the number of affected rows and the serial insert value. For <i>SELECT</i>s the values are those saved after the <i>PREPARE</i> statement. This gives access to the &#42;estimated&#42; number of affected rows. The use of this function saves the overhead of executing a <i>SELECT dbinfo('sqlca.sqlerrdx')</i> query, as it retrieves the values that were saved by the ifx driver at the appropriate moment.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid result id returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return array <p>Returns an associative array with the following entries: <i>sqlerrd0</i>, <i>sqlerrd1</i>, <i>sqlerrd2</i>, <i>sqlerrd3</i>, <i>sqlerrd4</i> and <i>sqlerrd5</i>.</p>
 * @link http://php.net/manual/en/function.ifx-getsqlca.php
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_getsqlca($result_id): array {}

/**
 * Formats all rows of a query into a HTML table
 * <p>Formats and prints all rows of the <code>result_id</code> query into a HTML table.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @param string $html_table_options <p>This optional argument is a string of &lt;table&gt; tag options.</p>
 * @return int <p>Returns the number of fetched rows, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-htmltbl-result.php
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_htmltbl_result($result_id, string $html_table_options = NULL): int {}

/**
 * Sets the default return value on a fetch row
 * <p>Sets the default return value of a NULL-value on a fetch row.</p>
 * @param int $mode <p>Mode "0" returns "", and mode "1" returns "<b><code>NULL</code></b>".</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-nullformat.php
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_nullformat(int $mode): bool {}

/**
 * Returns the number of columns in the query
 * <p>After preparing or executing a query, this call gives you the number of columns in the query.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return int <p>Returns the number of columns in query for <code>result_id</code>, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-num-fields.php
 * @see ifx_num_rows()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_num_fields($result_id): int {}

/**
 * Count the rows already fetched from a query
 * <p>Gives the number of rows fetched so far for a query with <code>result_id</code> after a <code>ifx_query()</code> or <code>ifx_do()</code> query.</p>
 * @param resource $result_id <p><code>result_id</code> is a valid resultid returned by <code>ifx_query()</code> or <code>ifx_prepare()</code> (select type queries only!).</p>
 * @return int <p>Returns the number of fetched rows or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-num-rows.php
 * @see ifx_num_fields()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_num_rows($result_id): int {}

/**
 * Open persistent Informix connection
 * <p><b>ifx_pconnect()</b> acts very much like <code>ifx_connect()</code> with two major differences.</p><p>First, when connecting, the function would first try to find a (persistent) link that's already open with the same host, username and password. If one is found, an identifier for it will be returned instead of opening a new connection.</p><p>Second, the connection to the SQL server will not be closed when the execution of the script ends. Instead, the link will remain open for future use (<code>ifx_close()</code> will not close links established by <b>ifx_pconnect()</b>).</p><p>This type of links is therefore called 'persistent'.</p>
 * @param string $database <p>The database name, as a string.</p>
 * @param string $userid <p>The username, as a string.</p>
 * @param string $password <p>The password, as a string.</p>
 * @return resource <p>Returns: valid Informix persistent link identifier on success, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-pconnect.php
 * @see ifx_connect()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_pconnect(string $database = NULL, string $userid = NULL, string $password = NULL) {}

/**
 * Prepare an SQL-statement for execution
 * <p>Prepares a <code>query</code> for later use with <code>ifx_do()</code>.</p><p>For "select-type" queries a cursor is declared and opened. Non-select queries are "execute immediate".</p><p>For either query type the number of (estimated or real) affected rows is saved for retrieval by <code>ifx_affected_rows()</code>.</p><p>If the contents of the TEXT (or BYTE) column allow it, you can also use <i>ifx_textasvarchar(1)</i> and <i>ifx_byteasvarchar(1)</i>. This allows you to treat TEXT (or BYTE) columns just as if they were ordinary (but long) VARCHAR columns for select queries, and you don't need to bother with blob id's.</p><p>With <i>ifx_textasvarchar(0)</i> or <i>ifx_byteasvarchar(0)</i> (the default situation), select queries will return BLOB columns as blob id's (integer value). You can get the value of the blob as a string or file with the blob functions (see below).</p>
 * @param string $query <p>The query string.</p>
 * @param resource $link_identifier <p>The link identifier.</p>
 * @param int $cursor_def <p>This optional parameter allows you to make this a <i>scroll</i> and/or <i>hold</i> cursor. It's a bitmask and can be either <b><code>IFX_SCROLL</code></b>, <b><code>IFX_HOLD</code></b>, or both or'ed together.</p>
 * @param mixed $blobidarray <p>If you have BLOB (BYTE or TEXT) columns in the query, you can add a <code>blobidarray</code> parameter containing the corresponding "blob ids", and you should replace those columns with a "&#63;" in the query text.</p>
 * @return resource <p>Returns a valid result identifier for use by <code>ifx_do()</code>, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-prepare.php
 * @see ifx_do()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_prepare(string $query, $link_identifier, int $cursor_def = NULL, $blobidarray) {}

/**
 * Send Informix query
 * <p>Sends a <code>query</code> to the currently active database on the server that's associated with the specified link identifier.</p><p>For "select-type" queries a cursor is declared and opened. Non-select queries are "execute immediate".</p><p>For either query type the number of (estimated or real) affected rows is saved for retrieval by <code>ifx_affected_rows()</code>.</p><p>If the contents of the TEXT (or BYTE) column allow it, you can also use <i>ifx_textasvarchar(1)</i> and <i>ifx_byteasvarchar(1)</i>. This allows you to treat TEXT (or BYTE) columns just as if they were ordinary (but long) VARCHAR columns for select queries, and you don't need to bother with blob id's.</p><p>With <i>ifx_textasvarchar(0)</i> or <i>ifx_byteasvarchar(0)</i> (the default situation), select queries will return BLOB columns as blob id's (integer value). You can get the value of the blob as a string or file with the blob functions (see below).</p>
 * @param string $query <p>The query string.</p>
 * @param resource $link_identifier <p>The link identifier.</p>
 * @param int $cursor_type
 * @param mixed $blobidarray <p>If you have BLOB (BYTE or TEXT) columns in the query, you can add a <code>blobidarray</code> parameter containing the corresponding "blob ids", and you should replace those columns with a "&#63;" in the query text.</p>
 * @return resource <p>Returns valid Informix result identifier on success, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifx-query.php
 * @see ifx_connect()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_query(string $query, $link_identifier, int $cursor_type = NULL, $blobidarray = NULL) {}

/**
 * Set the default text mode
 * <p>Sets the default text mode for all select-queries.</p>
 * @param int $mode <p>Mode "0" will return a blob id, and mode "1" will return a varchar with text content.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-textasvarchar.php
 * @see ifx_byteasvarchar()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_textasvarchar(int $mode): bool {}

/**
 * Updates the content of the blob object
 * <p>Updates the content of the blob object for the given blob object <code>bid</code>.</p>
 * @param int $bid <p>A BLOB object identifier.</p>
 * @param string $content <p>The new data, as a string.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-update-blob.php
 * @see ifx_update_char()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_update_blob(int $bid, string $content): bool {}

/**
 * Updates the content of the char object
 * <p>Updates the content of the char object for the given char object <code>bid</code>.</p>
 * @param int $bid <p>A char object identifier.</p>
 * @param string $content <p>The new data, as a string.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifx-update-char.php
 * @see ifx_update_blob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifx_update_char(int $bid, string $content): bool {}

/**
 * Deletes the slob object
 * <p>Deletes the slob object on the given slob object-id <code>bid</code>.</p>
 * @param int $bid <p>An existing slob id.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifxus-close-slob.php
 * @see ifxus_open_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_close_slob(int $bid): bool {}

/**
 * Creates an slob object and opens it
 * <p>Creates an slob object and opens it.</p>
 * @param int $mode <p>A combination of <b><code>IFX_LO_RDONLY</code></b>, <b><code>IFX_LO_WRONLY</code></b>, <b><code>IFX_LO_APPEND</code></b> <b><code>IFX_LO_RDWR</code></b>, <b><code>IFX_LO_BUFFER</code></b>, <b><code>IFX_LO_NOBUFFER</code></b>.</p>
 * @return int <p>Return the new slob object-id, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifxus-create-slob.php
 * @see ifxus_close_slob(), ifxus_free_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_create_slob(int $mode): int {}

/**
 * Deletes the slob object
 * <p>Deletes the slob object.</p>
 * @param int $bid <p>An existing slob id.</p>
 * @return bool <p>Returns <b><code>TRUE</code></b> on success or <b><code>FALSE</code></b> on failure.</p>
 * @link http://php.net/manual/en/function.ifxus-free-slob.php
 * @see ifxus_close_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_free_slob(int $bid): bool {}

/**
 * Opens an slob object
 * <p>Opens an slob object. <code>bid</code> should be an existing slob id.</p>
 * @param int $bid <p>An existing slob id.</p>
 * @param int $mode <p>A combination of <b><code>IFX_LO_RDONLY</code></b>, <b><code>IFX_LO_WRONLY</code></b>, <b><code>IFX_LO_APPEND</code></b> <b><code>IFX_LO_RDWR</code></b>, <b><code>IFX_LO_BUFFER</code></b>, <b><code>IFX_LO_NOBUFFER</code></b>.</p>
 * @return int <p>Returns the new slob object-id, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifxus-open-slob.php
 * @see ifxus_close_slob(), ifxus_free_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_open_slob(int $bid, int $mode): int {}

/**
 * Reads nbytes of the slob object
 * <p>Reads <code>nbytes</code> of the slob object.</p>
 * @param int $bid <p>An existing slob id.</p>
 * @param int $nbytes <p>The number of bytes to read.</p>
 * @return string <p>Returns the slob contents as a string, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifxus-read-slob.php
 * @see ifxus_write_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_read_slob(int $bid, int $nbytes): string {}

/**
 * Sets the current file or seek position
 * <p>Sets the current file or seek position of an open slob object.</p>
 * @param int $bid <p>An existing slob id.</p>
 * @param int $mode <p>0 = LO_SEEK_SET, 1 = LO_SEEK_CUR, 2 = LO_SEEK_END.</p>
 * @param int $offset <p>A byte offset.</p>
 * @return int <p>Returns the seek position as an integer, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifxus-seek-slob.php
 * @see ifxus_tell_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_seek_slob(int $bid, int $mode, int $offset): int {}

/**
 * Returns the current file or seek position
 * <p>Returns the current file or seek position of an open slob object</p>
 * @param int $bid <p>An existing slob id.</p>
 * @return int <p>Returns the seek position as an integer, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifxus-tell-slob.php
 * @see ifxus_seek_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_tell_slob(int $bid): int {}

/**
 * Writes a string into the slob object
 * <p>Writes a string into the slob object.</p>
 * @param int $bid <p>An existing slob id.</p>
 * @param string $content <p>The content to write, as a string.</p>
 * @return int <p>Returns the bytes written as an integer, or <b><code>FALSE</code></b> on errors.</p>
 * @link http://php.net/manual/en/function.ifxus-write-slob.php
 * @see ifxus_read_slob()
 * @since PHP 4, PHP 5 < 5.2.1
 */
function ifxus_write_slob(int $bid, string $content): int {}

define('IFX_HOLD', null);

define('IFX_LO_APPEND', null);

define('IFX_LO_BUFFER', null);

define('IFX_LO_NOBUFFER', null);

define('IFX_LO_RDONLY', null);

define('IFX_LO_RDWR', null);

define('IFX_LO_WRONLY', null);

define('IFX_SCROLL', null);

