/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.algorithms;

import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.XAReadTask;
import com.sun.enterprise.web.connector.grizzly.algorithms.StreamAlgorithmBase;
import com.sun.enterprise.web.connector.grizzly.handlers.ContentLengthHandler;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import org.apache.tomcat.util.buf.Ascii;

public class ContentLengthAlgorithm
extends StreamAlgorithmBase {
    protected static final byte[] POST_METHOD = "post".getBytes();
    protected static final byte[] PUT_METHOD = "put".getBytes();
    protected static final byte[] CL_HEADER = "content-length".getBytes();
    public byte[] ascbuf = new byte[8192];
    protected int lastValid;
    protected int pos;
    protected boolean isFound = false;
    protected boolean requestLineParsed = false;
    public int startReq = -1;
    public int lengthReq = -1;

    public ContentLengthAlgorithm() {
        this.handler = embeddedInGlassFish ? new ContentLengthHandler(this) : new StreamAlgorithmBase.DummyHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(ByteBuffer byteBuffer) {
        boolean bl;
        block14: {
            block13: {
                this.isFound = false;
                this.curLimit = byteBuffer.limit();
                this.curPosition = byteBuffer.position();
                if (this.contentLength != -1) {
                    boolean bl2 = this.isFound = this.contentLength + this.headerLength <= byteBuffer.position();
                    if (this.isFound) {
                        byteBuffer.flip();
                    }
                    return this.isFound;
                }
                if (byteBuffer.position() != 0) break block13;
                boolean bl3 = false;
                Object var5_6 = null;
                byteBuffer.limit(this.curLimit);
                byteBuffer.position(this.curPosition);
                if (this.isFound) {
                    byteBuffer.flip();
                }
                return bl3;
            }
            byteBuffer.flip();
            this.lastValid = byteBuffer.limit();
            if (this.requestLineParsed) break block14;
            this.requestLineParsed = this.parseRequestLine(byteBuffer);
            if (this.requestLineParsed) break block14;
            boolean bl4 = false;
            Object var5_7 = null;
            byteBuffer.limit(this.curLimit);
            byteBuffer.position(this.curPosition);
            if (this.isFound) {
                byteBuffer.flip();
            }
            return bl4;
        }
        try {
            while (this.parseHeader(byteBuffer)) {
            }
            this.isFound = this.headerLength != -1 && this.isFound ? this.contentLength + this.headerLength <= byteBuffer.limit() : false;
            bl = this.isFound;
            Object var5_8 = null;
        }
        catch (BufferUnderflowException bue) {
            boolean bl5;
            try {
                SelectorThread.logger().log(Level.SEVERE, "readTask.bufferunderflow", bue);
                bl5 = false;
                Object var5_9 = null;
                byteBuffer.limit(this.curLimit);
            }
            catch (Throwable throwable) {
                block15: {
                    Object var5_10 = null;
                    byteBuffer.limit(this.curLimit);
                    byteBuffer.position(this.curPosition);
                    if (!this.isFound) break block15;
                    byteBuffer.flip();
                }
                throw throwable;
            }
            byteBuffer.position(this.curPosition);
            if (this.isFound) {
                byteBuffer.flip();
            }
            return bl5;
        }
        byteBuffer.limit(this.curLimit);
        byteBuffer.position(this.curPosition);
        if (this.isFound) {
            byteBuffer.flip();
        }
        return bl;
    }

    protected boolean parseRequestLine(ByteBuffer byteBuffer) {
        byte b;
        int start = 0;
        byte chr = 0;
        if (this.state == 0) {
            do {
                if (this.pos < this.lastValid) continue;
                return false;
            } while ((chr = byteBuffer.get(this.pos++)) == 13 || chr == 10);
            this.state = 1;
            --this.pos;
            byteBuffer.position(this.pos);
        }
        start = this.pos;
        boolean space = false;
        if (this.state == 1) {
            while (!space) {
                byte c;
                if (this.pos >= this.lastValid) {
                    return false;
                }
                this.ascbuf[this.pos] = c = byteBuffer.get(this.pos);
                if (c == 32) {
                    space = true;
                    if (!(this.isFound || this.findBytes(this.ascbuf, start, this.pos, POST_METHOD) != -1 && this.findBytes(this.ascbuf, start, this.pos, PUT_METHOD) != -1)) {
                        this.isFound = true;
                    }
                }
                ++this.pos;
            }
            this.state = 2;
        }
        start = this.pos;
        int end = 0;
        space = false;
        boolean eol = false;
        int questionPos = -1;
        if (this.state == 2) {
            while (!space) {
                if (this.pos >= this.lastValid) {
                    return false;
                }
                this.ascbuf[this.pos] = b = byteBuffer.get(this.pos);
                if (b == 32) {
                    space = true;
                    end = this.pos;
                } else if (b == 13 || b == 10) {
                    eol = true;
                    space = true;
                    end = this.pos;
                } else if (b == 63 && questionPos == -1) {
                    questionPos = this.pos;
                }
                ++this.pos;
            }
            this.state = 3;
            this.startReq = start;
            this.lengthReq = questionPos >= 0 ? questionPos - start : end - start;
        }
        if (this.state == 3) {
            start = this.pos;
            end = 0;
            while (!eol) {
                if (this.pos >= this.lastValid) {
                    return false;
                }
                b = byteBuffer.get(this.pos);
                if (b == 13) {
                    end = this.pos;
                } else if (b == 10) {
                    if (end == 0) {
                        end = this.pos;
                    }
                    eol = true;
                }
                ++this.pos;
            }
            this.state = 4;
        }
        return eol;
    }

    protected boolean parseHeader(ByteBuffer byteBuffer) {
        boolean headerFound = false;
        byte chr = 0;
        if (this.state == 4) {
            while (true) {
                if (this.pos >= this.lastValid) {
                    return false;
                }
                chr = byteBuffer.get(this.pos);
                if (chr != 13 && chr != 10) break;
                if (chr == 10) {
                    ++this.pos;
                    this.headerLength = this.pos;
                    this.isFound = true;
                    this.state = 4;
                    return false;
                }
                ++this.pos;
            }
            this.state = 5;
        }
        int start = this.pos;
        if (this.state == 5) {
            boolean colon = false;
            while (!colon) {
                if (this.pos >= this.lastValid) {
                    return false;
                }
                chr = byteBuffer.get(this.pos);
                if (chr == 58) {
                    colon = true;
                    if (this.contentLength == -1 && this.findBytes(this.ascbuf, start, start + (this.pos - start), CL_HEADER) != -1) {
                        headerFound = true;
                    }
                }
                if (chr >= 65 && chr <= 90) {
                    chr = (byte)(chr - -32);
                }
                this.ascbuf[this.pos] = chr;
                ++this.pos;
            }
            this.state = 6;
        }
        start = this.pos;
        int realPos = this.pos;
        boolean eol = false;
        boolean validLine = true;
        while (validLine) {
            boolean space = true;
            if (this.state == 6) {
                while (space) {
                    if (this.pos >= this.lastValid) {
                        return false;
                    }
                    chr = byteBuffer.get(this.pos);
                    if (chr == 32 || chr == 9) {
                        ++this.pos;
                        continue;
                    }
                    space = false;
                }
                this.state = 7;
            }
            int lastSignificantChar = realPos;
            if (this.state == 7) {
                while (!eol) {
                    if (this.pos >= this.lastValid) {
                        return false;
                    }
                    chr = byteBuffer.get(this.pos);
                    if (chr != 13) {
                        if (chr == 10) {
                            eol = true;
                        } else if (chr == 32) {
                            ++realPos;
                        } else {
                            lastSignificantChar = ++realPos;
                        }
                    }
                    ++this.pos;
                }
                this.state = 8;
                realPos = lastSignificantChar;
            }
            if (this.state != 8) continue;
            if (this.pos >= this.lastValid) {
                return false;
            }
            chr = byteBuffer.get(this.pos);
            if (chr != 32 && chr != 9) {
                validLine = false;
            } else {
                eol = false;
                ++realPos;
            }
            this.state = 4;
        }
        if (headerFound) {
            byteBuffer.position(start + 1);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < realPos - start; ++i) {
                sb.append((char)byteBuffer.get());
            }
            this.contentLength = Integer.parseInt(sb.toString());
        }
        return true;
    }

    protected int findBytes(byte[] buff, int start, int end, byte[] b) {
        byte first = b[0];
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower((int)buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower((int)buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    public void recycle() {
        this.contentLength = -1;
        this.headerLength = -1;
        this.curLimit = -1;
        this.curPosition = -1;
        this.pos = 0;
        this.lastValid = 0;
        this.requestLineParsed = false;
        this.isFound = false;
        this.state = 0;
        this.lengthReq = -1;
        this.startReq = -1;
        this.socketChannel = null;
        if (this.handler != null) {
            this.handler.attachChannel(null);
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public Class getReadTask(SelectorThread selectorThread) {
        return XAReadTask.class;
    }
}

