/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.ValidationResult;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XsdBasedValidator
implements Validator {
    protected abstract Schema getSchema(Model var1);

    @Override
    public ValidationResult validate(Model model, Validation validation, Validation.ValidationType validationType) {
        Schema schema = this.getSchema(model);
        if (schema == null) {
            return null;
        }
        Handler handler = new Handler(model);
        this.validate(model, schema, handler);
        Collection<Validator.ResultItem> results = handler.getResultItems();
        List<Model> validateds = Collections.singletonList(model);
        return new ValidationResult(results, validateds);
    }

    protected Source getSource(Model model, Handler handler) {
        Source source = (Source)model.getModelSource().getLookup().lookup(Source.class);
        if (source != null) {
            return source;
        }
        File file = (File)model.getModelSource().getLookup().lookup(File.class);
        if (file == null) {
            return null;
        }
        try {
            source = new SAXSource(new InputSource(new FileInputStream(file)));
            source.setSystemId(file.toURI().toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (source == null) {
            String msg = NbBundle.getMessage(XsdBasedValidator.class, (String)"MSG_NoSAXSource");
            handler.logValidationErrors(Validator.ResultType.WARNING, msg);
        }
        return source;
    }

    protected void validate(Model model, Schema schema, Handler handler) {
        javax.xml.validation.Validator validator = schema.newValidator();
        Source source = this.getSource(model, handler);
        if (source != null) {
            validator.setErrorHandler(handler);
            assert (source instanceof SAXSource || source instanceof DOMSource) : "Source is not instance of SAXSource or DOMSource";
            try {
                validator.validate(source);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "validate", ex);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    protected Schema getCompiledSchema(InputStream[] schemas, LSResourceResolver lsResourceResolver) {
        Schema schema = null;
        Source[] schemaStreamSources = new StreamSource[schemas.length];
        for (int index1 = 0; index1 < schemas.length; ++index1) {
            schemaStreamSources[index1] = new StreamSource(schemas[index1]);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(lsResourceResolver);
        try {
            schema = schemaFactory.newSchema(schemaStreamSources);
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "getCompiledSchema", ex);
        }
        return schema;
    }

    protected Schema getCompiledSchema(Source[] schemas, LSResourceResolver lsResourceResolver, ErrorHandler errorHandler) {
        Schema schema = null;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setResourceResolver(lsResourceResolver);
        schemaFactory.setErrorHandler(errorHandler);
        try {
            schema = schemaFactory.newSchema(schemas);
        }
        catch (SAXException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "getCompiledSchema", ex);
        }
        return schema;
    }

    public DocumentModel resolveResource(String systemId, Model currentModel) {
        return null;
    }

    protected class Handler
    implements ErrorHandler {
        private Collection<Validator.ResultItem> resultItems;
        private List<Integer> linePositions = null;
        private DocumentModel model;
        private HashMap<DocumentModel, Handler> relatedHandlers = new HashMap();

        public Handler(Model model) {
            assert (model instanceof DocumentModel) : "Invalid model class";
            this.resultItems = new ArrayList<Validator.ResultItem>();
            this.model = (DocumentModel)model;
        }

        public Collection<Validator.ResultItem> getResultItems() {
            this.addResultsFromHandlers(this.relatedHandlers.values());
            return this.resultItems;
        }

        public void addResultsFromHandlers(Collection<Handler> handlers) {
            for (Handler handler : handlers) {
                this.resultItems.addAll(handler.getResultItems());
            }
        }

        private void setupLinePositions() {
            this.linePositions = new ArrayList<Integer>();
            Document document = ((AbstractDocumentModel)this.model).getBaseDocument();
            if (document == null) {
                return;
            }
            try {
                String str = document.getText(0, document.getLength() - 1);
                String[] lines = str.split("\n");
                this.linePositions.add(-1);
                int pos = 0;
                for (String line : lines) {
                    this.linePositions.add(pos);
                    pos += line.length() + 1;
                }
            }
            catch (BadLocationException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "setupLinePositions", e);
            }
        }

        private int getPosition(int lineNumber, int columnNumber) {
            if (this.linePositions == null) {
                this.setupLinePositions();
            }
            if (lineNumber < 1 || lineNumber > this.linePositions.size()) {
                return 0;
            }
            Integer beginningPos = this.linePositions.get(lineNumber);
            return beginningPos == null ? 0 : beginningPos + columnNumber - 1;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.logValidationErrors(Validator.ResultType.ERROR, exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.logValidationErrors(Validator.ResultType.ERROR, exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.logValidationErrors(Validator.ResultType.WARNING, exception);
        }

        public void logValidationErrors(Validator.ResultType resultType, SAXParseException sax) {
            String systemId = sax.getSystemId();
            DocumentModel errorModel = null;
            if (systemId != null) {
                errorModel = XsdBasedValidator.this.resolveResource(systemId, this.model);
            }
            Handler h = null;
            if (errorModel != null && this.model != errorModel && (h = this.relatedHandlers.get(errorModel)) == null) {
                h = new Handler(errorModel);
                this.relatedHandlers.put(errorModel, h);
            }
            if (h == null) {
                h = this;
            }
            h.logValidationErrors(resultType, sax.getMessage(), sax.getLineNumber(), sax.getColumnNumber() - 1);
        }

        public void logValidationErrors(Validator.ResultType resultType, String errorDescription, int lineNumber, int columnNumber) {
            if (columnNumber <= 0) {
                columnNumber = 1;
            }
            if (this.model.getState().equals((Object)Model.State.VALID)) {
                int position = this.getPosition(lineNumber, columnNumber);
                assert (position >= 0) : "Invalid position value " + position;
                DocumentComponent component = this.model.findComponent(position);
                if (component == null) {
                    component = this.model.getRootComponent();
                }
                this.resultItems.add(new Validator.ResultItem(XsdBasedValidator.this, resultType, component, errorDescription));
            } else {
                this.resultItems.add(new Validator.ResultItem(XsdBasedValidator.this, resultType, errorDescription, lineNumber, columnNumber, this.model));
            }
        }

        public void logValidationErrors(Validator.ResultType resultType, String errorDescription) {
            this.logValidationErrors(resultType, errorDescription, 1, 1);
        }
    }
}

