/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tm4e.core.internal.utils.CompareUtils;
import org.eclipse.tm4e.core.theme.ThemeTrieElementRule;

public class ThemeTrieElement {
    private final ThemeTrieElementRule _mainRule;
    private final List<ThemeTrieElementRule> _rulesWithParentScopes;
    private final Map<String, ThemeTrieElement> _children;

    public ThemeTrieElement(ThemeTrieElementRule mainRule) {
        this(mainRule, new ArrayList<ThemeTrieElementRule>(), new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes) {
        this(mainRule, rulesWithParentScopes, new HashMap<String, ThemeTrieElement>());
    }

    public ThemeTrieElement(ThemeTrieElementRule mainRule, List<ThemeTrieElementRule> rulesWithParentScopes, Map<String, ThemeTrieElement> children) {
        this._mainRule = mainRule;
        this._rulesWithParentScopes = rulesWithParentScopes;
        this._children = children;
    }

    private static List<ThemeTrieElementRule> _sortBySpecificity(List<ThemeTrieElementRule> arr) {
        if (arr.size() == 1) {
            return arr;
        }
        arr.sort((a, b) -> ThemeTrieElement._cmpBySpecificity(a, b));
        return arr;
    }

    private static int _cmpBySpecificity(ThemeTrieElementRule a, ThemeTrieElementRule b) {
        if (a.scopeDepth == b.scopeDepth) {
            int bParentScopesLen;
            List<String> aParentScopes = a.parentScopes;
            List<String> bParentScopes = b.parentScopes;
            int aParentScopesLen = aParentScopes == null ? 0 : aParentScopes.size();
            int n = bParentScopesLen = bParentScopes == null ? 0 : bParentScopes.size();
            if (aParentScopesLen == bParentScopesLen) {
                int i = 0;
                while (i < aParentScopesLen) {
                    int bLen;
                    int aLen = aParentScopes.get(i).length();
                    if (aLen != (bLen = bParentScopes.get(i).length())) {
                        return bLen - aLen;
                    }
                    ++i;
                }
            }
            return bParentScopesLen - aParentScopesLen;
        }
        return b.scopeDepth - a.scopeDepth;
    }

    public List<ThemeTrieElementRule> match(String scope) {
        String tail;
        String head;
        if ("".equals(scope)) {
            ArrayList<ThemeTrieElementRule> arr = new ArrayList<ThemeTrieElementRule>();
            arr.add(this._mainRule);
            arr.addAll(this._rulesWithParentScopes);
            return ThemeTrieElement._sortBySpecificity(arr);
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        if (this._children.containsKey(head)) {
            return this._children.get(head).match(tail);
        }
        ArrayList<ThemeTrieElementRule> arr = new ArrayList<ThemeTrieElementRule>();
        arr.add(this._mainRule);
        arr.addAll(this._rulesWithParentScopes);
        return ThemeTrieElement._sortBySpecificity(arr);
    }

    public void insert(int scopeDepth, String scope, List<String> parentScopes, int fontStyle, int foreground, int background) {
        ThemeTrieElement child;
        String tail;
        String head;
        if ("".equals(scope)) {
            this._doInsertHere(scopeDepth, parentScopes, fontStyle, foreground, background);
            return;
        }
        int dotIndex = scope.indexOf(46);
        if (dotIndex == -1) {
            head = scope;
            tail = "";
        } else {
            head = scope.substring(0, dotIndex);
            tail = scope.substring(dotIndex + 1);
        }
        if (this._children.containsKey(head)) {
            child = this._children.get(head);
        } else {
            child = new ThemeTrieElement(this._mainRule.clone(), ThemeTrieElementRule.cloneArr(this._rulesWithParentScopes));
            this._children.put(head, child);
        }
        child.insert(scopeDepth + 1, tail, parentScopes, fontStyle, foreground, background);
    }

    private void _doInsertHere(int scopeDepth, List<String> parentScopes, int fontStyle, int foreground, int background) {
        if (parentScopes == null) {
            this._mainRule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
            return;
        }
        int i = 0;
        int len = this._rulesWithParentScopes.size();
        while (i < len) {
            ThemeTrieElementRule rule = this._rulesWithParentScopes.get(i);
            if (CompareUtils.strArrCmp(rule.parentScopes, parentScopes) == 0) {
                rule.acceptOverwrite(scopeDepth, fontStyle, foreground, background);
                return;
            }
            ++i;
        }
        if (fontStyle == -1) {
            fontStyle = this._mainRule.fontStyle;
        }
        if (foreground == 0) {
            foreground = this._mainRule.foreground;
        }
        if (background == 0) {
            background = this._mainRule.background;
        }
        this._rulesWithParentScopes.add(new ThemeTrieElementRule(scopeDepth, parentScopes, fontStyle, foreground, background));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._children == null ? 0 : this._children.hashCode());
        result = 31 * result + (this._mainRule == null ? 0 : this._mainRule.hashCode());
        result = 31 * result + (this._rulesWithParentScopes == null ? 0 : this._rulesWithParentScopes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThemeTrieElement other = (ThemeTrieElement)obj;
        if (this._children == null ? other._children != null : !this._children.equals(other._children)) {
            return false;
        }
        if (this._mainRule == null ? other._mainRule != null : !this._mainRule.equals(other._mainRule)) {
            return false;
        }
        return !(this._rulesWithParentScopes == null ? other._rulesWithParentScopes != null : !this._rulesWithParentScopes.equals(other._rulesWithParentScopes));
    }
}

