/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.deploy.TomcatManager;
import org.netbeans.modules.tomcat5.ui.wizard.InstallPanel;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.util.TomcatUsers;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AddInstanceIterator
implements WizardDescriptor.InstantiatingIterator {
    public static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private static final String[] CONTENT_DATA = new String[]{NbBundle.getMessage(AddInstanceIterator.class, (String)"LBL_InstallationAndLoginDetails")};
    private WizardDescriptor wizard;
    private InstallPanel panel;

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public String name() {
        return null;
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String displayName = this.getDisplayName();
        String url = this.panel.getVisual().getUrl();
        String username = this.panel.getVisual().getUsername();
        String password = this.panel.getVisual().getPassword();
        try {
            InstanceProperties ip = InstanceProperties.createInstanceProperties((String)url, (String)username, (String)password, (String)displayName);
            Properties prop = this.panel.getVisual().getProperties();
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                ip.setProperty(key, prop.getProperty(key));
            }
            ip.setProperty("runningCheckTimeout", Integer.toString(2000));
            result.add(ip);
            this.checkStartupScript(this.panel.getVisual().getHomeDir());
            TomcatManager manager = null;
            try {
                manager = (TomcatManager)TomcatFactory.getInstance().getDeploymentManager(url, username, password);
            }
            catch (DeploymentManagerCreationException e) {
                Logger.getLogger(AddInstanceIterator.class.getName()).log(Level.SEVERE, null, e);
                return result;
            }
            manager.ensureCatalinaBaseReady();
            if (this.panel.getVisual().createUserEnabled()) {
                File tomcatUsersXml = new File(manager.getTomcatProperties().getCatalinaDir(), "conf/tomcat-users.xml");
                TomcatUsers.createUser(tomcatUsersXml, username, password, manager.getTomcatVersion());
            }
        }
        catch (IOException e) {
            Logger.getLogger(AddInstanceIterator.class.getName()).log(Level.WARNING, null, e);
        }
        return result;
    }

    public boolean hasPrevious() {
        return false;
    }

    public boolean hasNext() {
        return false;
    }

    public WizardDescriptor.Panel current() {
        if (this.panel == null) {
            this.panel = new InstallPanel();
        }
        this.setContentData((JComponent)this.panel.getComponent());
        this.setContentSelectedIndex((JComponent)this.panel.getComponent());
        return this.panel;
    }

    private void setContentData(JComponent component) {
        if (component.getClientProperty(PROP_CONTENT_DATA) == null) {
            component.putClientProperty(PROP_CONTENT_DATA, CONTENT_DATA);
        }
    }

    private void setContentSelectedIndex(JComponent component) {
        if (component.getClientProperty(PROP_CONTENT_SELECTED_INDEX) == null) {
            component.putClientProperty(PROP_CONTENT_SELECTED_INDEX, 0);
        }
    }

    private String getDisplayName() {
        return (String)this.wizard.getProperty(PROP_DISPLAY_NAME);
    }

    private void checkStartupScript(File homeDir) {
        String CATALINA = Utilities.isWindows() ? "catalina.bat" : "catalina.sh";
        boolean catalinaOK = new File(homeDir, "bin/" + CATALINA).exists();
        String SETCLASSPATH = Utilities.isWindows() ? "setclasspath.bat" : "setclasspath.sh";
        boolean setclasspathOK = new File(homeDir, "bin/" + SETCLASSPATH).exists();
        if (!catalinaOK || !setclasspathOK) {
            TomcatManager.TomcatVersion version;
            File bundledHome = TomcatInstallUtil.getBundledHome();
            TomcatManager.TomcatVersion tomcatVersion = version = bundledHome == null ? null : TomcatFactory.getTomcatVersion(bundledHome);
            if (version != TomcatManager.TomcatVersion.TOMCAT_55 || bundledHome == null || !bundledHome.exists()) {
                String msg = !catalinaOK && !setclasspathOK ? NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_scripts_fix_by_hand", (Object)CATALINA, (Object)SETCLASSPATH) : NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_script_fix_by_hand", (Object)(!catalinaOK ? CATALINA : SETCLASSPATH));
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            } else {
                String msg = !catalinaOK && !setclasspathOK ? NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_scripts", (Object)CATALINA, (Object)SETCLASSPATH) : NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_script", (Object)(!catalinaOK ? CATALINA : SETCLASSPATH));
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                    try {
                        if (bundledHome != null) {
                            if (!catalinaOK) {
                                FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(bundledHome, "bin/" + CATALINA)), (FileObject)FileUtil.toFileObject((File)new File(homeDir, "bin")), (String)CATALINA.substring(0, CATALINA.indexOf(".")));
                            }
                            if (!setclasspathOK) {
                                FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(bundledHome, "bin/" + SETCLASSPATH)), (FileObject)FileUtil.toFileObject((File)new File(homeDir, "bin")), (String)SETCLASSPATH.substring(0, SETCLASSPATH.indexOf(".")));
                            }
                        }
                    }
                    catch (IOException e) {
                        msg = NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_startup_scripts_copy_failed");
                        nd = new NotifyDescriptor.Message((Object)msg, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                }
            }
        }
    }
}

