/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.classpath.BootClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.CompileClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.SourceClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ClassPathProviderImpl
extends ProjectOpenedHook
implements ClassPathProvider {
    private static final Set<String> SUPPORTED_PATHS = new HashSet<String>();
    private final Map<String, SourceSetCP> groups = new HashMap<String, SourceSetCP>();
    private final Project project;
    private final PropertyChangeListener pcl;

    public ClassPathProviderImpl(Project project) {
        this.project = project;
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    GradleJavaProject p = GradleJavaProject.get(ClassPathProviderImpl.this.project);
                    if (p != null) {
                        ClassPathProviderImpl.this.updateGroups(p.getSourceSets().keySet());
                    } else {
                        ClassPathProviderImpl.this.updateGroups(Collections.emptySet());
                    }
                }
            }
        };
    }

    public ClassPath findClassPath(FileObject fo, String type) {
        GradleJavaProject prj = GradleJavaProject.get(this.project);
        if (!SUPPORTED_PATHS.contains(type) || prj == null) {
            return null;
        }
        GradleJavaSourceSet sourceSet = prj.containingSourceSet(FileUtil.toFile((FileObject)fo));
        return sourceSet != null ? this.getSourceSetPath(type, sourceSet) : null;
    }

    private ClassPath getSourceSetPath(String type, GradleJavaSourceSet sourceSet) {
        SourceSetCP scp = this.groups.get(sourceSet.getName());
        return scp != null ? scp.getClassPath(type) : null;
    }

    protected void projectOpened() {
        NbGradleProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
        GradleJavaProject p = GradleJavaProject.get(this.project);
        if (p != null) {
            this.updateGroups(p.getSourceSets().keySet());
        }
    }

    protected void projectClosed() {
        this.updateGroups(Collections.emptySet());
        NbGradleProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroups(Set<String> newGroups) {
        Map<String, SourceSetCP> map = this.groups;
        synchronized (map) {
            Iterator<Map.Entry<String, SourceSetCP>> it = this.groups.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, SourceSetCP> oldGroup = it.next();
                if (newGroups.contains(oldGroup.getKey())) continue;
                it.remove();
            }
            for (String newGroup : newGroups) {
                if (this.groups.containsKey(newGroup)) continue;
                SourceSetCP scp = new SourceSetCP(newGroup);
                this.groups.put(newGroup, scp);
            }
        }
    }

    static {
        SUPPORTED_PATHS.add("classpath/source");
        SUPPORTED_PATHS.add("classpath/boot");
        SUPPORTED_PATHS.add("classpath/compile");
        SUPPORTED_PATHS.add("classpath/execute");
        SUPPORTED_PATHS.add("classpath/processor");
    }

    private class SourceSetCP {
        final ClassPath boot;
        final ClassPath source;
        final ClassPath compile;
        final ClassPath runtime;

        SourceSetCP(String group) {
            this.boot = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImpl(ClassPathProviderImpl.this.project));
            this.source = ClassPathFactory.createClassPath((ClassPathImplementation)new SourceClassPathImpl(ClassPathProviderImpl.this.project, group));
            this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)new CompileClassPathImpl(ClassPathProviderImpl.this.project, group));
            this.runtime = ClassPathFactory.createClassPath((ClassPathImplementation)new RuntimeClassPathImpl(ClassPathProviderImpl.this.project, group));
        }

        public ClassPath getClassPath(String type) {
            switch (type) {
                case "classpath/boot": {
                    return this.boot;
                }
                case "classpath/source": {
                    return this.source;
                }
                case "classpath/compile": {
                    return this.compile;
                }
                case "classpath/execute": {
                    return this.runtime;
                }
                case "classpath/processor": {
                    return this.compile;
                }
            }
            return null;
        }
    }
}

