/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.source.CompilationInfoAccessor;

public class ElementUtils {
    public static TypeElement getTypeElementByBinaryName(CompilationInfo info, String name) {
        return ElementUtils.getTypeElementByBinaryName(CompilationInfoAccessor.getInstance().getJavacTask(info), name);
    }

    public static TypeElement getTypeElementByBinaryName(JavacTask task, String name) {
        Set<? extends ModuleElement> allModules = task.getElements().getAllModuleElements();
        Context ctx = ((JavacTaskImpl)task).getContext();
        Symtab syms = Symtab.instance(ctx);
        if (allModules.isEmpty()) {
            return ElementUtils.getTypeElementByBinaryName(task, (ModuleElement)syms.noModule, name);
        }
        TypeElement result = null;
        boolean foundInUnamedModule = false;
        for (ModuleElement moduleElement : allModules) {
            TypeElement found = ElementUtils.getTypeElementByBinaryName(task, moduleElement, name);
            if (found == null) continue;
            if ((Symbol.ModuleSymbol)moduleElement == syms.unnamedModule) {
                foundInUnamedModule = true;
            }
            if (result != null) {
                if (foundInUnamedModule) {
                    for (TypeElement elem : new TypeElement[]{result, found}) {
                        if (elem.getKind() != ElementKind.CLASS && elem.getKind() != ElementKind.INTERFACE || ((Symbol.ClassSymbol)elem).packge().modle == syms.unnamedModule) continue;
                        return elem;
                    }
                } else {
                    return null;
                }
            }
            result = found;
        }
        return result;
    }

    public static TypeElement getTypeElementByBinaryName(CompilationInfo info, ModuleElement mod, String name) {
        return ElementUtils.getTypeElementByBinaryName(CompilationInfoAccessor.getInstance().getJavacTask(info), mod, name);
    }

    public static TypeElement getTypeElementByBinaryName(JavacTask task, ModuleElement mod, String name) {
        Context ctx = ((JavacTaskImpl)task).getContext();
        Names names = Names.instance(ctx);
        Symtab syms = Symtab.instance(ctx);
        Name wrappedName = names.fromString(name);
        Symbol.ClassSymbol clazz = syms.enterClass((Symbol.ModuleSymbol)mod, wrappedName);
        try {
            clazz.complete();
            if (clazz.kind == Kinds.Kind.TYP && clazz.flatName() == wrappedName) {
                return clazz;
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            // empty catch block
        }
        return null;
    }
}

