/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.refactoring.rename;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.web.refactoring.RefactoringUtil;
import org.netbeans.modules.web.refactoring.rename.BaseWebXmlRename;
import org.netbeans.modules.web.refactoring.rename.RenameItem;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class WebXmlPackageRename
extends BaseWebXmlRename {
    private final FileObject pkg;
    private final RenameRefactoring rename;

    public WebXmlPackageRename(FileObject webDD, FileObject pkg, RenameRefactoring rename) {
        super(webDD);
        this.pkg = pkg;
        this.rename = rename;
    }

    @Override
    protected List<RenameItem> getRenameItems() {
        ArrayList<RenameItem> result = new ArrayList<RenameItem>();
        ArrayList<FileObject> fos = new ArrayList<FileObject>();
        RefactoringUtil.collectChildren(this.pkg, fos);
        for (FileObject each : fos) {
            String oldName;
            if (RefactoringUtil.isPackageInfo(each) || (oldName = JavaIdentifiers.getQualifiedName((FileObject)each)) == null) continue;
            if (JavaIdentifiers.isValidPackageName((String)oldName)) {
                String newName = RefactoringUtil.constructNewName(each, this.rename);
                if (newName == null || "".equals(newName)) {
                    result.add(new RenameItem(new Problem(true, NbBundle.getMessage(WebXmlPackageRename.class, (String)"TXT_ErrProblemWhenRenaming", (Object)oldName))));
                    continue;
                }
                result.add(new RenameItem(newName, oldName));
                continue;
            }
            String packageName = oldName.substring(0, oldName.lastIndexOf("."));
            result.add(new RenameItem(new Problem(true, NbBundle.getMessage(WebXmlPackageRename.class, (String)"TXT_ErrInvalidPackageName", (Object)packageName))));
        }
        return result;
    }

    @Override
    protected AbstractRefactoring getRefactoring() {
        return this.rename;
    }
}

