/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.api;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.java.testrunner.CommonTestUtil;
import org.netbeans.modules.junit.DefaultITPlugin;
import org.netbeans.modules.junit.DefaultPlugin;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.netbeans.modules.junit.TopClassFinder;
import org.netbeans.modules.junit.api.JUnitSettings;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class JUnitTestUtil
extends CommonTestUtil {
    private static final String JAVA_SOURCES_SUFFIX = "java";
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private static String getTestClassSuffix() {
        return JUnitSettings.TEST_CLASSNAME_SUFFIX;
    }

    private static String getIntegrationTestSuffix() {
        return JUnitSettings.INTEGRATION_TEST_CLASSNAME_SUFFIX;
    }

    private static String getTestClassPrefix() {
        return JUnitSettings.TEST_CLASSNAME_PREFIX;
    }

    private static String getTestSuiteSuffix() {
        return JUnitSettings.SUITE_CLASSNAME_SUFFIX;
    }

    private static String getTestSuitePrefix() {
        return JUnitSettings.SUITE_CLASSNAME_PREFIX;
    }

    private static String getRootSuiteName() {
        return JUnitSettings.getDefault().getRootSuiteClassName();
    }

    public static boolean canCreateTests(JUnitPlugin plugin, FileObject ... fileObjects) {
        return JUnitPluginTrampoline.DEFAULT.canCreateTests(plugin, fileObjects);
    }

    public static FileObject[] createTests(JUnitPlugin plugin, FileObject[] filesToTest, FileObject targetRoot, Map<CommonPlugin.CreateTestParam, Object> params) {
        return JUnitPluginTrampoline.DEFAULT.createTests(plugin, filesToTest, targetRoot, params);
    }

    public static boolean createTestActionCalled(JUnitPlugin plugin, FileObject[] filesToTest) {
        return JUnitPluginTrampoline.DEFAULT.createTestActionCalled(plugin, filesToTest);
    }

    public static String getTestClassFullName(String sourceClassName, String packageName) {
        String shortTestClassName = JUnitTestUtil.getTestClassName(sourceClassName);
        return packageName == null || packageName.length() == 0 ? shortTestClassName : packageName.replace('.', '/') + '/' + shortTestClassName;
    }

    public static String getTestClassName(String sourceClassName) {
        return JUnitTestUtil.getTestClassPrefix() + sourceClassName + JUnitTestUtil.getTestClassSuffix();
    }

    public static String getIntegrationTestClassName(String sourceClassName) {
        return JUnitTestUtil.getTestClassPrefix() + sourceClassName + JUnitTestUtil.getIntegrationTestSuffix();
    }

    public static String convertPackage2SuiteName(String packageFileName) {
        if (packageFileName.length() == 0) {
            return JUnitTestUtil.getRootSuiteName();
        }
        int index = packageFileName.lastIndexOf(47);
        String pkg = index > -1 ? packageFileName.substring(index + 1) : packageFileName;
        pkg = pkg.substring(0, 1).toUpperCase() + pkg.substring(1);
        return packageFileName + "/" + JUnitTestUtil.getTestSuitePrefix() + pkg + JUnitTestUtil.getTestSuiteSuffix();
    }

    public static String convertPackage2ITSuiteName(String packageFileName) {
        if (packageFileName.length() == 0) {
            return JUnitTestUtil.getRootSuiteName();
        }
        int index = packageFileName.lastIndexOf(47);
        String pkg = index > -1 ? packageFileName.substring(index + 1) : packageFileName;
        pkg = pkg.substring(0, 1).toUpperCase() + pkg.substring(1);
        return packageFileName + "/" + JUnitTestUtil.getTestSuitePrefix() + pkg + JUnitTestUtil.getIntegrationTestSuffix() + JUnitTestUtil.getTestSuiteSuffix();
    }

    public static String convertClass2TestName(String classFileName) {
        int index = classFileName.lastIndexOf(47);
        String pkg = index > -1 ? classFileName.substring(0, index) : "";
        String clazz = index > -1 ? classFileName.substring(index + 1) : classFileName;
        clazz = clazz.substring(0, 1).toUpperCase() + clazz.substring(1);
        if (pkg.length() > 0) {
            pkg = pkg + "/";
        }
        return pkg + JUnitTestUtil.getTestClassPrefix() + clazz + JUnitTestUtil.getTestClassSuffix();
    }

    public static void notifyUser(String msg) {
        JUnitTestUtil.notifyUser(msg, 0);
    }

    public static void notifyUser(String msg, int messageType) {
        NotifyDescriptor.Message descr = new NotifyDescriptor.Message((Object)msg, messageType);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
    }

    public static boolean isClassTest(CompilationInfo compilationInfo, TypeElement classElem) {
        return JUnitTestUtil.isClassImplementingTestInterface(compilationInfo, classElem);
    }

    public static boolean isClassImplementingTestInterface(CompilationInfo compilationInfo, TypeElement classElem) {
        String testIfaceFullName = "junit.framework.Test";
        TypeElement testIface = compilationInfo.getElements().getTypeElement(testIfaceFullName);
        if (testIface == null) {
            String msg = "junit: TestUtil.isClassImplementingTestInterface(...) could not find TypeElement for " + testIfaceFullName;
            Logger.getLogger("global").log(Level.FINE, msg);
            return false;
        }
        return compilationInfo.getTypes().isSubtype(classElem.asType(), testIface.asType());
    }

    public static boolean isClassException(CompilationInfo compilationInfo, TypeElement classElem) {
        String throwableFullName = "java.lang.Throwable";
        TypeElement throwable = compilationInfo.getElements().getTypeElement(throwableFullName);
        if (throwable == null) {
            String msg = "junit: TestUtil.isClassException(...) could not find TypeElement for " + throwableFullName;
            Logger.getLogger("global").log(Level.SEVERE, msg);
            return false;
        }
        return compilationInfo.getTypes().isSubtype(classElem.asType(), throwable.asType());
    }

    public static ClassTree findMainClass(CompilationInfo compInfo) {
        String className = compInfo.getFileObject().getName();
        CompilationUnitTree compUnitTree = compInfo.getCompilationUnit();
        String shortClassName = JUnitTestUtil.getSimpleName(className);
        for (Tree tree : compUnitTree.getTypeDecls()) {
            ClassTree clazz;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(clazz = (ClassTree)tree).getSimpleName().toString().equals(shortClassName)) continue;
            return clazz;
        }
        return null;
    }

    static String fileToClassName(String fileName) {
        if (fileName.endsWith(".java")) {
            return fileName.substring(0, fileName.length() - 5).replace('/', '.');
        }
        return null;
    }

    public static List<String> getJavaFileNames(FileObject packageFolder, ClasspathInfo cpInfo) {
        List<ElementHandle<TypeElement>> topClasses;
        FileObject[] children = packageFolder.getChildren();
        if (children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> javaFiles = new ArrayList<FileObject>(children.length);
        for (FileObject child : children) {
            if (child.isFolder() || !child.isValid() || !child.getMIMEType().equals(JAVA_MIME_TYPE)) continue;
            javaFiles.add(child);
        }
        if (javaFiles.isEmpty()) {
            return Collections.emptyList();
        }
        FileObject[] javaFilesArr = javaFiles.size() == children.length ? children : javaFiles.toArray(new FileObject[javaFiles.size()]);
        JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])javaFilesArr);
        if (source == null) {
            ErrorManager.getDefault().log(4096, "Could not get JavaSource for files " + javaFilesArr);
            return Collections.emptyList();
        }
        try {
            topClasses = TopClassFinder.findMainTopClasses(source);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            topClasses = null;
        }
        if (topClasses == null || topClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(topClasses.size());
        for (ElementHandle<TypeElement> topClassHandle : topClasses) {
            result.add(topClassHandle.getQualifiedName());
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    public static String createNewName(int i, Set usedNames) {
        String ret;
        while (usedNames.contains(ret = "p" + i++)) {
        }
        return ret;
    }

    public static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static JUnitPlugin getPluginForProject(Project project) {
        Object pluginObj = project.getLookup().lookup(JUnitPlugin.class);
        return pluginObj != null ? (JUnitPlugin)((Object)pluginObj) : new DefaultPlugin();
    }

    public static JUnitPlugin getITPluginForProject(Project project) {
        Object pluginObj = project.getLookup().lookup(JUnitPlugin.class);
        return pluginObj != null ? (JUnitPlugin)((Object)pluginObj) : new DefaultITPlugin();
    }

    static String getPackageName(String fullName) {
        int i = fullName.lastIndexOf(46);
        return i != -1 ? fullName.substring(0, i) : "";
    }

    public static String getSimpleName(String fullName) {
        if (fullName == null) {
            return null;
        }
        int lastDotIndex = fullName.lastIndexOf(46);
        return lastDotIndex == -1 ? fullName : fullName.substring(lastDotIndex + 1);
    }

    private JUnitTestUtil() {
    }

    public static String getSourceLevel(FileObject file) {
        ClassPath srcCP = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        if (srcCP == null) {
            return null;
        }
        FileObject srcRoot = srcCP.findOwnerRoot(file);
        if (srcRoot == null) {
            return null;
        }
        return SourceLevelQuery.getSourceLevel((FileObject)srcRoot);
    }

    public static boolean areAnnotationsSupported(FileObject file) {
        return JUnitTestUtil.areAnnotationsSupported(JUnitTestUtil.getSourceLevel(file));
    }

    public static boolean areAnnotationsSupported(String sourceLevel) {
        return sourceLevel != null && sourceLevel.compareTo("1.5") >= 0;
    }
}

