/*
 * Decompiled with CFR 0.152.
 */
package shared;

import prpobjects.uruobj;
import shared.Flt;
import shared.IBytestream;
import shared.RGBA;
import uru.Bytedeque;
import uru.context;

public class Quat
extends uruobj {
    public Flt w;
    public Flt x;
    public Flt y;
    public Flt z;

    public Quat(IBytestream c) {
        this.w = new Flt(c);
        this.x = new Flt(c);
        this.y = new Flt(c);
        this.z = new Flt(c);
    }

    public Quat(float w, float x, float y, float z) {
        this.w = new Flt(w);
        this.x = new Flt(x);
        this.y = new Flt(y);
        this.z = new Flt(z);
    }

    private Quat() {
    }

    public static Quat readXYZW(IBytestream c) {
        Quat result = new Quat();
        result.x = new Flt(c);
        result.y = new Flt(c);
        result.z = new Flt(c);
        result.w = new Flt(c);
        return result;
    }

    public Quat(context c) {
        if (c.readversion == 6 || c.readversion == 4 || c.readversion == 7) {
            this.w = new Flt(c);
            this.x = new Flt(c);
            this.y = new Flt(c);
            this.z = new Flt(c);
        } else if (c.readversion == 3) {
            this.w = new Flt(c);
            this.x = new Flt(c);
            this.y = new Flt(c);
            this.z = new Flt(c);
        }
    }

    public static Quat identity() {
        return new Quat(new Flt(0), new Flt(0), new Flt(0), new Flt(1));
    }

    public static Quat identityW() {
        return new Quat(new Flt(1), new Flt(0), new Flt(0), new Flt(0));
    }

    public Quat(Flt w2, Flt x2, Flt y2, Flt z2) {
        this.w = w2;
        this.x = x2;
        this.y = y2;
        this.z = z2;
    }

    @Override
    public void compile(Bytedeque data) {
        this.w.compile(data);
        this.x.compile(data);
        this.y.compile(data);
        this.z.compile(data);
    }

    public String toString() {
        return this.w.toString() + ":" + this.x.toString() + ":" + this.y.toString() + ":" + this.z.toString();
    }

    public static Quat read(IBytestream c) {
        return new Quat(c);
    }

    public static Quat readBigEndian(IBytestream c) {
        Quat r = new Quat();
        r.w = Flt.readBigEndian(c);
        r.x = Flt.readBigEndian(c);
        r.y = Flt.readBigEndian(c);
        r.z = Flt.readBigEndian(c);
        return r;
    }

    public RGBA convertToRGBA() {
        return new RGBA(this.w.toJavaFloat(), this.x.toJavaFloat(), this.y.toJavaFloat(), this.z.toJavaFloat());
    }
}

