/*
 * Decompiled with CFR 0.152.
 */
package pythondec;

import java.util.Arrays;
import pythondec.PyObject;
import shared.IBytedeque;
import shared.IBytestream;
import shared.uncaughtexception;

public class PyUnicode
extends PyObject {
    public int n;
    public byte[] rawstr;

    public PyUnicode(IBytestream c) {
        this.n = c.readInt();
        this.rawstr = c.readBytes(this.n);
    }

    private PyUnicode() {
    }

    public String toString() {
        return "PyUnicode: " + this.toJavaString();
    }

    public String toJavaString() {
        try {
            return new String(this.rawstr, "UTF-8");
        }
        catch (Exception e2) {
            throw new uncaughtexception("unable to convert UTF-8 string");
        }
    }

    public void marshal(IBytedeque c) {
        c.writeByte((byte)117);
        c.writeInt(this.n);
        c.writeBytes(this.rawstr);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawstr);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PyUnicode)) {
            return false;
        }
        PyUnicode o2 = (PyUnicode)o;
        return Arrays.equals(o2.rawstr, this.rawstr);
    }

    public boolean compare(PyObject o2) {
        return this.equals(o2);
    }
}

