/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.util.log.Log;

public class HttpHeaderValues
extends BufferCache {
    public static final String CLOSE = "close";
    public static final String CHUNKED = "chunked";
    public static final String GZIP = "gzip";
    public static final String IDENTITY = "identity";
    public static final String KEEP_ALIVE = "keep-alive";
    public static final String CONTINUE = "100-continue";
    public static final String PROCESSING = "102-processing";
    public static final String TE = "TE";
    public static final String BYTES = "bytes";
    public static final String NO_CACHE = "no-cache";
    public static final String UPGRADE = "Upgrade";
    public static final int CLOSE_ORDINAL = 1;
    public static final int CHUNKED_ORDINAL = 2;
    public static final int GZIP_ORDINAL = 3;
    public static final int IDENTITY_ORDINAL = 4;
    public static final int KEEP_ALIVE_ORDINAL = 5;
    public static final int CONTINUE_ORDINAL = 6;
    public static final int PROCESSING_ORDINAL = 7;
    public static final int TE_ORDINAL = 8;
    public static final int BYTES_ORDINAL = 9;
    public static final int NO_CACHE_ORDINAL = 10;
    public static final int UPGRADE_ORDINAL = 11;
    public static final HttpHeaderValues CACHE;
    public static final Buffer CLOSE_BUFFER;
    public static final Buffer CHUNKED_BUFFER;
    public static final Buffer GZIP_BUFFER;
    public static final Buffer IDENTITY_BUFFER;
    public static final Buffer KEEP_ALIVE_BUFFER;
    public static final Buffer CONTINUE_BUFFER;
    public static final Buffer PROCESSING_BUFFER;
    public static final Buffer TE_BUFFER;
    public static final Buffer BYTES_BUFFER;
    public static final Buffer NO_CACHE_BUFFER;
    public static final Buffer UPGRADE_BUFFER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block6: {
            CACHE = new HttpHeaderValues();
            CLOSE_BUFFER = CACHE.add(CLOSE, 1);
            CHUNKED_BUFFER = CACHE.add(CHUNKED, 2);
            GZIP_BUFFER = CACHE.add(GZIP, 3);
            IDENTITY_BUFFER = CACHE.add(IDENTITY, 4);
            KEEP_ALIVE_BUFFER = CACHE.add(KEEP_ALIVE, 5);
            CONTINUE_BUFFER = CACHE.add(CONTINUE, 6);
            PROCESSING_BUFFER = CACHE.add(PROCESSING, 7);
            TE_BUFFER = CACHE.add(TE, 8);
            BYTES_BUFFER = CACHE.add(BYTES, 9);
            NO_CACHE_BUFFER = CACHE.add(NO_CACHE, 10);
            UPGRADE_BUFFER = CACHE.add(UPGRADE, 11);
            int index = 100;
            CACHE.add(GZIP, index++);
            CACHE.add("gzip,deflate", index++);
            CACHE.add("deflate", index++);
            InputStream ua = HttpHeaderValues.class.getResourceAsStream("/org/eclipse/jetty/http/useragents");
            try {
                if (ua == null) break block6;
                try {
                    LineNumberReader in = new LineNumberReader(new InputStreamReader(ua));
                    String line = in.readLine();
                    while (line != null) {
                        CACHE.add(line, index++);
                        line = in.readLine();
                    }
                }
                finally {
                    ua.close();
                }
            }
            catch (Exception e2) {
                Log.warn(e2.toString());
                Log.debug(e2);
            }
        }
    }
}

