/*
 * Decompiled with CFR 0.152.
 */
package gui;

import com.sun.java.swing.plaf.motif.MotifLookAndFeel;
import gui.CommandLine;
import gui.Gui;
import gui.Plugins;
import java.awt.EventQueue;
import java.awt.SplashScreen;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import shared.ExceptionUtils;
import shared.FileUtils;
import shared.GuiUtils;
import shared.JarUtils;
import shared.RandomUtils;
import shared.m;
import shared.uncaughtexception;

public class Main
extends JFrame {
    public static Gui guiform;
    static String javaversion;
    static double javaversion2;
    static String os;
    static String osversion;
    static double osversion2;
    static long maxmemory;
    static long requiredmemory;
    public static Runnable debugcheck;
    static String jarpath;
    static File thisJarsFile;
    static long id;
    static final boolean updateenabled = true;
    static int requestedheapsize;
    static final boolean debugupdate = false;

    public static boolean isVistaPlus() {
        return os.toLowerCase().startsWith("windows") && osversion2 > 5.1;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e2) {
                String threadname = t.getName();
                String estring = ExceptionUtils.ExceptionToString(e2);
                String msg = "Exception in thread: \"" + threadname + "\"\n" + estring;
                m.err(msg);
                if (threadname.equals("main")) {
                    JOptionPane.showMessageDialog(null, msg, "Uncaught Exception", 0, null);
                }
            }
        });
        Main.main2(args);
    }

    public static void main2(String[] args) {
        Main.debug("New Drizzle instance started...");
        requiredmemory = 629145600L;
        requestedheapsize = 800;
        try {
            maxmemory = Runtime.getRuntime().maxMemory();
        }
        catch (Exception e2) {
            // empty catch block
        }
        String islauncherstr = System.getProperty("Drizzle.IsLauncher", "true");
        boolean isLauncher = Boolean.parseBoolean(islauncherstr);
        if (maxmemory >= requiredmemory) {
            isLauncher = false;
        }
        String isupdaterstr = System.getProperty("Drizzle.IsUpdater", "false");
        boolean isUpdater = Boolean.parseBoolean(isupdaterstr);
        Main.debug("Maxmemory: " + Long.toString(maxmemory) + " Requiredmemory: " + Long.toString(requiredmemory));
        Main.debug("isLauncher: " + Boolean.toString(isLauncher) + " isUpdater: " + Boolean.toString(isUpdater));
        jarpath = JarUtils.GetJarPath(Main.class);
        if (jarpath == null) {
            m.err("Jarpath is null.");
        }
        thisJarsFile = new File(jarpath);
        Main.debug("thisJarFile: " + jarpath);
        Main.PerformUpdate(args, thisJarsFile.getParent(), false);
        if (isLauncher) {
            Main.LaunchDrizzle(jarpath, args, requestedheapsize);
        } else if (isUpdater) {
            int numretries = 10;
            int mstowait = 2000;
            boolean success = false;
            String genericJar = thisJarsFile.getParent() + "/Drizzle.jar";
            int numtries = 0;
            while (true) {
                try {
                    Main.debug("Trying to overwrite Drizzle.jar from main...");
                    FileUtils.DeleteFile(genericJar, true);
                    if (FileUtils.Exists(genericJar)) {
                        throw new uncaughtexception("Drizzle.jar isn't deleted yet.");
                    }
                    FileUtils.CopyFile(thisJarsFile.getAbsolutePath(), genericJar, true, false, true);
                    success = true;
                }
                catch (Exception e3) {
                    Main.debug("Error while updating Drizzle. It seems Drizzle.jar did not close.");
                    m.err("Error while updating Drizzle. It seems Drizzle.jar did not close.");
                    e3.printStackTrace();
                    if (++numtries > numretries) {
                        Main.debug("Giving up on Drizzle.jar overwriting...");
                        boolean ok = GuiUtils.getOKorCancelFromUserDos(m.trans("Please make sure there are no other copies of Drizzle running, and hit OK to try again."), m.trans("Problem updating"));
                        if (!ok) break;
                    }
                    try {
                        Thread.sleep(mstowait);
                    }
                    catch (Exception e4) {}
                    continue;
                }
                break;
            }
            if (success) {
                Main.LaunchDrizzle(genericJar, args, requestedheapsize);
            }
        } else {
            Main.debug("Normal start...");
            try {
                javaversion = System.getProperty("java.specification.version");
                System.out.println("Using JRE version: " + javaversion);
                javaversion2 = Double.parseDouble(javaversion);
            }
            catch (Exception e5) {
                // empty catch block
            }
            try {
                os = System.getProperty("os.name");
            }
            catch (Exception e6) {
                // empty catch block
            }
            try {
                osversion = System.getProperty("os.version");
                osversion2 = Double.parseDouble(osversion);
            }
            catch (Exception e7) {
                // empty catch block
            }
            Plugins.initialise();
            if (args.length > 0) {
                System.out.println("Using the commandline interface!");
                Main.CloseSplashScreen();
                CommandLine.HandleArguments(args);
            } else {
                try {
                    MotifLookAndFeel laf = new MotifLookAndFeel();
                    UIManager.setLookAndFeel(laf);
                    GuiUtils.setCrossPlatformFonts(true);
                }
                catch (Exception e8) {
                    boolean dummy = false;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        guiform = new Gui();
                        if (debugcheck != null) {
                            debugcheck.run();
                        }
                        guiform.setVisible(true);
                    }
                });
            }
        }
    }

    public static void PerformUpdate(String[] args, String installDir, boolean warnAboutRestart) {
        boolean firstInstall = !new File(installDir + "/Drizzle.jar").exists();
        boolean thisIsGenericDrizzle = thisJarsFile.getName().equals("Drizzle.jar");
        VersionsInfo info = Main.FindUpdatedDrizzleJar(new File(installDir));
        boolean doupdate = info.launchUpdater != null && (firstInstall || thisIsGenericDrizzle);
        Main.debug("Performing Update...");
        Main.debug("firstInstall: " + Boolean.toString(firstInstall));
        Main.debug("doupdate: " + Boolean.toString(doupdate));
        Main.debug("hasDrizzleExe: " + Boolean.toString(info.hasDrizzleExe));
        Main.debug("maxjar: " + info.maxjar);
        Main.debug("installDir: " + installDir);
        Main.debug("launchUpdater: " + info.launchUpdater);
        if (doupdate && guiform != null) {
            guiform.SaveSettingsIfApplicable();
        }
        if (info.hasDrizzleExe && info.maxjar != null && firstInstall) {
            Main.debug("Attempting to overwrite Drizzle.jar...");
            String from = info.maxjar;
            String to = installDir + "/Drizzle.jar";
            FileUtils.CopyFile(from, to, false, false, true);
            from = thisJarsFile.getParent() + "/" + ".drizzlesettings.canbedeleted.dat";
            to = installDir + "/" + ".drizzlesettings.canbedeleted.dat";
            if (FileUtils.Exists(from) && !FileUtils.Exists(to)) {
                FileUtils.CopyFile(from, to, false, false, false);
            }
        }
        if (doupdate) {
            try {
                int i;
                if (warnAboutRestart) {
                    GuiUtils.DisplayMessage(m.trans("Restarting to update Drizzle..."), m.trans("Drizzle is about to restart, in order to update itself.  You should use the Drizzle.exe (or less preferably, Drizzle.jar) file in the 'Drizzle' subfolder of Uru to start it.  Please don't get confused and use copies elsewhere, and think they are updated; you can always see which version you're using at the top of Drizzle.  And don't forget to have fun :D"));
                }
                String[] command = new String[]{"java", "-Xmx" + Integer.toString(requestedheapsize) + "m", "-DDrizzle.IsUpdater=true", "-jar", info.launchUpdater};
                String[] fullcommand = new String[command.length + args.length];
                for (i = 0; i < command.length; ++i) {
                    fullcommand[i] = command[i];
                }
                for (i = 0; i < args.length; ++i) {
                    fullcommand[command.length + i] = args[i];
                }
                Main.debug("Calling updater...");
                Process proc = Runtime.getRuntime().exec(fullcommand);
                System.exit(0);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else if (info.launchUpdater != null) {
            m.msg("You have a newer version of Drizzle installed.  Perhaps you want to use that?  It's located at: ", info.launchUpdater);
        }
    }

    private static void LaunchDrizzle(String drizzlefilename, String[] args, int requestedheapsize) {
        Main.debug("Launching another Drizzle...");
        try {
            int i;
            File ffile = new File(drizzlefilename);
            String file = ffile.getAbsolutePath();
            String[] command = new String[]{"java", "-Xmx" + Integer.toString(requestedheapsize) + "m", "-DDrizzle.IsLauncher=false", "-jar", file};
            String[] fullcommand = new String[command.length + args.length];
            for (i = 0; i < command.length; ++i) {
                fullcommand[i] = command[i];
            }
            for (i = 0; i < args.length; ++i) {
                fullcommand[command.length + i] = args[i];
            }
            final Process proc = Runtime.getRuntime().exec(fullcommand);
            if (args.length > 0) {
                m.StreamRedirector.Redirect(proc);
            }
            if (args.length > 0) {
                Main.CloseSplashScreen();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        proc.destroy();
                    }
                });
                proc.waitFor();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static Integer getVersionFromFilename(String filename) {
        if (!filename.startsWith("Drizzle")) {
            return null;
        }
        if (!filename.endsWith(".jar")) {
            return null;
        }
        String verstr = filename.substring(7, filename.length() - 4);
        if (verstr.equals("")) {
            return null;
        }
        try {
            int r = Integer.parseInt(verstr);
            return r;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static VersionsInfo FindUpdatedDrizzleJar(File installDir) {
        int thisver = 31;
        int maxver = -1;
        File maxjar = null;
        if (installDir.exists()) {
            for (File f : installDir.listFiles()) {
                String curfilename = f.getName();
                Integer ver = Main.getVersionFromFilename(curfilename);
                if (ver == null || ver <= maxver) continue;
                maxver = ver;
                maxjar = f;
            }
        }
        boolean hasDrizzleExe = FileUtils.Exists(installDir + "/Drizzle.exe");
        VersionsInfo r = new VersionsInfo();
        if (maxver != -1) {
            r.maxver = maxver;
        }
        if (maxjar != null) {
            r.maxjar = maxjar.getAbsolutePath();
        }
        if (maxver > thisver) {
            r.launchUpdater = r.maxjar;
        }
        r.hasDrizzleExe = hasDrizzleExe;
        return r;
    }

    private static void CloseSplashScreen() {
        try {
            SplashScreen splashscreen = SplashScreen.getSplashScreen();
            if (splashscreen != null) {
                splashscreen.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void debug(String msg) {
    }

    static {
        javaversion = "";
        javaversion2 = 0.0;
        os = "";
        osversion = "";
        osversion2 = 0.0;
        maxmemory = 0L;
        id = RandomUtils.rng.nextLong();
    }

    private static class VersionsInfo {
        Integer maxver;
        String maxjar;
        String launchUpdater;
        boolean hasDrizzleExe;

        private VersionsInfo() {
        }
    }
}

