/*
 * Decompiled with CFR 0.152.
 */
package uam;

import gui.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import shared.FileUtils;
import shared.m;
import uam.DownloadErrorException;
import uam.GuiModal;

public class ThreadDownloader
extends Thread {
    String urlstr;
    OutputStream out;
    boolean doCancel = false;
    boolean doPause = false;
    boolean wasSuccessful = false;
    String outputfilename = null;
    GuiModal window;

    GuiModal getwindow() {
        if (this.window == null) {
            this.window = new GuiModal(null, true, this);
        }
        return this.window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean downloadAsFile(String url, String filename) {
        FileOutputStream out = null;
        File f = new File(filename);
        String folder = f.getParent();
        FileUtils.CreateFolder(folder);
        out = new FileOutputStream(filename);
        ThreadDownloader td = new ThreadDownloader(url, out);
        td.outputfilename = new File(filename).getParent();
        FileUtils.CreateFolder(td.outputfilename);
        td.start();
        td.joinEvenIfInterrupted();
        boolean bl = td.wasSuccessful;
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException e2) {
            m.err("Unable to close FileOutputStream.");
        }
        return bl;
        catch (FileNotFoundException e3) {
            boolean bl2;
            try {
                m.err("Error opening file for saving: ", e3.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e4) {
                    m.err("Unable to close FileOutputStream.");
                }
                throw throwable;
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e5) {
                m.err("Unable to close FileOutputStream.");
            }
            return bl2;
        }
    }

    public static byte[] downloadAsBytes(String url) {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        ThreadDownloader td = new ThreadDownloader(url, baout);
        td.start();
        td.joinEvenIfInterrupted();
        byte[] result = baout.toByteArray();
        try {
            baout.close();
        }
        catch (IOException e2) {
            m.err("Unable to close ByteArrayOutputStream.");
        }
        if (td.wasSuccessful) {
            return result;
        }
        return null;
    }

    public void joinEvenIfInterrupted() {
        boolean joined = false;
        while (!joined) {
            try {
                this.join();
                joined = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ThreadDownloader threadDownloader = this;
        synchronized (threadDownloader) {
            this.doCancel = true;
            if (this.doPause) {
                this.unpause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsafecancel() {
        ThreadDownloader threadDownloader = this;
        synchronized (threadDownloader) {
            this.doCancel = true;
            this.stop();
            this.getwindow().setVisible(false);
            m.warn("You shouldn't use 'Unsafe Cancel' if at all possible.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        ThreadDownloader threadDownloader = this;
        synchronized (threadDownloader) {
            this.doPause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpause() {
        ThreadDownloader threadDownloader = this;
        synchronized (threadDownloader) {
            this.doPause = false;
            this.notifyAll();
        }
    }

    public ThreadDownloader(String urlstr, OutputStream out) {
        this.setName("ThreadDownloader:" + this.getName());
        this.urlstr = urlstr;
        this.out = out;
        this.getwindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.getwindow().showButDontBlock();
        this.getwindow().finishedShowingMonitor.waitCorrectly();
        int sConnectTimeout = 10;
        int sReadTimeout = 10;
        int buffersize = 4096;
        try {
            int contentlength;
            InputStream in;
            URL url;
            try {
                this.urlstr = this.urlstr.replace(" ", "%20");
                url = new URL(this.urlstr);
            }
            catch (MalformedURLException e2) {
                throw new DownloadErrorException("The server address is invalid.");
            }
            if (!url.getProtocol().equals("http") && !url.getProtocol().equals("ftp")) {
                throw new DownloadErrorException("The server has an unhandled protocol; it should be either http or ftp.");
            }
            try {
                URLConnection conn = url.openConnection();
                conn.setRequestProperty("User-Agent", "Java/" + Version.GetJavaVersion() + " (" + Version.GetVersion() + ")");
                conn.setConnectTimeout(sConnectTimeout * 1000);
                conn.setReadTimeout(sReadTimeout * 1000);
                conn.setAllowUserInteraction(false);
                in = conn.getInputStream();
                contentlength = conn.getContentLength();
                if (contentlength == -1) {
                    m.msg("Server doesn't support progress status.");
                } else if (this.outputfilename != null && !FileUtils.HasFreeSpace(this.outputfilename, (long)contentlength)) {
                    throw new DownloadErrorException("There doesn't appear to be enough disk space to download this.");
                }
            }
            catch (IOException e3) {
                if (e3 instanceof SocketTimeoutException) {
                    throw new DownloadErrorException("Unable to open connection.");
                }
                if (e3 instanceof FileNotFoundException) {
                    throw new DownloadErrorException("The server doesn't have the expected file, check the address.");
                }
                if (e3 instanceof UnknownHostException) {
                    throw new DownloadErrorException("The server is either not running, or the name of the server is wrong, or your network connection is down.");
                }
                throw new DownloadErrorException(e3.getMessage());
            }
            byte[] buffer = new byte[buffersize];
            int read = 0;
            int transferred = 0;
            while (read != -1) {
                if (contentlength != -1 && contentlength != 0) {
                    int prog = (int)(1000L * (long)transferred / (long)contentlength);
                    this.getwindow().setProgress(prog);
                }
                ThreadDownloader prog = this;
                synchronized (prog) {
                    if (this.doCancel) {
                        break;
                    }
                }
                prog = this;
                synchronized (prog) {
                    while (this.doPause) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e4) {}
                    }
                }
                try {
                    try {
                        read = in.read(buffer);
                    }
                    catch (SocketTimeoutException e5) {
                        read = 0;
                    }
                    if (read <= 0) continue;
                    this.out.write(buffer, 0, read);
                    transferred += read;
                }
                catch (IOException e6) {
                    if (e6 instanceof SocketException) {
                        throw new DownloadErrorException("Connection reset; possible problem with network connection or server.");
                    }
                    if (e6 instanceof IOException && e6.getMessage().equals("There is not enough space on the disk")) {
                        throw new DownloadErrorException("Not enough free disk space.  Free some up, then try again.");
                    }
                    throw new DownloadErrorException("Error while reading.");
                }
            }
            try {
                this.out.flush();
                in.close();
            }
            catch (IOException e7) {
                throw new DownloadErrorException("Unable to close connection.");
            }
            this.wasSuccessful = read == -1;
        }
        catch (DownloadErrorException e8) {
            this.wasSuccessful = false;
        }
        this.getwindow().setVisible(false);
    }
}

